/*************************************************************************
**
**  Copyright 1982-2008 Pervasive Software Inc. All Rights Reserved
**
*************************************************************************/
/***************************************************************************
  dbinfo.c
    This is a simple sample designed to allow you to confirm your
    ability to compile, link, and execute a DTI application for
    your target environment using your compiler tools.
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <btitypes.h>
#include <dticonst.h>
#include <config.h>
#include <connect.h>
#include <catalog.h>

int main(int argc, char* argv[]) {
    BTI_SINT      rc;
    BTI_CHAR      szBuffer[512];
    BTI_ULONG     ulSize      = sizeof(szBuffer);
    BTI_LONG      lConnection = 0xFFFFFFFF;
    BTI_CHAR_PTR  uName = ""; 
    BTI_CHAR_PTR  pword = ""; 
    BTI_CHAR_PTR  svrName = "";
    BTI_CHAR_PTR  svr = "";

    // for PvGetDBNamesData() and PvGetDBName()
    BTI_ULONG count;
    BTI_ULONG i = 1;
    BTI_CHAR dbName[BDB_SIZE_DBNAME+10];  
    BTI_ULONG dbNameSize = 1000; 

    // for DSNS
    BTI_WORD        res = 0; 
    BTI_ULONG       dsnCount = 0; 
    BTI_ULONG       dsnListSize = 0; 
    BTI_CHAR        * dsnList; 

    rc = PvStart(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStart. Error code: %d\n", rc);
		return;
	}
    if (argc > 2)
	{ 
      svrName = argv[1];
	  uName = argv[2]; 
	  pword = argv[3]; 
	}
     else 
        { 
         if (argv[1] != NULL) svrName = argv[1];
         else {
                printf("Usage:  dbinfo servername [username] [password]\n");
                return;
               }
             
        }

	printf("\n");
	printf("ServerName: %s \n",svrName); 
	printf("UserName: %s \n",uName); 
	printf("Password: %s \n",pword); 
	printf("\n");
	
    rc = PvConnectServer(svrName,uName,pword,&lConnection); 
	if (rc!= P_OK)
	{
		printf ("Error on PvConnectServer. Error code: %d\n", rc);
		return;
	}
	printf("PvConnectServer OK.\n");

    rc = PvGetServerName(lConnection, &ulSize, szBuffer);
	if (rc!= P_OK)
	{
		printf ("Error on PvGetServerName. Error code: %d\n", rc);
		return;
	}
        printf("PvGetServerName OK.  ServerName: %s\n",szBuffer);


// ----------- START / CONNECT DONE -------------------------------

	printf("\nDB Names on %s\n\n", svrName);

	rc = PvGetDbNamesData(lConnection, &count); 
	if (rc!= P_OK)
	{
		printf ("Error on PvGetDbNamesData. Error code: %d\n", rc);
		return;
	}

	for (i=1; i< count+1; i++) 
    { 
       rc = PvGetDbName(lConnection, i, &dbNameSize, dbName); 
       if (rc!= P_OK)
       {
	   printf ("Error on PvGetDbName. Error code: %d\n", rc);
	   return;
	   }
        printf("%s\n", dbName);
	}  

 
// MAX_DSN_NAME_LENGTH is defined to be 32 in catalog.h 

	printf("\nDSNs on %s\n\n", svrName);

	rc = PvCountDSNs (lConnection, &dsnCount, 1); 

	printf("Number of DSNs = %d\n",dsnCount);

	dsnListSize = dsnCount * (MAX_DSN_NAME_LENGTH+1); 

    dsnList = (char *)malloc(sizeof(char) * dsnListSize);
    
	rc = PvListDSNs(lConnection, &dsnListSize, dsnList, 1); 
	if (rc!= P_OK)
	{
	 printf ("Error on PvListDSNs. Error code: %d\n", rc);
	 return;
	}	

	printf("DSN List: %s",dsnList);
    free(dsnList);
// ------------ STOP ----------------------------------
 
    rc = PvStop(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStop. Error code: %d\n", rc);
		return;
	}
	printf("\n\nPvStop OK.\n");

return;
}

