/*************************************************************************
**
**  Copyright 1982-2008 Pervasive Software Inc. All Rights Reserved
**
*************************************************************************/
/***************************************************************************
  license.c
    This is a simple sample designed to allow you to confirm your
    ability to compile, link, and execute a DTI application for
    your target environment using your compiler tools.
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <btitypes.h>
#include <dticonst.h>
#include <config.h>
#include <connect.h>
#include <catalog.h>
#include <dtilicense.h>
  
int main(int argc, char* argv[]) {

    BTI_SINT      rc;
    BTI_CHAR      szBuffer[512];
    BTI_ULONG     ulSize      = sizeof(szBuffer);
    BTI_LONG      lConnection = 0xFFFFFFFF;
    BTI_CHAR_PTR  uName = ""; 
    BTI_CHAR_PTR  pword = ""; 
    BTI_CHAR_PTR  svrName = "";
    BTI_CHAR_PTR  svr = "";
    BTI_CHAR_PTR  lic = "ERXVD3U4ZS9KR94QPDHV5BN2";
    BTI_CHAR_PTR  liccmd = "";
    BTI_SINT      addflag;

// ---------  START ------------------------------------//

    rc = PvStart(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStart. Error code: %d\n", rc);
		return;
	}
    if (argc > 2)
	{ 
      svrName = argv[1];
	  liccmd  = argv[2];
	}
     else 
        { 
         if (argv[1] != NULL) 
		 {
           svrName = argv[1];
           liccmd  = argv[2];
		 }
         else 
		 {
           printf("Usage: license servername add|del \n");
           return;
		 }
        }

    rc = PvConnectServer(svrName,uName,pword,&lConnection); 
	if (rc!= P_OK)
	{
		printf ("Error on PvConnectServer. Error code: %d\n", rc);
		return;
	}
	printf("PvConnectServer OK.\n");

    rc = PvGetServerName(lConnection, &ulSize, szBuffer);

	if (rc!= P_OK)
	{
		printf ("Error on PvGetServerName. Error code: %d\n", rc);
		return;
	}
        printf("PvGetServerName OK.  ServerName: %s\n",szBuffer);


// ----------- START / CONNECT DONE -------------------------------

addflag = strcmp(liccmd, "add");

if (addflag==0) {

       rc = PvAddLicense(lConnection, lic); 
       if (rc!= P_OK)
        	{
		printf ("Error on PvAddLicense. Error code: %d\n\n", rc);
		return;
          	}

       printf("\nTest License key (zero users) added.\n");
       printf("Key = %s.\nUse 'clilcadm -i' command to verify.\n\n", lic);
           }

  else if (addflag !=0) {

  rc = PvDeleteLicense(lConnection, lic); 

  if (rc!= P_OK)
	{
		printf ("Error on PvDeleteLicense. Error code: %d\n\n", rc);
		return;
	}
   printf("\nTest License key (zero users) removed.\n");
   printf("Key = %s.\nUse 'clilcadm -i' command to verify.\n\n", lic);
    }

else {

printf("Invalid license command\n");
return;

}


// ------------ STOP ----------------------------------
    rc = PvStop(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStop. Error code: %d\n", rc);
		return;
	}
	printf("PvStop OK.\n");

return;
}

