/*************************************************************************
**
**  Copyright 1982-2008 Pervasive Software Inc. All Rights Reserved
**
*************************************************************************/
/***************************************************************************
  mkdeinfo.c
    This is a simple sample designed to allow you to confirm your
    ability to compile, link, and execute a DTI application for
    your target environment using your compiler tools.
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <btitypes.h>
#include <dticonst.h>
#include <config.h>
#include <connect.h>
#include <catalog.h>

#pragma pack(1)


typedef struct tagPVMKDEUSAGE 
{ 
   BTI_ULONG   currentLicensesInUse;  
     // Number of licenses currently in use. 
   BTI_ULONG   peakLicensesInUse; 
     // Peak number of licenses in use 
   BTI_ULONG   maxLicenses;  
     // Maximum number of licenses. 
   BTI_WORD    curFilesInUse;  
    // Number of active files currently in use. 
   BTI_WORD    peakFilesInUse;  
    // Peak number of active files in use 
   BTI_WORD    maxFiles;  
    // Maximum number of active files. 
   BTI_WORD    curHandlesInUse;  
    // Number of active file handles  
    // currently in use (NetWare only). 
   BTI_WORD    peakHandlesInUse;  
    // Peak number of active file handles  
    // in use (NetWare only). 
   BTI_WORD    maxHandles;  
    // Maximum number of active file handles  
    // (NetWare only). 
   BTI_WORD    curTransInUse;  
    // Number of transactions currently in use. 
   BTI_WORD    peakTransInUse;  
    // Peak number of transactions in use. 
   BTI_WORD    maxTrans;  
    // Maximum number of transactions in use. 
   BTI_WORD    curClients;  
    // Number of clients currently accessing  
    // the MicroKernel. 
   BTI_WORD    peakClients;  
    // Peak number of clients accessing the 
    // MicroKernel. 
   BTI_WORD    maxClients;  
    // Maximum number of clients accessing 
    // the MicroKernel. 
   BTI_WORD    curThreads;  
    // Number of active threads currently in use. 
   BTI_WORD    peakThreads;  
    //Peak number of active threads in use. 
   BTI_WORD    maxThreads;  
    // Maximum number of active threads in use. 
   BTI_WORD    curLocksInUse;  
    // Number of record locks currently in use. 
   BTI_WORD    peakLocksInUse;  
    // Peak number of record locks in use. 
} PVMKDEUSAGE; 


#pragma pack()


int main(int argc, char* argv[]) {

    BTI_SINT      rc;
    BTI_CHAR      szBuffer[512];
    BTI_ULONG     ulSize      = sizeof(szBuffer);
    BTI_LONG      lConnection = 0xFFFFFFFF;
    BTI_CHAR_PTR  uName = ""; 
    BTI_CHAR_PTR  pword = ""; 
    BTI_CHAR_PTR  svrName = "";
    BTI_CHAR_PTR  svr = "";

    PVMKDEUSAGE usageinfo;


// ---------  START ------------------------------------//


    rc = PvStart(0);

	if (rc!= P_OK)
	{
		printf ("Error on PvStart. Error code: %d\n", rc);
		return;
	}
    if (argc > 2)
	{ 
     svrName = argv[1];
	  uName = argv[2]; 
	  pword = argv[3]; 
	}
     else 
        { 
       
            if (argv[1] != NULL) svrName = argv[1];
            else 
			 {
                printf("Usage:  mkdeinfo servername \n");
                return;
             }
        }
	
    rc = PvConnectServer(svrName,uName,pword,&lConnection); 
	if (rc!= P_OK)
	{
		printf ("Error on PvConnectServer. Error code: %d\n", rc);
		return;
	}

	printf("PvConnectServer OK.\n");

    rc = PvGetServerName(lConnection, &ulSize, szBuffer);
	if (rc!= P_OK)
	{
		printf ("Error on PvGetServerName. Error code: %d\n", rc);
		return;
	}
        printf("PvGetServerName OK.  ServerName: %s\n",szBuffer);


// ----------- START / CONNECT DONE -------------------------------

printf("\n\nMicroKernel Usage Information\n");
printf("-----------------------------\n\n");

rc = PvGetMkdeUsage(lConnection, &usageinfo); 

printf("Current licenses       = %d\n",   usageinfo.currentLicensesInUse);
printf("Peak licenses          = %d\n",   usageinfo.peakLicensesInUse);
printf("Max licenses           = %d\n\n",  usageinfo.maxLicenses);

printf("Current files          = %d\n",   usageinfo.curFilesInUse);
printf("Peak files             = %d\n",   usageinfo.peakFilesInUse);
printf("Max files              = %d\n\n", usageinfo.maxFiles);

printf("Current handles        = %d\n",   usageinfo.curHandlesInUse);
printf("Peak handles           = %d\n",   usageinfo.peakHandlesInUse);
printf("Max handles            = %d\n\n", usageinfo.maxHandles);

printf("Current transactions   = %d\n",   usageinfo.curTransInUse);
printf("Peak transactions      = %d\n",   usageinfo.peakTransInUse);
printf("Max transactions       = %d\n\n", usageinfo.maxTrans);

printf("Current clients        = %d\n",   usageinfo.curClients);
printf("Peak clients           = %d\n",   usageinfo.peakClients);
printf("Max clients            = %d\n\n", usageinfo.maxClients);
  
printf("Current threads        = %d\n",   usageinfo.curThreads);
printf("Peak threads           = %d\n",   usageinfo.peakThreads);
printf("Max threads            = %d\n\n", usageinfo.maxThreads);

printf("Current locks          = %d\n",   usageinfo.curLocksInUse);
printf("Peak locks             = %d\n\n", usageinfo.peakLocksInUse);

// ------------ STOP ----------------------------------

    rc = PvStop(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStop. Error code: %d\n", rc);
		return;
	}
	printf("PvStop OK.\n");

return;
}

