Option Strict Off
Option Explicit On 

Imports System.Environment
Imports System.Runtime.InteropServices
Imports System.Text
Imports System.Convert
Imports System.Globalization

Module Module1
	
	Public Const BOPEN As Short = 0
	Public Const BCLOSE As Short = 1
	Public Const BINSERT As Short = 2
	Public Const BUPDATE As Short = 3
	Public Const BDELETE As Short = 4
	Public Const BGETEQUAL As Short = 5
	Public Const BGETNEXT As Short = 6
	Public Const BGETPREVIOUS As Short = 7
	Public Const BGETFIRST As Short = 12
	Public Const BGETLAST As Short = 13
	Public Const BBEGINTRAN As Short = 19
	Public Const BENDTRAN As Short = 20
	Public Const BABORTTRAN As Short = 21
	Public Const BSTEPFIRST As Short = 33
	Public Const BSTEPNEXT As Short = 24
	Public Const BSTEPLAST As Short = 34
	Public Const BSTEPPREVIOUS As Short = 35
	Public Const BSTOP As Short = 25
    Public Const BRESET As Short = 28

    Public Const POSBLK_LEN As Short = 128
    Public Const KEY_BUF_LEN As Short = 255
    Public Const KEY0_LEN As Short = 7
    Public Const KEY1_LEN As Short = 20

    ' Structure is value type while Object and String are reference type
    <StructLayout(LayoutKind.Sequential, Pack:=1, CharSet:=CharSet.Ansi)> Structure VBSInt
        Dim B1 As Byte
        Dim B2 As Byte
    End Structure

    ' Physical storage structure
    <StructLayout(LayoutKind.Sequential, Pack:=1, CharSet:=CharSet.Ansi)> Structure BtrCourseRecType
        <VBFixedString(7), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=7)> Public Name As String
        Dim DescriptionNull As Byte
        <VBFixedString(50), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=50)> Public Description As String
        Dim Credit_HoursNull As Byte
        Dim Credit_Hours As VBSInt
        <VBFixedString(20), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=20)> Public Dept_Name As String
    End Structure

    ' Application structure
    <StructLayout(LayoutKind.Sequential, Pack:=1, CharSet:=CharSet.Ansi)> Structure CourseRecType
        ' extra one for NULL terminator
        <VBFixedString(8), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=8)> Public Name As String
        ' extra one for NULL terminator
        <VBFixedString(51), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=51)> Public Description As String
        ' extra one for NULL terminator
        Dim Credit_Hours As VBSInt
        ' extra one for NULL terminator
        <VBFixedString(21), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=21)> Public Dept_Name As String
    End Structure

    Private PosBlock(POSBLK_LEN - 1) As Byte 
    Private KeyBuf As New VB6.FixedLengthString(KEY_BUF_LEN)
    Private KeyBufLen As Short
    Private DataBufLen As Short
    Private Bstat As Short
    Private KeyNum As Short
    Private Course As CourseRecType
    Private CourseRec As CourseRecType

    Declare Sub CopyMemory Lib "KERNEL32" Alias "RtlMoveMemory" (ByRef Destination As Short, ByRef Source As VBSInt, ByVal NumBytesToCopy As Integer)
    Declare Sub CopyMemory Lib "KERNEL32" Alias "RtlMoveMemory" (ByRef Destination As VBSInt, ByRef Source As Short, ByVal NumBytesToCopy As Integer)

    'Declare Function BTRCALL Lib "w64btrv.dll" (ByVal Opcode As Short, ByVal Cursor() As Byte, ByVal DataBuffer As IntPtr, ByRef DataBufferLength As Short, ByVal KeyBuffer() As Byte, ByVal KeyLength As Short, ByVal KeyNum As Short) As Short
    'Declare Function BTRCALL Lib "w64btrv.dll" (ByVal Opcode As Short, ByVal Cursor() As Byte, ByRef DataBuffer As Object, ByRef DataBufferLength As Short, ByVal KeyBuffer() As Byte, ByVal KeyLength As Short, ByVal KeyNum As Short) As Short

    Declare Function BTRCALL Lib "w3btrv7.dll" (ByVal Opcode As Short, ByVal Cursor() As Byte, ByVal DataBuffer As IntPtr, ByRef DataBufferLength As Short, ByVal KeyBuffer() As Byte, ByVal KeyLength As Short, ByVal KeyNum As Short) As Short
    Declare Function BTRCALL Lib "w3btrv7.dll" (ByVal Opcode As Short, ByVal Cursor() As Byte, ByRef DataBuffer As Object, ByRef DataBufferLength As Short, ByVal KeyBuffer() As Byte, ByVal KeyLength As Short, ByVal KeyNum As Short) As Short

    Function StrToByteArray(ByVal str As String) As Byte()
        Dim enc As Encoding
        'Get the encoding associated with the default ANSI code page in the system's regional settings
        enc = Encoding.GetEncoding(0)
        Return enc.GetBytes(str)
    End Function 'StrToByteArray

    Function ByteArraysToStr(ByVal dBytes As Byte()) As String
        Dim str As String
        Dim enc As Encoding
        'Get the encoding associated with the default ANSI code page in the system's regional settings
        enc = Encoding.GetEncoding(0)
        str = enc.GetString(dBytes)
        Return str
    End Function

    Sub readBytes(ByVal src() As Byte, ByVal dest As StringBuilder, ByVal start As Integer, ByVal sz As Integer)

        If dest.Length > 0 Then
            dest.Remove(0, dest.Length)
        End If

        Dim temp() As Byte
        ReDim temp(sz)
        Dim iSrc As IntPtr

        Marshal.Copy(iSrc, temp, 0, sz)


        dest.Append(ByteArraysToStr(temp))
       
    End Sub

    Sub readBytes(ByVal src As IntPtr, ByVal dest() As Byte, ByVal start As IntPtr, ByVal sz As Integer)
        Dim idx As Integer

        For idx = 0 To sz - 1
            dest(idx) = Marshal.ReadByte(src, start.ToInt32() + idx)
        Next

    End Sub

    Sub writeBytes(ByVal dest As IntPtr, ByVal src As StringBuilder, ByVal start As IntPtr, ByVal sz As Integer)
        Dim idx As Integer

        Dim mEnc As Encoding
        mEnc = Encoding.GetEncoding(0)

        Dim aByte() As Byte
        ReDim aByte(sz)

        aByte = StrToByteArray(src.ToString())

        Dim len As Integer = aByte.Length

        For idx = 0 To sz - 1
            If idx < len Then
                Marshal.WriteByte(dest, start.ToInt32() + idx, aByte(idx)) ' ToByte(src.Chars(idx)))
            Else
                Marshal.WriteByte(dest, start.ToInt32() + idx, ToByte(0))
            End If
        Next
    End Sub

    Sub writeBytes(ByVal src As IntPtr, ByVal dest() As Byte, ByVal start As IntPtr, ByVal sz As Integer)
        Dim idx As Integer

        For idx = 0 To sz - 1
            Marshal.WriteByte(src, start.ToInt32() + idx, dest(idx))
        Next

    End Sub


    Sub cIntPtrToByteArray(ByVal iSrc As IntPtr, ByVal dest() As Byte, ByVal sz As Integer)
        Marshal.Copy(iSrc, dest, 0, sz)
    End Sub

    'All CallBTRCALL functions change Bstat

    'NullPosBlk is true, passing a null to BTRCALL. Otherwise use the PosBlock.Value
    'Handle BTRCALL that does not care databufer and keybuffer
    Function CallBTRCALL(ByVal Opcode As Short, ByVal NullPosBlk As Boolean) As Boolean
        Dim caughtExcept As Boolean = False
        Bstat = 0
        Try
            If NullPosBlk = True Then
                Bstat = BTRCALL(Opcode, PosBlock, CObj(VariantType.Null), CShort(0), StrToByteArray(VariantType.Null), CShort(0), CShort(0))
            Else
                Bstat = BTRCALL(Opcode, PosBlock, CObj(VariantType.Null), CShort(0), StrToByteArray(VariantType.Null), CShort(0), CShort(0))
            End If
        Catch e As Exception
            caughtExcept = True
            MsgBox(e.Message, MsgBoxStyle.OkOnly)
        End Try

        Return caughtExcept

    End Function
    Function SplitArray(ByVal src() As Byte, ByVal offset As Integer, ByVal size As Integer) As String
        'Function SplitArray(aBytes, Marshal.OffsetOf(GetType(BtrCourseRecType), "Name"), CInt(KEY0_LEN)) As String
        Dim sTemp As String
        Dim enc As Encoding
        enc = Encoding.GetEncoding(0)

        Dim aTemp() As Byte
        ReDim aTemp(size)

        Array.Copy(src, offset, aTemp, 0, size)
        sTemp = enc.GetString(aTemp)
        Return sTemp
    End Function
    ' Caller must set KeyBuf, KeyBufLen, and KeyNum
    ' Most import caller must set a course record
    ' Here is where the marshalling occurs
    Function CallBTRCALL(ByVal Opcode As Short, ByVal upLoad As Boolean, ByVal downLoad As Boolean) As Boolean
        Dim caughtExcept As Boolean = False
        Dim iPtr As IntPtr
        Dim strBuf As New StringBuilder(POSBLK_LEN)
        Dim twoBytes(1) As Byte

        DataBufLen = Marshal.SizeOf(GetType(BtrCourseRecType))
        iPtr = Marshal.AllocHGlobal(DataBufLen)
        Bstat = 0

        ' convert application data to physical data 
        If upLoad = True Then
            With CourseRec
                strBuf.Append(.Name)
                writeBytes(iPtr, strBuf, Marshal.OffsetOf(GetType(BtrCourseRecType), "Name"), CInt(KEY0_LEN))
                If strBuf.Length > 0 Then
                    strBuf.Remove(0, strBuf.Length)
                End If
                strBuf.Append(.Description)
                writeBytes(iPtr, strBuf, Marshal.OffsetOf(GetType(BtrCourseRecType), "Description"), CInt(50))
                twoBytes(0) = .Credit_Hours.B1
                twoBytes(1) = .Credit_Hours.B2
                writeBytes(iPtr, twoBytes, Marshal.OffsetOf(GetType(BtrCourseRecType), "Credit_Hours"), Marshal.SizeOf(GetType(VBSInt)))
                If strBuf.Length > 0 Then
                    strBuf.Remove(0, strBuf.Length)
                End If
                strBuf.Append(.Dept_Name)
                writeBytes(iPtr, strBuf, Marshal.OffsetOf(GetType(BtrCourseRecType), "Dept_Name"), CInt(KEY1_LEN))
            End With
        End If

        Try
            Bstat = BTRCALL(Opcode, PosBlock, iPtr, DataBufLen, StrToByteArray(KeyBuf.Value), KeyBufLen, KeyNum)
        Catch e As Exception
            caughtExcept = True
            MsgBox("Exception during Btrieve operation(" & Opcode & "):" & Chr(13) & e.Message, MsgBoxStyle.OkOnly)
        Finally
            If Bstat = 0 And caughtExcept = False And downLoad = True Then
                ' Move data from unmanaged memory block to our application data structure
                Dim aBytes() As Byte
                ReDim aBytes(DataBufLen)
                With CourseRec
                    cIntPtrToByteArray(iPtr, aBytes, DataBufLen)
                    .Name = SplitArray(aBytes, Marshal.OffsetOf(GetType(BtrCourseRecType), "Name"), CInt(KEY0_LEN))
                    'readBytes(iPtr, strBuf, Marshal.OffsetOf(GetType(BtrCourseRecType), "Name"), CInt(KEY0_LEN))
                    '.Name = strBuf.ToString()
                    'readBytes(iPtr, strBuf, Marshal.OffsetOf(GetType(BtrCourseRecType), "Description"), CInt(50))
                    '.Description = strBuf.ToString()
                    .Description = SplitArray(aBytes, Marshal.OffsetOf(GetType(BtrCourseRecType), "Description"), CInt(50))
                    'readBytes(iPtr, strBuf, Marshal.OffsetOf(GetType(BtrCourseRecType), "Dept_Name"), CInt(KEY1_LEN))
                    '.Dept_Name = strBuf.ToString()
                    .Dept_Name = SplitArray(aBytes, Marshal.OffsetOf(GetType(BtrCourseRecType), "Dept_Name"), CInt(KEY1_LEN))

                    readBytes(iPtr, twoBytes, Marshal.OffsetOf(GetType(BtrCourseRecType), "Credit_Hours"), Marshal.SizeOf(GetType(VBSInt)))
                    .Credit_Hours.B1 = twoBytes(0)
                    .Credit_Hours.B2 = twoBytes(1)
                End With
            End If
            Marshal.FreeHGlobal(iPtr)
        End Try

        Return caughtExcept
    End Function

    ' Caller must set KeyBuf, KeyBufLen, and KeyNum
    ' Handle BTRCALL that doesn't care Databuffer
    Function CallBTRCALL(ByVal Opcode As Short) As Boolean
        Dim caughtExcept As Boolean = False
        Bstat = 0

        Try
            Bstat = BTRCALL(Opcode, PosBlock, CObj(VariantType.Null), CShort(0), StrToByteArray(KeyBuf.Value), KeyBufLen, KeyNum)
        Catch e As Exception
            MsgBox(e.Message, MsgBoxStyle.OkOnly)
            caughtExcept = True
        End Try
        Return caughtExcept
    End Function

    Function BtrOpen(ByVal filelocation As String) As Short
        Dim caughtExcept As Boolean = False
        If filelocation.EndsWith("\") Then
            KeyBuf.Value = filelocation & "course.mkd" & Chr(0)
        Else
            KeyBuf.Value = filelocation & "\course.mkd" & Chr(0)
        End If

        KeyNum = 0
        KeyBufLen = KEY_BUF_LEN

        ' .NET CLR will not instantiate the String embedded inside a structure
        CourseRec.Name = New String(CChar(" "), 8)
        CourseRec.Description = New String(CChar(" "), 51)
        CourseRec.Dept_Name = New String(CChar(" "), 21)
        caughtExcept = CallBTRCALL(BOPEN)
        'If Bstat = 0 And caughtExcept = False Then
        '    Return
        'ElseIf Bstat <> 0 Then
        '    MsgBox("Failure opening " & KeyBuf.Value & ". Btrieve error: " & Bstat, MsgBoxStyle.OkOnly)
        'End If
        Return Bstat
    End Function

    Public Sub main()


    End Sub

    Function DeleteRec(ByVal Opcode As Short) As Short
        Dim retcode As Short = 0
        Dim caughtExcept As Boolean = False

        KeyNum = 0

        caughtExcept = CallBTRCALL(BBEGINTRAN, True)
        If caughtExcept = False And Bstat = 0 Then
            caughtExcept = CallBTRCALL(Opcode, False)
            retcode = Bstat
        End If

        If Bstat = 0 And caughtExcept = False Then
            CallBTRCALL(BENDTRAN, True)
        Else
            CallBTRCALL(BABORTTRAN, True)
        End If

        DeleteRec = retcode
    End Function
    'UPGRADE_NOTE: Step was upgraded to Step_Renamed. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1061"'

    Sub NavigateRec(ByVal Opcode As Short, ByVal upLoad As Boolean, ByVal downLoad As Boolean)
        Dim tint As Short
        Dim caughtExcept As Boolean = False
        KeyBufLen = KEY_BUF_LEN
        'UPGRADE_WARNING: Couldn't resolve default property of object CourseRec. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'

        If upLoad = True Then
            With CourseRec
                .Name = Trim(Form1.DefInstance.txtName.Text)
                .Description = Trim(Form1.DefInstance.Description.Text)
                tint = CShort(Trim(Form1.DefInstance.Credit_Hours.Text))
                'UPGRADE_WARNING: Couldn't resolve default property of object CourseRec.Credit_Hours. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
                Call CopyMemory(.Credit_Hours, tint, Len(.Credit_Hours))
                .Dept_Name = Trim(Form1.DefInstance.Dept_Name.Text)
            End With
        End If

        If upLoad = False And downLoad = False Then
            caughtExcept = CallBTRCALL(Opcode, False)
        ElseIf upLoad = True Then
            caughtExcept = CallBTRCALL(Opcode, True, downLoad)
        Else
            caughtExcept = CallBTRCALL(Opcode, False, downLoad)
        End If

        If Bstat <> 0 Then
            MsgBox("Failue performing Btreive Call(" & Opcode & "). Btrieve error: " & Bstat, MsgBoxStyle.OkOnly)
        ElseIf caughtExcept = False And Opcode <> BCLOSE And Opcode <> BRESET And Opcode <> BSTOP Then
            PopulateForm()
        End If
    End Sub

    Function Insert_Update(ByVal Opcode As Short) As Short
        Dim retcode As Short
        Dim tint As Short
        Dim caughtExcept As Boolean = False

        KeyNum = 0
        With CourseRec
            .Name = Trim(Form1.DefInstance.txtName.Text)
            .Description = Trim(Form1.DefInstance.Description.Text)
            tint = CShort(Trim(Form1.DefInstance.Credit_Hours.Text))
            'UPGRADE_WARNING: Couldn't resolve default property of object CourseRec.Credit_Hours. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            Call CopyMemory(.Credit_Hours, tint, Len(.Credit_Hours))
            .Dept_Name = Trim(Form1.DefInstance.Dept_Name.Text)
        End With

        KeyBufLen = KEY_BUF_LEN
        CallBTRCALL(BBEGINTRAN, True)
        'UPGRADE_WARNING: Couldn't resolve default property of object CourseRec. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
        caughtExcept = CallBTRCALL(Opcode, True, False) ' upload our data to server
        retcode = Bstat
        If Bstat = 0 And caughtExcept = False Then
            CallBTRCALL(BENDTRAN, True)
        Else
            CallBTRCALL(BABORTTRAN, True)
        End If

        Insert_Update = retcode
    End Function

    Function FindByName(ByVal key As Short) As Short
        Dim Opcode As Short = BGETFIRST
        Dim caughtExcept As Boolean = False

        KeyNum = key
        KeyBufLen = KEY_BUF_LEN

        'UPGRADE_WARNING: Couldn't resolve default property of object CourseRec. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
        caughtExcept = CallBTRCALL(CShort(Opcode + 50))

        If Bstat = 0 And caughtExcept = False Then
            Opcode = BGETEQUAL

            If KeyNum = 0 Then
                KeyBuf.Value = Trim(Form1.DefInstance.txtName.Text)
                KeyBufLen = KEY0_LEN
            Else
                KeyBuf.Value = Trim(Form1.DefInstance.Dept_Name.Text)
                KeyBufLen = KEY1_LEN
            End If

            'UPGRADE_WARNING: Couldn't resolve default property of object CourseRec. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            caughtExcept = CallBTRCALL(CShort(Opcode + 50))
        End If

        If Bstat = 0 And caughtExcept = False Then
            NavigateRec(Opcode, False, True) ' down load data from server
        End If

        FindByName = Bstat
    End Function

    Sub UnloadEverything(ByVal Opcode As Short)
        Dim caughtExcept As Boolean = False
        caughtExcept = CallBTRCALL(Opcode, True)
        If Bstat <> 0 Then
            MsgBox("Error Calling BTrieve Reset " & Bstat, MsgBoxStyle.OkOnly)
        End If

        System.Windows.Forms.Application.Exit()

    End Sub

    Sub PopulateForm()
        Dim tint As Short
        With CourseRec
            Form1.DefInstance.txtName.Text = .Name
            Form1.DefInstance.Description.Text = .Description
            'UPGRADE_WARNING: Couldn't resolve default property of object CourseRec.Credit_Hours. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            Call CopyMemory(tint, .Credit_Hours, Len(.Credit_Hours))
            Form1.DefInstance.Credit_Hours.Text = CStr(tint)
            Form1.DefInstance.Dept_Name.Text = .Dept_Name
        End With
    End Sub
End Module