/*************************************************************************
**
**  Copyright 1982-2008 Pervasive Software Inc. All Rights Reserved
**
*************************************************************************/
/***************************************************************************
  dtitest.c
    This is a simple sample designed to allow you to confirm your
    ability to compile, link, and execute a DTI application for
    your target environment using your compiler tools.
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <btitypes.h>
#include <dticonst.h>
#include <config.h>
#include <connect.h>
#include <catalog.h>

int main(int argc, char* argv[]) {
    BTI_SINT      rc;
    BTI_CHAR      szBuffer[512];
    BTI_ULONG     ulSize      = sizeof(szBuffer);
    BTI_LONG      lConnection = 0xFFFFFFFF;
    BTI_CHAR_PTR  uName = ""; 
    BTI_CHAR_PTR  pword = ""; 
    BTI_CHAR_PTR  svrName = "";
    BTI_CHAR_PTR  svr = "";

    rc = PvStart(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStart. Error code: %d\n", rc);
		return rc;
	}
    if (argc > 2)
	{ 
      svrName = argv[1];
	  uName = argv[2]; 
	  pword = argv[3]; 
	}
     else 
        { 
         if (argv[1] != NULL) svrName = argv[1];
         else 
		 {
          printf("Usage:  dtitest servername [username] [password]\n");
          return 1;
         }
             
        }

	printf("\nServerName: %s",svrName); 
	printf("\n");
	printf("UserName: %s",uName); 
	printf("\n");
	printf("Password: %s",pword); 
	printf("\n");
	
    rc = PvConnectServer(svrName,uName,pword,&lConnection); 

	if (rc!= P_OK)
	{
		printf ("Error on PvConnectServer. Error code: %d\n", rc);
		return rc;
	}

	printf("PvConnectServer OK.\n");

    rc = PvGetServerName(lConnection, &ulSize, szBuffer);
	if (rc!= P_OK)
	{
		printf ("Error on PvGetServerName. Error code: %d\n", rc);
		return rc;
	}
        printf("PvGetServerName OK.  ServerName: %s\n",szBuffer);
 
    rc = PvCreateDatabase(lConnection, "dtiDemodata", uName, pword, 0);
	if (rc!= P_OK)
	{
		printf ("Error on PvCreateDatabase. Error code: %d\n", rc);
		return rc;
	}
	printf("PvCreateDatabase OK.\n");
  
     rc = PvCreateDSN(lConnection, "DTI Demodata",
            "Demodata DSN created using DTI",
            "dtiDemodata", NORMAL_MODE);
 	if (rc!= P_OK)
	{
		printf ("Error on PvCreateDSN. Error code: %d\n", rc);
		return rc;
	}
 
         printf("PvCreateDSN OK.\n");

     rc = PvDeleteDSN(lConnection, "DTI Demodata"); 
	if (rc!= P_OK)
	{
		printf ("Error on PvDeleteDSN. Error code: %d\n", rc);
		return rc;
	}
	printf("PvDeleteDSN OK.\n");

     rc = PvDropDatabase(lConnection, "dtiDemodata", 0);
	if (rc!= P_OK)
	{
		printf ("Error on PvDropDatabase. Error code: %d\n", rc);
		return rc;
	}
	printf("PvDropDatabase OK.\n");

    rc = PvStop(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStop. Error code: %d\n", rc);
		return rc;
	}
	printf("PvStop OK.\n");

return rc;
}

