/*************************************************************************
**
**  Copyright 1982-2008 Pervasive Software Inc. All Rights Reserved
**
*************************************************************************/
/***************************************************************************
  mkdeinfo.c
    This is a simple sample designed to allow you to confirm your
    ability to compile, link, and execute a DTI application for
    your target environment using your compiler tools.
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <btitypes.h>
#include <dticonst.h>
#include <monitor.h>
#include <config.h>
#include <connect.h>
#include <catalog.h>


int main(int argc, char* argv[]) {

    BTI_SINT      rc;
    BTI_CHAR      szBuffer[512];
    BTI_ULONG     ulSize      = sizeof(szBuffer);
    BTI_LONG      lConnection = 0xFFFFFFFF;
    BTI_CHAR_PTR  uName = ""; 
    BTI_CHAR_PTR  pword = ""; 
    BTI_CHAR_PTR  svrName = "";
    BTI_CHAR_PTR  svr = "";

    PVMKDEUSAGE usageinfo;


// ---------  START ------------------------------------//


    rc = PvStart(0);

	if (rc!= P_OK)
	{
		printf ("Error on PvStart. Error code: %d\n", rc);
		return rc;
	}
    if (argc > 2)
	{ 
     svrName = argv[1];
	  uName = argv[2]; 
	  pword = argv[3]; 
	}
     else 
        { 
       
            if (argv[1] != NULL) svrName = argv[1];
            else 
			 {
                printf("Usage:  mkdeinfo servername \n");
                return 1;
             }
        }
	
    rc = PvConnectServer(svrName,uName,pword,&lConnection); 
	if (rc!= P_OK)
	{
		printf ("Error on PvConnectServer. Error code: %d\n", rc);
		return rc;
	}

	printf("PvConnectServer OK.\n");

    rc = PvGetServerName(lConnection, &ulSize, szBuffer);
	if (rc!= P_OK)
	{
		printf ("Error on PvGetServerName. Error code: %d\n", rc);
		return rc;
	}
        printf("PvGetServerName OK.  ServerName: %s\n",szBuffer);


// ----------- START / CONNECT DONE -------------------------------

printf("\n\nMicroKernel Usage Information\n");
printf("-----------------------------\n\n");

rc = PvGetMkdeUsage(lConnection, &usageinfo); 

printf("Current licenses       = %d\n",   usageinfo.currentLicensesInUse);
printf("Peak licenses          = %d\n",   usageinfo.peakLicensesInUse);
printf("Max licenses           = %d\n\n",  usageinfo.maxLicenses);

printf("Current files          = %d\n",   usageinfo.curFilesInUse);
printf("Peak files             = %d\n",   usageinfo.peakFilesInUse);
printf("Max files              = %d\n\n", usageinfo.maxFiles);

printf("Current handles        = %d\n",   usageinfo.curHandlesInUse);
printf("Peak handles           = %d\n",   usageinfo.peakHandlesInUse);
printf("Max handles            = %d\n\n", usageinfo.maxHandles);

printf("Current transactions   = %d\n",   usageinfo.curTransInUse);
printf("Peak transactions      = %d\n",   usageinfo.peakTransInUse);
printf("Max transactions       = %d\n\n", usageinfo.maxTrans);

printf("Current clients        = %d\n",   usageinfo.curClients);
printf("Peak clients           = %d\n",   usageinfo.peakClients);
printf("Max clients            = %d\n\n", usageinfo.maxClients);
  
printf("Current threads        = %d\n",   usageinfo.curThreads);
printf("Peak threads           = %d\n",   usageinfo.peakThreads);
printf("Max threads            = %d\n\n", usageinfo.maxThreads);

printf("Current locks          = %d\n",   usageinfo.curLocksInUse);
printf("Peak locks             = %d\n\n", usageinfo.peakLocksInUse);

// ------------ STOP ----------------------------------

    rc = PvStop(0);
	if (rc!= P_OK)
	{
		printf ("Error on PvStop. Error code: %d\n", rc);
		return rc;
	}
	printf("PvStop OK.\n");

return rc;
}

