/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import pervasive.database.PsqlException;
import pvideoj.model.Contract;
import pvideoj.model.ContractList;
import pvideoj.model.Customer;
import pvideoj.model.CustomerList;
import pvideoj.model.ListTableModelAdapter;
import pvideoj.model.PVideoDB;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.InfoActionArea;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.NavigationBar;
import pvideoj.views.CustomerView;
import pvideoj.views.ListTableView;

class CustomerPanel
extends JPanel
implements ActionListener {
    private static String[] _columnHeadings = new String[]{"Customer ID", "Last Name", "First Name"};
    private static String[] _columnNames = new String[]{"CustID", "LastName", "FirstName"};
    private static final String[] _actionToolTips = new String[]{"Create a new customer", "Save current customer", "Delete current customer", "Reset current customer to original values", "Close Customers Dialog"};
    private CustomerView _customerView;
    private InfoActionArea _infoActionArea;
    private CustomerList _customers = (CustomerList)PVideoDB.instance().getSharedDBObjectList(3);
    private ContractList _contracts = (ContractList)PVideoDB.instance().createDBObjectList(1);
    private int _restore_index = -1;

    public CustomerPanel() throws PsqlException {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ListTableModelAdapter listTableModelAdapter = new ListTableModelAdapter(this._customers, _columnHeadings, _columnNames);
        ListTableView listTableView = new ListTableView(this._customers, listTableModelAdapter, _columnHeadings, _columnNames, new Dimension(300, 1), "Listing");
        LayoutUtils.constrain(gridBagConstraints, this, listTableView, 0, 0, 1, 2, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(listTableView);
        this._customerView = new CustomerView(this._customers);
        LayoutUtils.constrain(gridBagConstraints, this, this._customerView, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.add(this._customerView);
        NavigationBar navigationBar = new NavigationBar(this._customers);
        LayoutUtils.constrain(gridBagConstraints, this, navigationBar, 1, 1, 1, 1, 0, 11, 0.0, 0.0, 0, 0, 0, 0);
        this.add(navigationBar);
        this._infoActionArea = new InfoActionArea();
        this._infoActionArea.setToolTips(_actionToolTips);
        LayoutUtils.constrain(gridBagConstraints, this, this._infoActionArea, 0, 2, 2, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(this._infoActionArea);
        this._infoActionArea.addActionListener(this);
        if (this._customers.getRowCount() > 0) {
            this._customers.setSelectionIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Customer customer = null;
        switch (this._infoActionArea.getButton(actionEvent.getActionCommand())) {
            case 0: {
                this._restore_index = this._customers.getSelectedIndex();
                this._customerView.setCustomer(this._customers.createCustomer());
                this._infoActionArea.setEnabled(2, false);
                break;
            }
            case 1: {
                if (!this._customerView.isValidInput()) {
                    return;
                }
                customer = this._customerView.getCustomer();
                if (customer == null) break;
                try {
                    this._customers.save(customer);
                    if (customer.getID() == 0) {
                        this._customers.getLast();
                    } else {
                        this._customers.findCustomer(customer.getID());
                    }
                    this._customers.setSelectionIndex(this._customers.getCurrentIndex());
                    this._infoActionArea.setEnabled(2, true);
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
                break;
            }
            case 2: {
                customer = (Customer)this._customers.getSelectedObject();
                if (customer == null) break;
                try {
                    Contract contract = this._contracts.findContractWithCustomer(customer.getID());
                    if (contract != null) {
                        String string = "Cannot delete this customer.\n";
                        string = string + "It is referenced in contract \"" + contract.getID() + "\".";
                        ErrorMessage.showMessage((AWTEvent)actionEvent, string);
                        return;
                    }
                    boolean bl = this._customers.isSelectedLast();
                    int n = this._customers.getSelectedIndex();
                    this._customers.delete(customer);
                    if (!bl) {
                        this._customers.setSelectionIndex(n);
                        break;
                    }
                    this._customers.setSelectionIndex(n - 1);
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
                break;
            }
            case 3: {
                this._customers.setSelectionIndex(this._restore_index != -1 ? this._restore_index : this._customers.getSelectedIndex());
                this._restore_index = -1;
                this._infoActionArea.setEnabled(2, true);
                break;
            }
            case 4: {
                this.getTopLevelAncestor().setVisible(false);
            }
        }
    }
}

