/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.pscs;

import com.pervasive.pscs.CipherSuiteNotSupportedException;

public class CipherSuite {
    public static final CipherSuite TLS_NULL_WITH_NULL_NULL = new CipherSuite("TLS_NULL_WITH_NULL_NULL");
    public static final CipherSuite TLS_RSA_WITH_NULL_MD5 = new CipherSuite("TLS_RSA_WITH_NULL_MD5");
    public static final CipherSuite TLS_RSA_WITH_NULL_SHA = new CipherSuite("TLS_RSA_WITH_NULL_SHA");
    public static final CipherSuite TLS_RSA_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("TLS_RSA_EXPORT_WITH_RC4_40_MD5");
    public static final CipherSuite TLS_RSA_WITH_RC4_128_MD5 = new CipherSuite("TLS_RSA_WITH_RC4_128_MD5");
    public static final CipherSuite TLS_RSA_WITH_RC4_128_SHA = new CipherSuite("TLS_RSA_WITH_RC4_128_SHA");
    public static final CipherSuite TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = new CipherSuite("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5");
    public static final CipherSuite TLS_RSA_WITH_IDEA_CBC_SHA = new CipherSuite("TLS_RSA_WITH_IDEA_CBC_SHA");
    public static final CipherSuite TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_RSA_WITH_DES_CBC_SHA = new CipherSuite("TLS_RSA_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_RSA_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_WITH_DES_CBC_SHA = new CipherSuite("TLS_DH_DSS_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_WITH_DES_CBC_SHA = new CipherSuite("TLS_DH_RSA_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_WITH_DES_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_WITH_DES_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5");
    public static final CipherSuite TLS_DH_anon_WITH_RC4_128_MD5 = new CipherSuite("TLS_DH_anon_WITH_RC4_128_MD5");
    public static final CipherSuite TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DH_anon_WITH_DES_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_KRB5_WITH_DES_CBC_SHA = new CipherSuite("TLS_KRB5_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_KRB5_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_KRB5_WITH_RC4_128_SHA = new CipherSuite("TLS_KRB5_WITH_RC4_128_SHA");
    public static final CipherSuite TLS_KRB5_WITH_IDEA_CBC_SHA = new CipherSuite("TLS_KRB5_WITH_IDEA_CBC_SHA");
    public static final CipherSuite TLS_KRB5_WITH_DES_CBC_MD5 = new CipherSuite("TLS_KRB5_WITH_DES_CBC_MD5");
    public static final CipherSuite TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = new CipherSuite("TLS_KRB5_WITH_3DES_EDE_CBC_MD5");
    public static final CipherSuite TLS_KRB5_WITH_RC4_128_MD5 = new CipherSuite("TLS_KRB5_WITH_RC4_128_MD5");
    public static final CipherSuite TLS_KRB5_WITH_IDEA_CBC_MD5 = new CipherSuite("TLS_KRB5_WITH_IDEA_CBC_MD5");
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = new CipherSuite("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA");
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA = new CipherSuite("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA");
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC4_40_SHA = new CipherSuite("TLS_KRB5_EXPORT_WITH_RC4_40_SHA");
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = new CipherSuite("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5");
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5 = new CipherSuite("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5");
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("TLS_KRB5_EXPORT_WITH_RC4_40_MD5");
    public static final CipherSuite PSCS_KEK_WITH_BLOWFISH_CBC_40_NULL = new CipherSuite("PSCS_KEK", "Blowfish", "CBC", "40", null, 253);
    public static final CipherSuite PSCS_KEK_WITH_BLOWFISH_CBC_56_NULL = new CipherSuite("PSCS_KEK", "Blowfish", "CBC", "56", null, 254);
    public static final CipherSuite PSCS_KEK_WITH_BLOWFISH_CBC_128_NULL = new CipherSuite("PSCS_KEK", "Blowfish", "CBC", "128", null, 255);
    private String a;
    private final int b;
    private String c;
    private String d;
    private String e;
    private String f;
    private String g;

    protected CipherSuite(String string, String string2, String string3, String string4, String string5, int n) {
        this.b = n;
        this.c = string;
        this.d = string2;
        this.e = string3;
        this.f = string4;
        this.g = string5;
    }

    protected CipherSuite(String string) {
        this.a = string;
        this.b = 0;
    }

    public int getId() {
        return this.b;
    }

    public String getAuthentication() {
        return this.c;
    }

    public String getSession() {
        return this.d;
    }

    public String getMode() {
        return this.e;
    }

    public String getStrength() {
        return this.f;
    }

    public String getDigest() {
        return this.g == null ? "NULL" : this.g;
    }

    public String getJceTransformation() {
        return this.a != null ? null : this.getSession() + "/" + this.getMode();
    }

    public static CipherSuite getSuiteById(int n) throws CipherSuiteNotSupportedException {
        switch (n) {
            case 253: {
                return PSCS_KEK_WITH_BLOWFISH_CBC_40_NULL;
            }
            case 254: {
                return PSCS_KEK_WITH_BLOWFISH_CBC_56_NULL;
            }
            case 255: {
                return PSCS_KEK_WITH_BLOWFISH_CBC_128_NULL;
            }
        }
        throw new CipherSuiteNotSupportedException();
    }

    public String toString() {
        return this.a != null ? this.a : this.getAuthentication() + "_WITH_" + this.getSession().toUpperCase() + "_" + this.getMode() + "_" + this.getStrength() + "_" + this.getDigest();
    }
}

