/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.v2.ConnectionEventListener;
import com.pervasive.jdbc.v2.RealConnection;
import com.pervasive.jdbc.v2.Statement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.StatementEventListener;

public class PooledConnection
implements javax.sql.PooledConnection {
    RealConnection m_realCon;
    JDBCURL m_url;
    Properties m_info;
    Vector m_listeners = new Vector();

    public PooledConnection(JDBCURL jDBCURL, Properties properties) throws SQLException {
        this.m_url = jDBCURL;
        this.m_info = properties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isValidConnection()) {
            return this.m_realCon;
        }
        this.m_realCon = new RealConnection(this.m_url, this.m_info, this);
        return this.m_realCon;
    }

    @Override
    public void close() throws SQLException {
        this.m_realCon.realClose();
        this.m_realCon = null;
    }

    @Override
    public void addConnectionEventListener(javax.sql.ConnectionEventListener connectionEventListener) {
        this.m_listeners.addElement(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(javax.sql.ConnectionEventListener connectionEventListener) {
        this.m_listeners.remove(connectionEventListener);
    }

    public void realConnectionClosed() {
        try {
            Enumeration enumeration = this.m_listeners.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEvent connectionEvent = new ConnectionEvent(this);
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connectionErrorOccurred() {
        try {
            Enumeration enumeration = this.m_listeners.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEvent connectionEvent = new ConnectionEvent(this);
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isValidConnection() {
        Statement statement = null;
        try {
            if (this.m_realCon == null) {
                return false;
            }
            if (this.m_realCon.isClosed()) {
                return false;
            }
            statement = (Statement)this.m_realCon.createStatement();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        System.err.println(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        System.err.println(LocalStrings.ERR_NOT_IMPL);
    }
}

