/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.io;

import com.pervasive.io.CharToByteASCII;
import com.pervasive.io.ConversionBufferFullException;
import com.pervasive.io.MalformedInputException;
import com.pervasive.io.UnknownCharacterException;
import java.io.UnsupportedEncodingException;

public abstract class CharToByteConverter {
    protected boolean subMode;
    protected byte[] subBytes = new byte[]{63};
    protected int charOff;
    protected int byteOff;
    protected int badInputLength;

    protected CharToByteConverter() {
    }

    public static CharToByteConverter getDefault() {
        return new CharToByteASCII();
    }

    public static CharToByteConverter getConverter(String string) throws UnsupportedEncodingException {
        if (string == null || string.equalsIgnoreCase("ASCII") || string.equalsIgnoreCase("US-ASCII") || string.equalsIgnoreCase("646") || string.equalsIgnoreCase("DEFAULT") || string.equalsIgnoreCase("ASCII7")) {
            return new CharToByteASCII();
        }
        throw new UnsupportedEncodingException(string);
    }

    public abstract String getCharacterEncoding();

    public abstract int convert(char[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException;

    public byte[] convertAll(char[] cArray) throws MalformedInputException, UnknownCharacterException {
        try {
            byte[] byArray = new byte[cArray.length * this.getMaxBytesPerChar()];
            this.reset();
            this.convert(cArray, 0, cArray.length, byArray, 0, byArray.length);
            this.reset();
            return byArray;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw new InternalError(conversionBufferFullException.toString());
        }
    }

    public abstract int flush(byte[] var1, int var2, int var3) throws MalformedInputException, ConversionBufferFullException;

    public abstract void reset();

    public boolean canConvert(char c) {
        try {
            char[] cArray = new char[]{c};
            byte[] byArray = new byte[this.getMaxBytesPerChar()];
            this.reset();
            this.convert(cArray, 0, 1, byArray, 0, byArray.length);
            this.reset();
            return true;
        }
        catch (MalformedInputException malformedInputException) {
            return false;
        }
        catch (UnknownCharacterException unknownCharacterException) {
            return false;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw new InternalError(conversionBufferFullException.toString());
        }
    }

    public abstract int getMaxBytesPerChar();

    public int getBadInputLength() {
        return this.badInputLength;
    }

    public int nextCharIndex() {
        return this.charOff;
    }

    public int nextByteIndex() {
        return this.byteOff;
    }

    public void setSubstitutionMode(boolean bl) {
        this.subMode = bl;
    }

    public void setSubstitutionBytes(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length > this.getMaxBytesPerChar()) {
            throw new IllegalArgumentException();
        }
        this.subBytes = byArray;
    }

    public String toString() {
        return "CharToByteConverter: " + this.getCharacterEncoding();
    }
}

