/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.io;

import java.io.ByteArrayOutputStream;

public class PacketOutputStream
extends ByteArrayOutputStream {
    protected int realSize;

    public PacketOutputStream() {
    }

    public PacketOutputStream(int n) {
        super(n);
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.realSize = 0;
    }

    public synchronized void seek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.count > this.realSize) {
            this.realSize = this.count;
        }
        if (n > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n)];
            System.arraycopy(this.buf, 0, byArray, 0, this.realSize);
            this.buf = byArray;
        }
        this.count = n;
    }

    public synchronized void seekToEnd() {
        if (this.count < this.realSize) {
            this.count = this.realSize;
        }
    }

    public int position() {
        return this.count;
    }

    @Override
    public int size() {
        if (this.count > this.realSize) {
            this.realSize = this.count;
        }
        return this.realSize;
    }
}

