/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.common;

import com.pervasive.jdbc.common.Encoding;
import com.pervasive.jdbc.common.LocalStrings;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class JDBCURL {
    public static final int ENCRYPTION_NO = 0;
    public static final int ENCRYPTION_ALWAYS = 1;
    public static final int ENCRYPTION_IF_NEEDED = 2;
    public static final int DEFAULT_ENCRYPTION = 0;
    public static final int WEAK_ENCRYPTION = 1;
    public static final int MEDIUM_ENCRYPTION = 2;
    public static final int HIGH_ENCRYPTION = 3;
    public static final int MAX_ENCRYPTION_LEVEL = 4;
    public static final int URL_TYPE_NONE = 0;
    public static final int URL_TYPE_SOCKET = 1;
    public static final int URL_TYPE_TUNNEL = 2;
    public static final int URL_TYPE_SOCKET_ST = 3;
    public static final int URL_TYPE_SHM_SOCKET = 4;
    public static final int URL_TYPE_IPX_SOCKET = 5;
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_TRANSPORT = 1;
    public static final int DEBUG_METHODS = 2;
    public static final String PROP_NAME_TUNNEL = "tunnel";
    public static final String PROP_NAME_ENCODING = "encoding";
    public static final String PROP_NAME_THREADING = "threadmodel";
    public static final String PROP_NAME_TIMEOUT = "timeout";
    public static final String PROP_NAME_DEBUGFILE = "logfile";
    public static final String PROP_NAME_DEBUGLEVEL = "loglevel";
    public static final String PROP_NAME_ENCRYPT = "encrypt";
    public static final String PROP_NAME_ENCRYPTION = "encryption";
    public static final String PROP_NAME_TRANSPORT = "transport";
    public static final String PROP_NAME_TRANSLATE = "pvtranslate";
    public static final String TRANSLATE_AUTO = "auto";
    public static final String JNI_32BIT_DLL = "pvjdbc2";
    public static final String JNI_64BIT_DLL = "w64pvjdbc2";
    private int d_type = 0;
    private String d_host;
    private int d_port = -1;
    private String d_dsn;
    private Properties d_props;
    private int d_encrypt = 2;
    private int d_encryption = 2;
    private boolean d_translate = false;
    private static final String URL_START = "jdbc:pervasive://";
    private static final int URL_START_LEN = "jdbc:pervasive://".length();

    public JDBCURL(String string) throws MalformedURLException {
        int n;
        int n2;
        if (!string.regionMatches(true, 0, URL_START, 0, URL_START_LEN)) {
            return;
        }
        int n3 = string.indexOf("/", URL_START_LEN);
        if (n3 < 0) {
            throw new MalformedURLException(LocalStrings.ERR_URL_NO_DSN);
        }
        this.d_host = string.substring(URL_START_LEN, n3);
        int n4 = this.d_host.indexOf("[");
        if (-1 == n4) {
            n2 = this.d_host.indexOf(":");
            n = -1;
            if (n2 >= 0 && (n = this.d_host.indexOf(":", n2 + 1)) >= 0) {
                this.d_host = "[" + this.d_host + "]";
            }
        }
        if ((n2 = this.d_host.indexOf(":", (n4 = this.d_host.indexOf("]")) + 1)) >= 0) {
            try {
                this.d_port = Integer.parseInt(this.d_host.substring(n2 + 1));
                this.d_host = this.d_host.substring(0, n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException(LocalStrings.ERR_URL_INVALID_PORT);
            }
        }
        this.d_props = new Properties();
        this.d_props.put("user", "");
        this.d_props.put("password", "");
        n = 1;
        int n5 = n3;
        while (n5 < string.length()) {
            int n6 = string.indexOf(";", n5 + 1);
            if (n6 < 0) {
                n6 = n != 0 ? string.indexOf("?", n5 + 1) : string.indexOf("&", n5 + 1);
            }
            if (n6 < 0) {
                n6 = string.length();
            }
            String string2 = string.substring(n5 + 1, n6);
            if (n != 0) {
                this.d_dsn = string2;
                n = 0;
            } else {
                String string3;
                String string4;
                int n7 = string2.indexOf("=");
                if (n7 >= 0) {
                    string4 = string2.substring(0, n7);
                    string3 = string2.substring(n7 + 1);
                } else {
                    string4 = string2;
                    string3 = "1";
                }
                this.d_props.put(string4.toLowerCase(), string3);
            }
            n5 = n6;
        }
        this.d_type = this.getTunnel() != null ? 2 : (this.d_props.getProperty(PROP_NAME_THREADING) != null ? (this.d_props.getProperty(PROP_NAME_THREADING).equalsIgnoreCase("multi") ? 1 : 3) : (this.d_props.getProperty(PROP_NAME_TRANSPORT) == null && this.isSharedMemConnectionAllowed(this.d_host) ? 4 : 1));
        if (this.d_props.getProperty(PROP_NAME_ENCRYPT) != null) {
            if (this.d_props.getProperty(PROP_NAME_ENCRYPT).equalsIgnoreCase("always")) {
                this.d_encrypt = 1;
            } else if (this.d_props.getProperty(PROP_NAME_ENCRYPT).equalsIgnoreCase("never")) {
                this.d_encrypt = 0;
            }
        }
        if (this.d_props.getProperty(PROP_NAME_ENCRYPTION) != null) {
            if (this.d_props.getProperty(PROP_NAME_ENCRYPTION).equalsIgnoreCase("high")) {
                this.d_encryption = 3;
            } else if (this.d_props.getProperty(PROP_NAME_ENCRYPTION).equalsIgnoreCase("medium")) {
                this.d_encryption = 2;
            } else if (this.d_props.getProperty(PROP_NAME_ENCRYPTION).equalsIgnoreCase("low")) {
                this.d_encryption = 1;
            }
        }
        if (this.d_props.getProperty(PROP_NAME_TRANSPORT) != null) {
            if (this.d_props.getProperty(PROP_NAME_TRANSPORT).equalsIgnoreCase("shm")) {
                this.d_type = 4;
                if (this.d_port == -1) {
                    this.d_port = 2530;
                }
            } else if (this.d_props.getProperty(PROP_NAME_TRANSPORT).equalsIgnoreCase("ipx")) {
                this.d_type = 5;
                if (this.d_port == -1) {
                    this.d_port = 29320;
                }
            }
        }
        if (this.d_port == -1) {
            this.d_port = 1583;
        }
        if (this.d_props.getProperty(PROP_NAME_TRANSLATE) != null && this.d_props.getProperty(PROP_NAME_TRANSLATE).equalsIgnoreCase(TRANSLATE_AUTO)) {
            this.d_translate = true;
        }
        try {
            Encoding.checkEncoding(this.d_props.getProperty(PROP_NAME_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MalformedURLException("Invalid character encoding specified");
        }
    }

    private boolean isSharedMemConnectionAllowed(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2 != null && string2.indexOf("window") == -1) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            if (inetAddress.getHostAddress().equalsIgnoreCase("127.0.0.1") || inetAddress.getHostAddress().equalsIgnoreCase(inetAddress2.getHostAddress())) {
                try {
                    JDBCURL.loadJNI();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public int getType() {
        return this.d_type;
    }

    public String getHost() {
        return this.d_host;
    }

    public int getPort() {
        return this.d_port;
    }

    public String getDSN() {
        return this.d_dsn;
    }

    public String getProperty(String string) {
        return this.d_props.getProperty(string);
    }

    public String getTunnel() {
        return this.d_props.getProperty(PROP_NAME_TUNNEL);
    }

    public String getDebugFile() {
        return this.d_props.getProperty(PROP_NAME_DEBUGFILE);
    }

    public int getDebugLevel() {
        String string = this.d_props.getProperty(PROP_NAME_DEBUGLEVEL);
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public String getEncoding() {
        return this.d_props.getProperty(PROP_NAME_ENCODING);
    }

    public int getTimeout() {
        String string = this.d_props.getProperty(PROP_NAME_TIMEOUT);
        int n = -1;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public int getWhenEncrypt() {
        return this.d_encrypt;
    }

    public int getEncryptionLevel() {
        return this.d_encryption;
    }

    public boolean getTranslateOption() {
        return this.d_translate;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(URL_START);
        stringBuffer.append(this.d_host);
        stringBuffer.append(':');
        stringBuffer.append(this.d_port);
        stringBuffer.append('/');
        stringBuffer.append(this.d_dsn);
        Enumeration<Object> enumeration = this.d_props.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.d_props.getProperty(string);
            stringBuffer.append(';');
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void loadJNI() throws Exception {
        try {
            System.loadLibrary(JNI_32BIT_DLL);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.loadLibrary(JNI_64BIT_DLL);
        }
    }
}

