/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.ResultCache;
import java.sql.SQLException;
import java.util.Vector;

public class InMemoryResultCache
implements ResultCache {
    private boolean d_isClosed;
    private boolean d_updatable;
    private ColumnInfoSet d_cis;
    private int d_curRow;
    private Vector d_rows;
    private Object[] d_insertRow;
    private short d_rowStatus;

    public InMemoryResultCache(ColumnInfoSet columnInfoSet, boolean bl) {
        this.d_cis = columnInfoSet;
        this.d_isClosed = true;
        this.d_updatable = bl;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void makeReadOnly() {
        this.d_updatable = false;
    }

    @Override
    public void open() throws SQLException {
        if (this.d_isClosed) {
            this.d_rows = new Vector();
            this.d_curRow = 0;
            this.d_isClosed = false;
            this.d_rowStatus = (short)3;
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.d_isClosed) {
            this.d_isClosed = true;
            this.d_rows = null;
            this.d_insertRow = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.d_isClosed;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public int getRow() throws SQLException {
        return this.d_curRow;
    }

    @Override
    public boolean isRow(int n) throws SQLException {
        return this.d_curRow == n && this.d_insertRow == null;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.d_curRow = n == -1 ? this.d_rows.size() - 1 : n;
        this.d_rowStatus = 0;
        this.d_insertRow = null;
        if (this.d_curRow < 1) {
            this.d_curRow = Integer.MIN_VALUE;
        } else if (this.d_curRow > this.d_rows.size()) {
            this.d_curRow = Integer.MAX_VALUE;
        }
        return this.validRow();
    }

    @Override
    public boolean relative(int n, boolean bl) throws SQLException {
        if (this.d_curRow == Integer.MIN_VALUE && n == 1 && bl) {
            return this.absolute(1);
        }
        if (this.d_curRow == Integer.MAX_VALUE && n == -1 && bl) {
            return this.absolute(-1);
        }
        if (!this.validRow()) {
            return false;
        }
        this.d_curRow += n;
        this.d_rowStatus = 0;
        this.d_insertRow = null;
        if (this.d_curRow < 1) {
            this.d_curRow = Integer.MIN_VALUE;
        } else if (this.d_curRow > this.d_rows.size()) {
            this.d_curRow = Integer.MAX_VALUE;
        }
        return this.validRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.d_updatable) {
            this.d_insertRow = null;
            this.d_rowStatus = 0;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (!this.d_updatable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        this.d_insertRow = new Object[this.d_cis.getCount()];
        this.d_rowStatus = 0;
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.d_updatable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (this.d_insertRow != null) {
            this.d_rows.add(this.d_insertRow);
            if (this.d_curRow == 0) {
                this.d_curRow = Integer.MIN_VALUE;
            }
            this.d_rowStatus = (short)4;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (!this.d_updatable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        if (!this.d_updatable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (this.d_insertRow == null) {
            this.d_rows.remove(this.d_curRow - 1);
            this.d_rowStatus = 1;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public short getRowStatus() throws SQLException {
        return this.d_rowStatus;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (n < 1 || n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        if (this.d_insertRow == null) {
            if (this.validRow()) {
                Object[] objectArray = (Object[])this.d_rows.elementAt(this.d_curRow - 1);
                return objectArray[n - 1];
            }
        } else {
            return this.d_insertRow[n - 1];
        }
        return null;
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (!this.d_updatable) {
            throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
        }
        if (n < 1 || n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        if (this.d_insertRow == null) {
            if (this.validRow()) {
                Object[] objectArray = (Object[])this.d_rows.elementAt(this.d_curRow - 1);
                objectArray[n - 1] = object;
            }
        } else {
            this.d_insertRow[n - 1] = object;
        }
        this.d_rowStatus = (short)2;
    }

    private boolean validRow() {
        return this.d_curRow >= 1 && this.d_curRow < Integer.MAX_VALUE;
    }
}

