/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.Debug;
import com.pervasive.jdbc.common.Encoding;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.ConnectionInfo;
import com.pervasive.jdbc.lna.ConnectionOptions;
import com.pervasive.jdbc.lna.LNAEnvironment;
import com.pervasive.jdbc.lna.LNAObject;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.StatementOptions;
import com.pervasive.jdbc.lna.TableTypeSet;
import com.pervasive.jdbc.lna.TypeInfoSet;
import com.pervasive.jdbc.lna.VarData;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class LNAConnection
extends LNAObject {
    private int d_handle = 0;
    private ConnectionInfo d_connInfo = new ConnectionInfo();
    private TypeInfoSet d_typeInfoSet = new TypeInfoSet();
    private TableTypeSet d_tableTypeSet = new TableTypeSet();
    private ConnectionOptions d_connOpts = new ConnectionOptions(this);
    private StatementOptions d_stmtOpts = new StatementOptions();
    private String d_serverEncoding = null;
    private boolean d_autoTranslate = false;

    public LNAConnection(LNAEnvironment lNAEnvironment) {
        super(lNAEnvironment);
    }

    public String getServerEncoding() {
        return this.d_serverEncoding;
    }

    public void setServerEncoding(String string) throws SQLException {
        try {
            Encoding.checkEncoding(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.toString());
        }
        this.d_serverEncoding = string;
    }

    public ConnectionInfo getConnInfo() {
        return this.d_connInfo;
    }

    public TypeInfoSet getTypeInfoSet() {
        return this.d_typeInfoSet;
    }

    public TableTypeSet getTableTypeSet() {
        return this.d_tableTypeSet;
    }

    public ConnectionOptions getConnOpts() {
        return this.d_connOpts;
    }

    public StatementOptions getStmtOpts() {
        return this.d_stmtOpts;
    }

    public boolean scrollCapable() {
        Debug.println("Scroll Options:" + this.d_connInfo.d_qualifierUsage);
        Debug.println("Scroll Options:" + this.d_connInfo.d_scrollOptions);
        Debug.println("concur Options:" + this.d_connInfo.d_scrollConcurrency);
        return this.d_connInfo.d_scrollConcurrency != 1 || (this.d_connInfo.d_scrollOptions & 1) == 0 || (this.d_connInfo.d_scrollOptions & 0x10) == 0;
    }

    public boolean updateCapable() {
        return false;
    }

    public void setAutoTranslate() {
        this.d_autoTranslate = true;
    }

    public boolean getAutoTranslate() {
        return this.d_autoTranslate;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            super.close();
            this.disconnect();
        }
    }

    @Override
    public boolean isClosed() {
        return this.d_handle == 0;
    }

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        this.d_handle = lNAResponse.readInt();
        this.d_connInfo.readFrom(lNAResponse);
        this.d_typeInfoSet.readFrom(lNAResponse);
        this.d_tableTypeSet.readFrom(lNAResponse);
        lNAResponse.readBytes(200);
        this.d_connOpts.readFrom(lNAResponse);
        this.d_stmtOpts.readFrom(lNAResponse);
    }

    public void disconnect() throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(10);
            lNARequest.writeInt(this.d_handle);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            this.checkError(lNAResponse);
            this.d_handle = 0;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public int getConnOpt(short s) throws SQLException {
        this.d_errorsCleared = false;
        int n = -1;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(19);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeShort(s);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            n = lNAResponse.readInt();
            this.checkError(lNAResponse);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        return n;
    }

    public void setConnOpt(short s, int n) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(33);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeShort(s);
            VarData.writeIntTo(lNARequest, n);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            this.checkError(lNAResponse);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public void setConnOpt(short s, String string) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(33);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeShort(s);
            VarData.writeNullTermStringTo(lNARequest, string);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            this.checkError(lNAResponse);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement allocStmt() throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(1);
            lNARequest.writeInt(this.d_handle);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            this.checkError(lNAResponse);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public void transact(short s) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(46);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeShort(s);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            this.checkError(lNAResponse);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getTables(ColumnInfoSet columnInfoSet, String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.d_errorsCleared = false;
        StringBuffer stringBuffer = null;
        if (stringArray != null && stringArray.length != 0) {
            stringBuffer = new StringBuffer(128);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(',');
            }
        }
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(44);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeString(stringBuffer == null ? null : stringBuffer.toString());
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getColumns(ColumnInfoSet columnInfoSet, String string, String string2, String string3, String string4) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(7);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeString(string4);
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getSpecialColumns(ColumnInfoSet columnInfoSet, String string, String string2, String string3, int n, boolean bl, int n2) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(37);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeShort(n2);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeShort(n);
            lNARequest.writeShort(bl ? 1 : 0);
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getProcedures(ColumnInfoSet columnInfoSet, String string, String string2, String string3) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(30);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getProcedureColumns(ColumnInfoSet columnInfoSet, String string, String string2, String string3, String string4) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(28);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeString(string4);
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getStatistics(ColumnInfoSet columnInfoSet, String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(40);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeShort(bl ? 0 : 1);
            lNARequest.writeShort(bl2 ? 0 : 1);
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getPrimaryKeys(ColumnInfoSet columnInfoSet, String string, String string2, String string3) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(26);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public LNAStatement getForeignKeys(ColumnInfoSet columnInfoSet, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.d_errorsCleared = false;
        try {
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(16);
            lNARequest.writeInt(this.d_handle);
            lNARequest.writeString(string);
            lNARequest.writeString(string2);
            lNARequest.writeString(string3);
            lNARequest.writeString(string4);
            lNARequest.writeString(string5);
            lNARequest.writeString(string6);
            lNARequest.writeBoolean(false);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAStatement lNAStatement = new LNAStatement(this);
            lNAStatement.readFrom(lNAResponse);
            columnInfoSet.readFrom(lNAResponse);
            this.checkErrorWithCleanup(lNAResponse, lNAStatement);
            return lNAStatement;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    protected final void checkErrorWithCleanup(LNAResponse lNAResponse, LNAStatement lNAStatement) throws SQLException {
        try {
            this.checkError(lNAResponse);
        }
        catch (SQLException sQLException) {
            if (lNAStatement != null) {
                try {
                    lNAStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw sQLException;
        }
    }

    @Override
    public SQLException getErrors(boolean bl) throws SQLException {
        return this.getErrors(this.d_handle, 0, bl);
    }

    @Override
    public String getDBMSVersionString() {
        return this.getConnInfo().d_dbmsVersion;
    }
}

