/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.lna.ConnectionInfo;
import com.pervasive.jdbc.lna.LNAConnection;
import com.pervasive.jdbc.lna.LNAObject;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNASession;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;

public class LNAEnvironment
extends LNAObject {
    private static Hashtable encMappings = new Hashtable();

    public LNAEnvironment(LNASession lNASession) {
        super(lNASession);
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            super.close();
            try {
                this.d_session.close();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.d_session.isClosed();
    }

    public LNAConnection connect(String string) throws SQLException {
        this.d_errorsCleared = false;
        try {
            String string2;
            int n;
            byte[] byArray = string.getBytes(this.getEncoding());
            int n2 = byArray.length;
            byte[] byArray2 = new byte[n2 + 2];
            long l = System.currentTimeMillis();
            byArray2[0] = (byte)(l & 0xFFL);
            byArray2[1] = (byte)(l >>> 8 & 0xFFL);
            System.arraycopy(byArray, 0, byArray2, 2, n2);
            LNAEnvironment.encrypt(byArray2);
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(65);
            lNARequest.writeBytes(byArray2);
            lNARequest.writeInt(8192);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            LNAConnection lNAConnection = new LNAConnection(this);
            lNAConnection.readFrom(lNAResponse);
            ConnectionInfo connectionInfo = lNAConnection.getConnInfo();
            byte[] byArray3 = connectionInfo.d_outputConnectString;
            LNAEnvironment.decrypt(byArray3);
            byte[] byArray4 = new byte[byArray3.length - 2];
            System.arraycopy(byArray3, 2, byArray4, 0, byArray4.length);
            String string3 = "";
            String string4 = "CODEPAGE=";
            byte[] byArray5 = string4.getBytes();
            int n3 = this.search(byArray4, byArray5, 0);
            if (n3 != -1 && (n = this.search(byArray4, byArray5 = (string4 = ";").getBytes(), n3 + 1)) != -1) {
                string3 = new String(byArray4, n3 + 1, n - n3 - 1);
            }
            if ((string2 = (String)encMappings.get(string3)) == null) {
                if (string3 == "") {
                    lNAConnection.setServerEncoding("UTF-8");
                } else {
                    lNAConnection.setServerEncoding(string3);
                }
            } else {
                lNAConnection.setServerEncoding(string2);
            }
            try {
                if (lNAResponse.getReturnCode() == -19) {
                    lNAConnection.checkError(lNAResponse);
                }
                this.checkError(lNAResponse);
            }
            catch (SQLException sQLException) {
                lNAConnection.close();
                throw sQLException;
            }
            return lNAConnection;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    private static int gcd(int n, int n2) {
        return n == 0 ? n2 : (n2 == 0 ? n : (n > n2 ? LNAEnvironment.gcd(n % n2, n2) : LNAEnvironment.gcd(n, n2 % n)));
    }

    private static byte munge(byte by, int n) {
        return (byte)(by << (by + n & 7) | by >> (~(by + n) & 7));
    }

    private static void encrypt(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        block0: for (n = 1; n < n2; ++n) {
            if (LNAEnvironment.gcd(n, n2) > 1) continue;
            int n3 = 0;
            while (true) {
                int n4 = n3;
                if ((n3 = (n3 + n) % n2) == 0) continue block0;
                int n5 = n3;
                byArray[n5] = (byte)(byArray[n5] ^ LNAEnvironment.munge(byArray[n4], n3));
            }
        }
        for (n = 1; n < n2; ++n) {
            byArray[0] = (byte)(byArray[0] ^ byArray[n]);
        }
    }

    private static void decrypt(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = 1; n < n2; ++n) {
            byArray[0] = (byte)(byArray[0] ^ byArray[n]);
        }
        for (n = n2 - 1; n > 0; --n) {
            int n3;
            if (LNAEnvironment.gcd(n, n2) > 1) continue;
            int n4 = n2 - n;
            while ((n3 = n4) != 0) {
                n4 = (n4 - n + n2) % n2;
                int n5 = n3;
                byArray[n5] = (byte)(byArray[n5] ^ LNAEnvironment.munge(byArray[n4], n3));
            }
        }
    }

    int search(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            n4 = byArray[i] == byArray2[n4] ? ++n4 : (byArray[i] == byArray2[0] ? 1 : 0);
            if (n4 != n3) continue;
            return i;
        }
        return -1;
    }

    static {
        encMappings.put("CP932", "MS932");
        encMappings.put("EUCJP", "EUC_JP");
        encMappings.put("UTF-8", "UTF8");
        encMappings.put("ISO8859_1", "ISO8859_1");
        encMappings.put("ASCII", "ASCII");
        encMappings.put("CP437", "Cp437");
        encMappings.put("CP737", "Cp737");
        encMappings.put("CP775", "Cp775");
        encMappings.put("CP850", "Cp850");
        encMappings.put("CP852", "Cp852");
        encMappings.put("CP855", "Cp855");
        encMappings.put("CP857", "Cp857");
        encMappings.put("CP858", "Cp858");
        encMappings.put("CP862", "Cp862");
        encMappings.put("CP866", "Cp866");
        encMappings.put("CP1250", "Cp1250");
        encMappings.put("CP1251", "Cp1251");
        encMappings.put("CP1252", "Cp1252");
        encMappings.put("CP1253", "Cp1253");
        encMappings.put("CP1254", "Cp1254");
        encMappings.put("CP1255", "Cp1255");
        encMappings.put("CP1256", "Cp1256");
        encMappings.put("CP1257", "Cp1257");
        encMappings.put("CP1258", "Cp1258");
        encMappings.put("437", "Cp437");
        encMappings.put("737", "Cp737");
        encMappings.put("775", "Cp775");
        encMappings.put("850", "Cp850");
        encMappings.put("852", "Cp852");
        encMappings.put("855", "Cp855");
        encMappings.put("857", "Cp857");
        encMappings.put("858", "Cp858");
        encMappings.put("862", "Cp862");
        encMappings.put("866", "Cp866");
        encMappings.put("932", "MS932");
        encMappings.put("1250", "Cp1250");
        encMappings.put("1251", "Cp1251");
        encMappings.put("1252", "Cp1252");
        encMappings.put("1253", "Cp1253");
        encMappings.put("1254", "Cp1254");
        encMappings.put("1255", "Cp1255");
        encMappings.put("1256", "Cp1256");
        encMappings.put("1257", "Cp1257");
        encMappings.put("1258", "Cp1258");
        encMappings.put("EUC-JP", "EUC_JP");
    }
}

