/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.io.PacketOutputStream;
import com.pervasive.jdbc.common.CharacterEncoding;
import com.pervasive.jdbc.common.Encoding;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNAObject;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class LNARequest
extends DataOutputStream
implements CharacterEncoding {
    private static final int DEF_BUF_SIZE = 128;
    private int d_function;
    private short d_requestNumber;
    private short d_nextRequest;
    private Encoding d_encoding;
    private PacketOutputStream d_buffer;

    public LNARequest(LNAObject lNAObject) {
        super(null);
        this.d_encoding = lNAObject.getEncodingObject();
        this.d_buffer = new PacketOutputStream(128);
        this.out = this.d_buffer;
        this.skipHeader();
    }

    public LNARequest(LNAObject lNAObject, int n) {
        super(null);
        this.d_encoding = lNAObject.getEncodingObject();
        this.d_buffer = new PacketOutputStream(n);
        this.out = this.d_buffer;
        this.skipHeader();
    }

    public int getFunction() {
        return this.d_function;
    }

    public void setFunction(int n) {
        this.d_function = n;
    }

    public short getRequestNumber() {
        return this.d_requestNumber;
    }

    public void setRequestNumber(short s) {
        this.d_requestNumber = s;
    }

    public short getNextRequest() {
        return this.d_nextRequest;
    }

    public void setNextRequest(short s) {
        this.d_nextRequest = s;
    }

    public DataOutput getDataOutput() {
        return this;
    }

    public int getPosition() {
        return this.d_buffer.position();
    }

    public void seekToEnd() {
        this.d_buffer.seekToEnd();
    }

    public void seek(int n) {
        this.d_buffer.seek(n);
    }

    public void writeTime(Time time) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        this.writeShort(calendar.get(11));
        this.writeShort(calendar.get(12));
        this.writeShort(calendar.get(13));
    }

    public void writeDate(Date date) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.writeShort(calendar.get(1));
        this.writeShort(calendar.get(2) + 1);
        this.writeShort(calendar.get(5));
    }

    public void writeTimestamp(Timestamp timestamp) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        this.writeShort(calendar.get(1));
        this.writeShort(calendar.get(2) + 1);
        this.writeShort(calendar.get(5));
        this.writeShort(calendar.get(11));
        this.writeShort(calendar.get(12));
        this.writeShort(calendar.get(13));
        this.writeInt(timestamp.getNanos());
    }

    public void writeGUID(String string) throws IOException {
        String string2 = string;
        byte[] byArray = new byte[16];
        try {
            if (string.length() != 36) {
                throw new NumberFormatException();
            }
            string = string.replaceAll("-", "");
            int n = 0;
            for (int i = 0; i < string.length(); i += 2) {
                if (i + 2 > string.length()) {
                    throw new NumberFormatException();
                }
                int n2 = Integer.parseInt(string.trim().substring(i, i + 2), 16);
                byArray[n++] = new Integer(n2).byteValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(LocalStrings.ERR_SQL_INVALID_GUID_STRING + ": " + string2);
        }
        this.write(byArray, 0, byArray.length);
    }

    public void writeString(String string) throws IOException {
        this.writeString(string, this.getEncoding());
    }

    public void writeNullTermString(String string) throws IOException {
        this.writeNullTermString(string, this.getEncoding());
    }

    public void writeString(String string, String string2) throws IOException {
        if (string == null) {
            this.writeInt(-1);
            return;
        }
        byte[] byArray = string.getBytes(string2);
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeNullTermString(String string, String string2) throws IOException {
        if (string == null) {
            this.writeInt(-1);
            return;
        }
        byte[] byArray = string.getBytes(string2);
        this.writeInt(byArray.length + 1);
        this.write(byArray, 0, byArray.length);
        this.write(0);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            this.writeInt(0);
            return;
        }
        if (n > 0) {
            this.writeInt(n);
            this.write(byArray, 0, n);
        }
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        this.writeString(bigDecimal.toString());
    }

    public void writeNumeric(String string) throws IOException {
        byte[] byArray = new byte[19];
        if (string != null) {
            Comparable<StringBuffer> comparable;
            int n = string.length();
            int n2 = 0;
            boolean bl = true;
            if (string.charAt(0) == '-') {
                bl = false;
                --n;
                string = string.substring(1, string.length());
            }
            byArray[2] = (byte)(bl ? 1 : 0);
            int n3 = string.indexOf(".");
            if (n3 >= 0) {
                n2 = --n - n3;
                comparable = new StringBuffer(string);
                string = ((StringBuffer)comparable).substring(0, n3) + ((StringBuffer)comparable).substring(n3 + 1, string.length());
            }
            byArray[0] = (byte)n;
            byArray[1] = (byte)n2;
            comparable = new BigInteger(string);
            String string2 = ((BigInteger)comparable).toString(16);
            int n4 = 3;
            if (string2.length() % 2 != 0) {
                string2 = "0" + string2;
            }
            for (int i = string2.length(); i > 0; i -= 2) {
                byArray[n4] = (byte)Integer.parseInt(string2.substring(i - 2, i), 16);
                ++n4;
            }
        }
        this.write(byArray, 0, byArray.length);
    }

    public void writeBigInteger(String string) throws IOException {
        this.writeString(string);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.updateHeader();
        this.d_buffer.writeTo(outputStream);
        outputStream.flush();
    }

    @Override
    public String getEncoding() {
        return this.d_encoding.toString();
    }

    @Override
    public Encoding getEncodingObject() {
        return this.d_encoding;
    }

    @Override
    public void setEncoding(String string) {
        this.d_encoding.setEncoding(string);
    }

    public void reinit() {
        this.d_buffer.reset();
        this.d_buffer.seek(30);
    }

    public String resizeStringToFit(String string, int n) throws IOException {
        String string2 = this.d_encoding.getEncoding();
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        byte[] byArray = string.getBytes(string2);
        while (byArray.length > n) {
            string = string.substring(0, string.length() - 1);
            byArray = string.getBytes(string2);
        }
        return string;
    }

    private void skipHeader() {
        this.d_buffer.seek(30);
    }

    private void updateHeader() throws IOException {
        this.d_buffer.seek(0);
        int n = this.d_buffer.size();
        int n2 = n - 16;
        this.writeInt(666000666);
        this.writeInt(n);
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(n2);
        this.writeInt(n2);
        this.writeInt(this.d_function);
        this.writeShort(this.d_requestNumber);
        this.writeShort(this.d_nextRequest);
        this.writeShort(0);
        this.d_buffer.seekToEnd();
    }
}

