/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNAAbstractSession;
import com.pervasive.jdbc.lna.LNAPacket;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.PervasiveConnectionListener;
import java.io.EOFException;
import java.io.IOException;
import java.util.EventObject;

public class LNASocketSessionST
extends LNAAbstractSession {
    public LNASocketSessionST(JDBCURL jDBCURL, PervasiveConnectionListener pervasiveConnectionListener, boolean bl) {
        super(jDBCURL, pervasiveConnectionListener, bl);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.d_open) {
            this.d_open = false;
            this.d_in.close();
            this.d_out.close();
            this.d_socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LNAResponse request(LNARequest lNARequest) throws IOException {
        PervasiveConnectionListener pervasiveConnectionListener = null;
        if (!this.d_open) {
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        LNAResponse lNAResponse = new LNAResponse();
        lNAResponse.associateWithRequest(lNARequest);
        lNAResponse.setCurrentThread();
        short s = this.d_curReqNum;
        this.d_curReqNum = (short)(s + 1);
        Integer n = new Integer(s);
        try {
            Object object = this.getSyncObject();
            synchronized (object) {
                lNARequest.setRequestNumber(n.shortValue());
                lNARequest.setNextRequest(this.d_curReqNum);
                lNARequest.writeTo(this.d_out);
                lNARequest.close();
                this.d_out.flush();
                try {
                    LNAPacket lNAPacket = new LNAPacket();
                    lNAPacket.readFrom(this.d_in);
                    lNAResponse.setPacket(lNAPacket);
                    lNAResponse.readPacketData(this.d_in);
                }
                catch (EOFException eOFException) {
                    pervasiveConnectionListener = this.getEventListener();
                    if (pervasiveConnectionListener != null) {
                        EventObject eventObject = new EventObject(this);
                        pervasiveConnectionListener.connectionClosed(eventObject);
                    }
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
                }
            }
        }
        catch (IOException iOException) {
            pervasiveConnectionListener = this.getEventListener();
            if (pervasiveConnectionListener != null) {
                EventObject eventObject = new EventObject(this);
                pervasiveConnectionListener.connectionErrorOccurred(eventObject);
            }
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        return lNAResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LNAResponse request(LNARequest lNARequest, LNAResponse lNAResponse) throws IOException {
        PervasiveConnectionListener pervasiveConnectionListener = null;
        if (!this.d_open) {
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        lNAResponse.reinit();
        lNAResponse.associateWithRequest(lNARequest);
        lNAResponse.setCurrentThread();
        short s = this.d_curReqNum;
        this.d_curReqNum = (short)(s + 1);
        Integer n = new Integer(s);
        try {
            Object object = this.getSyncObject();
            synchronized (object) {
                lNARequest.setRequestNumber(n.shortValue());
                lNARequest.setNextRequest(this.d_curReqNum);
                lNARequest.writeTo(this.d_out);
                lNARequest.close();
                this.d_out.flush();
                try {
                    LNAPacket lNAPacket = new LNAPacket();
                    lNAPacket.readFrom(this.d_in);
                    lNAResponse.setPacket(lNAPacket);
                    lNAResponse.readPacketData(this.d_in);
                }
                catch (EOFException eOFException) {
                    pervasiveConnectionListener = this.getEventListener();
                    if (pervasiveConnectionListener != null) {
                        EventObject eventObject = new EventObject(this);
                        pervasiveConnectionListener.connectionClosed(eventObject);
                    }
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
                }
            }
        }
        catch (IOException iOException) {
            pervasiveConnectionListener = this.getEventListener();
            if (pervasiveConnectionListener != null) {
                EventObject eventObject = new EventObject(this);
                pervasiveConnectionListener.connectionErrorOccurred(eventObject);
            }
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        return lNAResponse;
    }

    protected Object getSyncObject() {
        return this.d_socket;
    }
}

