/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.TypeInfo;
import java.io.IOException;
import java.util.Hashtable;

public final class TypeInfoSet {
    private TypeInfo[] d_items;
    private Hashtable d_typeMap;

    public int getCount() {
        return this.d_items != null ? this.d_items.length : 0;
    }

    public TypeInfo getItem(int n) {
        return this.d_items[n];
    }

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        int n = lNAResponse.readInt();
        if (n < 0) {
            n = 0;
        }
        this.d_items = new TypeInfo[n];
        this.d_typeMap = new Hashtable();
        for (int i = 0; i < n; ++i) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.readFrom(lNAResponse);
            this.d_items[i] = typeInfo;
            this.d_typeMap.put(new Short(typeInfo.getDataType()), typeInfo);
        }
        lNAResponse.readShort();
    }

    public TypeInfo findType(short s) {
        return this.d_typeMap != null ? (TypeInfo)this.d_typeMap.get(new Short(s)) : null;
    }

    public TypeInfo findType(short s, boolean bl) {
        TypeInfo typeInfo = null;
        for (int i = 0; i < this.getCount(); ++i) {
            typeInfo = this.getItem(i);
            if (typeInfo.getDataType() != s || s != 3 && typeInfo.getUnsigned() == 0 != bl) continue;
            return typeInfo;
        }
        return null;
    }
}

