/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.ConnectionInfo;
import com.pervasive.jdbc.lna.InMemoryResultCache;
import com.pervasive.jdbc.lna.LNAConstants;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.TableTypeSet;
import com.pervasive.jdbc.lna.TypeInfo;
import com.pervasive.jdbc.lna.TypeInfoSet;
import com.pervasive.jdbc.v2.Connection;
import com.pervasive.jdbc.v2.Driver;
import com.pervasive.jdbc.v2.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private Connection d_conn;
    private ConnectionInfo d_connInfo;
    private String d_url;
    private Properties d_info;

    public DatabaseMetaData(Connection connection) {
        this.d_conn = connection;
        this.d_connInfo = connection.getLNAConnection().getConnInfo();
        this.d_url = connection.getURL();
        this.d_info = connection.getProperties();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.d_connInfo.d_accessProcs.equalsIgnoreCase("Y");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.d_connInfo.d_accessTables.equalsIgnoreCase("Y");
    }

    @Override
    public String getURL() throws SQLException {
        return this.d_url;
    }

    @Override
    public String getUserName() throws SQLException {
        return (String)this.d_info.get("user");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return !this.d_connInfo.d_readOnly.equalsIgnoreCase("N");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.d_connInfo.d_nullCollation == 0;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.d_connInfo.d_nullCollation == 1;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.d_connInfo.d_nullCollation == 2;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.d_connInfo.d_nullCollation == 4;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.d_connInfo.d_dbmsName;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.d_connInfo.d_dbmsVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return LocalStrings.DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(Driver.MAJOR_VERSION);
        stringBuffer.append('.');
        stringBuffer.append(Driver.MINOR_VERSION);
        return stringBuffer.toString();
    }

    @Override
    public int getDriverMajorVersion() {
        return Driver.getMajVer();
    }

    @Override
    public int getDriverMinorVersion() {
        return Driver.getMinVer();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.d_connInfo.d_identifierCase == 3;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.d_connInfo.d_quotedIdentifierCase == 3;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.d_connInfo.d_identifierCase == 1;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.d_connInfo.d_identifierCase == 2;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.d_connInfo.d_identifierCase == 4;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.d_connInfo.d_quotedIdentifierCase == 1;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.d_connInfo.d_quotedIdentifierCase == 2;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.d_connInfo.d_quotedIdentifierCase == 4;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return new String(this.d_connInfo.d_identifierQuoteChars);
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.d_connInfo.d_keywords;
    }

    private String getSupportedFunctions(int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            return "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ((n & 1 << i) == 0) continue;
            stringBuffer.append(",");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.substring(1);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.getSupportedFunctions(this.d_connInfo.d_numericFunctions, LNAConstants.NUMERIC_FUNCTIONS);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.getSupportedFunctions(this.d_connInfo.d_stringFunctions, LNAConstants.STRING_FUNCTIONS);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.getSupportedFunctions(this.d_connInfo.d_systemFunctions, LNAConstants.SYSTEM_FUNCTIONS);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.getSupportedFunctions(this.d_connInfo.d_timeDateFunctions, LNAConstants.TIMEDATE_FUNCTIONS);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return new String(this.d_connInfo.d_escape);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return new String(this.d_connInfo.d_specialChars);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return (this.d_connInfo.d_alterTable & 1) != 0;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return (this.d_connInfo.d_alterTable & 2) != 0;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.d_connInfo.d_columnAlias.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return (this.d_connInfo.d_convertFunctions & 1) != 0;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        int n3;
        switch (n) {
            case -5: {
                n3 = this.d_connInfo.d_convertBigInt;
                break;
            }
            case -2: {
                n3 = this.d_connInfo.d_convertBinary;
                break;
            }
            case -7: {
                n3 = this.d_connInfo.d_convertBit;
                break;
            }
            case 1: {
                n3 = this.d_connInfo.d_convertChar;
                break;
            }
            case 91: {
                n3 = this.d_connInfo.d_convertDate;
                break;
            }
            case 3: {
                n3 = this.d_connInfo.d_convertDecimal;
                break;
            }
            case 8: {
                n3 = this.d_connInfo.d_convertDouble;
                break;
            }
            case 6: {
                n3 = this.d_connInfo.d_convertFloat;
                break;
            }
            case 4: {
                n3 = this.d_connInfo.d_convertInteger;
                break;
            }
            case -4: {
                n3 = this.d_connInfo.d_convertLongVarBinary;
                break;
            }
            case 2: {
                n3 = this.d_connInfo.d_convertNumeric;
                break;
            }
            case 7: {
                n3 = this.d_connInfo.d_convertReal;
                break;
            }
            case 5: {
                n3 = this.d_connInfo.d_convertSmallInt;
                break;
            }
            case 92: {
                n3 = this.d_connInfo.d_convertTime;
                break;
            }
            case 93: {
                n3 = this.d_connInfo.d_convertTimestamp;
                break;
            }
            case -6: {
                n3 = this.d_connInfo.d_convertTinyInt;
                break;
            }
            case -3: {
                n3 = this.d_connInfo.d_convertVarBinary;
                break;
            }
            case 12: {
                n3 = this.d_connInfo.d_convertVarChar;
                break;
            }
            default: {
                return false;
            }
        }
        switch (n2) {
            case -5: {
                return (n3 & 0x4000) != 0;
            }
            case -2: {
                return (n3 & 0x400) != 0;
            }
            case -7: {
                return (n3 & 0x1000) != 0;
            }
            case 1: {
                return (n3 & 1) != 0;
            }
            case 91: {
                return (n3 & 0x8000) != 0;
            }
            case 3: {
                return (n3 & 4) != 0;
            }
            case 8: {
                return (n3 & 0x80) != 0;
            }
            case 6: {
                return (n3 & 0x20) != 0;
            }
            case 4: {
                return (n3 & 8) != 0;
            }
            case -4: {
                return (n3 & 0x40000) != 0;
            }
            case 2: {
                return (n3 & 2) != 0;
            }
            case 7: {
                return (n3 & 0x40) != 0;
            }
            case 5: {
                return (n3 & 0x10) != 0;
            }
            case 92: {
                return (n3 & 0x10000) != 0;
            }
            case 93: {
                return (n3 & 0x20000) != 0;
            }
            case -6: {
                return (n3 & 0x2000) != 0;
            }
            case -3: {
                return (n3 & 0x800) != 0;
            }
            case 12: {
                return (n3 & 0x100) != 0;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.d_connInfo.d_corrName != 0;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.d_connInfo.d_corrName == 1;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.d_connInfo.d_exprInOrderBy.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.d_connInfo.d_orderByInSelect.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.d_connInfo.d_groupBy != 0;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.d_connInfo.d_groupBy == 3;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.d_connInfo.d_groupBy == 2;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.d_connInfo.d_likeEscapes.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.d_connInfo.d_multResultSets.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.d_connInfo.d_nonNullableColumns == 1;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return (this.d_connInfo.d_sqlConformance & 1) != 0;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return (this.d_connInfo.d_sqlConformance & 2) != 0;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return (this.d_connInfo.d_sqlConformance & 0) != 0;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return (this.d_connInfo.d_sqlConformance & 1) != 0;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return (this.d_connInfo.d_sqlConformance & 2) != 0;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.d_connInfo.d_IEF.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.d_connInfo.d_outerJoins.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.d_connInfo.d_outerJoins.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return new String(this.d_connInfo.d_ownerTerm);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return new String(this.d_connInfo.d_procedureTerm);
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return new String(this.d_connInfo.d_qualifierTerm);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return String.valueOf(this.d_connInfo.d_qualifierNameSep);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return (this.d_connInfo.d_ownerUsage & 1) != 0;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return (this.d_connInfo.d_ownerUsage & 2) != 0;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return (this.d_connInfo.d_ownerUsage & 4) != 0;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return (this.d_connInfo.d_ownerUsage & 8) != 0;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return (this.d_connInfo.d_ownerUsage & 0x10) != 0;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return (this.d_connInfo.d_qualifierUsage & 1) != 0;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return (this.d_connInfo.d_qualifierUsage & 2) != 0;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return (this.d_connInfo.d_qualifierUsage & 4) != 0;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return (this.d_connInfo.d_qualifierUsage & 8) != 0;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return (this.d_connInfo.d_qualifierUsage & 0x10) != 0;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return (this.d_connInfo.d_posStatements & 1) != 0;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return (this.d_connInfo.d_posStatements & 2) != 0;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return (this.d_connInfo.d_posStatements & 4) != 0;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.d_connInfo.d_procedures.equalsIgnoreCase("Y");
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return (this.d_connInfo.d_subqueries & 1) != 0;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return (this.d_connInfo.d_subqueries & 2) != 0;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return (this.d_connInfo.d_subqueries & 4) != 0;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return (this.d_connInfo.d_subqueries & 8) != 0;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return (this.d_connInfo.d_subqueries & 0x10) != 0;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return (this.d_connInfo.d_union & 1) != 0;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return (this.d_connInfo.d_union & 2) != 0;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.d_connInfo.d_cursorCommitBehavior == 2;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.d_connInfo.d_cursorRollbackBehavior == 2;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.d_connInfo.d_cursorCommitBehavior == 1;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.d_connInfo.d_cursorRollbackBehavior == 1;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.d_connInfo.d_maxBinaryLiteral;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.d_connInfo.d_maxCharLiteral;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.d_connInfo.d_maxColumnNameLength;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.d_connInfo.d_maxColumnsInGroupBy;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.d_connInfo.d_maxColumnsInIndex;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.d_connInfo.d_maxColumnsInOrderBy;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.d_connInfo.d_maxColumnsInSelect;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.d_connInfo.d_maxColumnsInTable;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.d_connInfo.d_numConnections;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 255;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.d_connInfo.d_maxIndexSize;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.d_connInfo.d_maxOwnerNameLength;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.d_connInfo.d_maxProcNameLength;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.d_connInfo.d_maxQualifierNameLength;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.d_connInfo.d_maxRowSize;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.d_connInfo.d_maxRowSizeLongs.equalsIgnoreCase("Y");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.d_connInfo.d_maxStmtLength;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.d_connInfo.d_numStatements;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.d_connInfo.d_maxTableNameLength;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.d_connInfo.d_maxTablesInSelect;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.d_connInfo.d_maxUserNameLength;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.d_connInfo.d_defaultIsolation;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.d_connInfo.d_txnCapable != 0;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        int n2;
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            default: {
                throw new SQLException(LocalStrings.ERR_SQL_UNKNOWN_ISOLATION_LEVEL, "S1092", 0);
            }
        }
        return (this.d_connInfo.d_txnIsolationOption & n2) != 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.d_connInfo.d_txnCapable == 2;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.d_connInfo.d_txnCapable == 4;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.d_connInfo.d_txnCapable == 3;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.d_connInfo.d_txnCapable == 4;
    }

    @Override
    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        int n = LNAConstants.COLPRIVS_COL_DATA.length;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet(n);
        for (int i = 0; i < n; ++i) {
            columnInfoSet.addColumn((short)LNAConstants.COLPRIVS_COL_DATA[i][0], LNAConstants.COLPRIVS_COL_DATA[i][1], (short)LNAConstants.COLPRIVS_COL_DATA[i][2], (short)LNAConstants.COLPRIVS_COL_DATA[i][3], LNAConstants.COLPRIVS_COL_DATA[i][4], LNAConstants.COLPRIVS_COL_DATA[i][5], LNAConstants.COLPRIVS_COL_DATA[i][6], LNAConstants.COLPRIVS_COL_STR_DATA[i][0], LNAConstants.COLPRIVS_COL_STR_DATA[i][1], null, null, null);
        }
        return new ResultSet(this.d_conn.getLNAConnection(), columnInfoSet, new InMemoryResultCache(columnInfoSet, false), 1004, 1007);
    }

    @Override
    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        int n = LNAConstants.TABPRIVS_COL_DATA.length;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet(n);
        for (int i = 0; i < n; ++i) {
            columnInfoSet.addColumn((short)LNAConstants.TABPRIVS_COL_DATA[i][0], LNAConstants.TABPRIVS_COL_DATA[i][1], (short)LNAConstants.TABPRIVS_COL_DATA[i][2], (short)LNAConstants.TABPRIVS_COL_DATA[i][3], LNAConstants.TABPRIVS_COL_DATA[i][4], LNAConstants.TABPRIVS_COL_DATA[i][5], LNAConstants.TABPRIVS_COL_DATA[i][6], LNAConstants.TABPRIVS_COL_STR_DATA[i][0], LNAConstants.TABPRIVS_COL_STR_DATA[i][1], null, null, null);
        }
        return new ResultSet(this.d_conn.getLNAConnection(), columnInfoSet, new InMemoryResultCache(columnInfoSet, false), 1004, 1007);
    }

    @Override
    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getProcedures(columnInfoSet, string, string2, string3);
        columnInfoSet.getItem(0).setColumnTags("PROCEDURE_CAT");
        columnInfoSet.getItem(1).setColumnTags("PROCEDURE_SCHEM");
        columnInfoSet.getItem(2).setColumnTags("PROCEDURE_NAME");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getProcedureColumns(columnInfoSet, string, string2, string3, string4);
        columnInfoSet.getItem(0).setColumnTags("PROCEDURE_CAT");
        columnInfoSet.getItem(1).setColumnTags("PROCEDURE_SCHEM");
        columnInfoSet.getItem(2).setColumnTags("PROCEDURE_NAME");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getTables(columnInfoSet, string, string2, string3, stringArray);
        columnInfoSet.getItem(0).setColumnTags("TABLE_CAT");
        columnInfoSet.getItem(1).setColumnTags("TABLE_SCHEM");
        columnInfoSet.getItem(2).setColumnTags("TABLE_NAME");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    private String getCatalogName() {
        try {
            java.sql.ResultSet resultSet = this.getTables(null, null, "X$File", null);
            resultSet.next();
            return resultSet.getString(1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public java.sql.ResultSet getSchemas() throws SQLException {
        ColumnInfoSet columnInfoSet = new ColumnInfoSet(1);
        columnInfoSet.addColumn((short)1, 128, (short)0, (short)0, 128, 128, 0, "TABLE_SCHEM", "TABLE_SCHEM", null, null, null);
        InMemoryResultCache inMemoryResultCache = new InMemoryResultCache(columnInfoSet, true);
        inMemoryResultCache.open();
        inMemoryResultCache.moveToInsertRow();
        inMemoryResultCache.updateObject(1, this.getCatalogName());
        inMemoryResultCache.insertRow();
        inMemoryResultCache.absolute(Integer.MIN_VALUE);
        inMemoryResultCache.makeReadOnly();
        return new ResultSet(this.d_conn.getLNAConnection(), columnInfoSet, inMemoryResultCache, 1004, 1007);
    }

    @Override
    public java.sql.ResultSet getCatalogs() throws SQLException {
        ColumnInfoSet columnInfoSet = new ColumnInfoSet(1);
        columnInfoSet.addColumn((short)1, 128, (short)0, (short)0, 128, 128, 0, "TABLE_CAT", "TABLE_CAT", null, null, null);
        InMemoryResultCache inMemoryResultCache = new InMemoryResultCache(columnInfoSet, true);
        inMemoryResultCache.open();
        inMemoryResultCache.moveToInsertRow();
        inMemoryResultCache.updateObject(1, this.getCatalogName());
        inMemoryResultCache.insertRow();
        inMemoryResultCache.absolute(Integer.MIN_VALUE);
        inMemoryResultCache.makeReadOnly();
        return new ResultSet(this.d_conn.getLNAConnection(), columnInfoSet, inMemoryResultCache, 1004, 1007);
    }

    @Override
    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getColumns(columnInfoSet, string, string2, string3, string4);
        columnInfoSet.getItem(0).setColumnTags("TABLE_CAT");
        columnInfoSet.getItem(1).setColumnTags("TABLE_SCHEM");
        columnInfoSet.getItem(6).setColumnTags("COLUMN_SIZE");
        columnInfoSet.getItem(7).setColumnTags("BUFFER_LENGTH");
        columnInfoSet.getItem(8).setColumnTags("DECIMAL_DIGITS");
        columnInfoSet.getItem(9).setColumnTags("NUM_PREC_RADIX");
        columnInfoSet.getItem(12).setCheckForUTF8Encoding();
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getSpecialColumns(columnInfoSet, string, string2, string3, n, bl, 1);
        columnInfoSet.getItem(4).setColumnTags("COLUMN_SIZE");
        columnInfoSet.getItem(5).setColumnTags("BUFFER_LENGTH");
        columnInfoSet.getItem(6).setColumnTags("DECIMAL_DIGITS");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getSpecialColumns(columnInfoSet, string, string2, string3, 0, true, 2);
        columnInfoSet.getItem(4).setColumnTags("COLUMN_SIZE");
        columnInfoSet.getItem(5).setColumnTags("BUFFER_LENGTH");
        columnInfoSet.getItem(6).setColumnTags("DECIMAL_DIGITS");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null || string3.trim().length() == 0) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_TABLE_VALUE, "S1000", 0);
        }
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getPrimaryKeys(columnInfoSet, string, string2, string3);
        columnInfoSet.getItem(0).setColumnTags("TABLE_CAT");
        columnInfoSet.getItem(1).setColumnTags("TABLE_SCHEM");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null || string3.trim().length() == 0) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_TABLE_VALUE, "S1000", 0);
        }
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getForeignKeys(columnInfoSet, null, null, null, string, string2, string3);
        columnInfoSet.getItem(0).setColumnTags("PKTABLE_CAT");
        columnInfoSet.getItem(1).setColumnTags("PKTABLE_SCHEM");
        columnInfoSet.getItem(4).setColumnTags("FKTABLE_CAT");
        columnInfoSet.getItem(5).setColumnTags("FKTABLE_SCHEM");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null || string3.trim().length() == 0) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_TABLE_VALUE, "S1000", 0);
        }
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getForeignKeys(columnInfoSet, string, string2, string3, null, null, null);
        columnInfoSet.getItem(0).setColumnTags("PKTABLE_CAT");
        columnInfoSet.getItem(1).setColumnTags("PKTABLE_SCHEM");
        columnInfoSet.getItem(4).setColumnTags("FKTABLE_CAT");
        columnInfoSet.getItem(5).setColumnTags("FKTABLE_SCHEM");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string3 == null || string3.trim().length() == 0 || string6 == null || string6.trim().length() == 0) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_TABLE_VALUE, "S1000", 0);
        }
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        if (string5 != null && string5.equals("")) {
            string5 = null;
        }
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getForeignKeys(columnInfoSet, string, string2, string3, string4, string5, string6);
        columnInfoSet.getItem(0).setColumnTags("PKTABLE_CAT");
        columnInfoSet.getItem(1).setColumnTags("PKTABLE_SCHEM");
        columnInfoSet.getItem(4).setColumnTags("FKTABLE_CAT");
        columnInfoSet.getItem(5).setColumnTags("FKTABLE_SCHEM");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public java.sql.ResultSet getTableTypes() throws SQLException {
        ColumnInfoSet columnInfoSet = new ColumnInfoSet(1);
        columnInfoSet.addColumn((short)1, 128, (short)0, (short)0, 128, 128, 0, "TABLE_TYPE", "TABLE_TYPE", null, null, null);
        InMemoryResultCache inMemoryResultCache = new InMemoryResultCache(columnInfoSet, true);
        inMemoryResultCache.open();
        TableTypeSet tableTypeSet = this.d_conn.getLNAConnection().getTableTypeSet();
        for (int i = 0; i < tableTypeSet.getCount(); ++i) {
            inMemoryResultCache.moveToInsertRow();
            inMemoryResultCache.updateObject(1, tableTypeSet.getItem(i).getTableTypeName());
            inMemoryResultCache.insertRow();
        }
        inMemoryResultCache.absolute(Integer.MIN_VALUE);
        inMemoryResultCache.makeReadOnly();
        return new ResultSet(this.d_conn.getLNAConnection(), columnInfoSet, inMemoryResultCache, 1004, 1007);
    }

    @Override
    public java.sql.ResultSet getTypeInfo() throws SQLException {
        ColumnInfoSet columnInfoSet = new ColumnInfoSet(18);
        for (int i = 0; i < 18; ++i) {
            columnInfoSet.addColumn((short)LNAConstants.TYPEINFO_COL_DATA[i][0], LNAConstants.TYPEINFO_COL_DATA[i][1], (short)LNAConstants.TYPEINFO_COL_DATA[i][2], (short)LNAConstants.TYPEINFO_COL_DATA[i][3], LNAConstants.TYPEINFO_COL_DATA[i][4], LNAConstants.TYPEINFO_COL_DATA[i][5], LNAConstants.TYPEINFO_COL_DATA[i][6], LNAConstants.TYPEINFO_COL_STR_DATA[i][0], LNAConstants.TYPEINFO_COL_STR_DATA[i][1], null, null, null);
        }
        InMemoryResultCache inMemoryResultCache = new InMemoryResultCache(columnInfoSet, true);
        inMemoryResultCache.open();
        TypeInfoSet typeInfoSet = this.d_conn.getLNAConnection().getTypeInfoSet();
        TypeInfo typeInfo = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < typeInfoSet.getCount(); ++i) {
            inMemoryResultCache.moveToInsertRow();
            typeInfo = typeInfoSet.getItem(i);
            inMemoryResultCache.updateObject(1, typeInfo.getTypeName());
            inMemoryResultCache.updateObject(2, new Integer(typeInfo.getDataType()));
            inMemoryResultCache.updateObject(3, new Integer(typeInfo.getPrecision()));
            string = typeInfo.getLiteralPrefix();
            string2 = typeInfo.getLiteralSuffix();
            string3 = typeInfo.getCreateParams();
            inMemoryResultCache.updateObject(4, string == null || string.equals("") ? null : string);
            inMemoryResultCache.updateObject(5, string2 == null || string2.equals("") ? null : string2);
            inMemoryResultCache.updateObject(6, string3 == null || string3.equals("") ? null : string3);
            inMemoryResultCache.updateObject(7, new Short(typeInfo.getNullable()));
            inMemoryResultCache.updateObject(8, new Boolean(typeInfo.getCaseSensitive() == 1));
            inMemoryResultCache.updateObject(9, new Short(typeInfo.getSearchable()));
            inMemoryResultCache.updateObject(10, new Boolean(typeInfo.getUnsigned() == 1));
            inMemoryResultCache.updateObject(11, new Boolean(typeInfo.getMoney() == 1));
            inMemoryResultCache.updateObject(12, new Boolean(typeInfo.getAutoIncrement() == 1));
            inMemoryResultCache.updateObject(13, typeInfo.getLocalTypeName());
            inMemoryResultCache.updateObject(14, new Short(typeInfo.getMinScale()));
            inMemoryResultCache.updateObject(15, new Short(typeInfo.getMaxScale()));
            inMemoryResultCache.updateObject(16, null);
            inMemoryResultCache.updateObject(17, null);
            switch (typeInfo.getDataType()) {
                case -7: {
                    inMemoryResultCache.updateObject(18, new Integer(2));
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    inMemoryResultCache.updateObject(18, new Integer(10));
                    break;
                }
                default: {
                    inMemoryResultCache.updateObject(18, null);
                }
            }
            inMemoryResultCache.insertRow();
        }
        inMemoryResultCache.absolute(Integer.MIN_VALUE);
        inMemoryResultCache.makeReadOnly();
        ResultSet resultSet = new ResultSet(this.d_conn.getLNAConnection(), columnInfoSet, inMemoryResultCache, 1004, 1007);
        return resultSet;
    }

    @Override
    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (string3 == null || string3.trim().length() == 0) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_TABLE_VALUE, "S1000", 0);
        }
        string2 = null;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet();
        LNAStatement lNAStatement = this.d_conn.getLNAConnection().getStatistics(columnInfoSet, string, string2, string3, bl, bl2);
        columnInfoSet.getItem(0).setColumnTags("TABLE_CAT");
        columnInfoSet.getItem(1).setColumnTags("TABLE_SCHEM");
        columnInfoSet.getItem(7).setColumnTags("ORDINAL_POSITION");
        columnInfoSet.getItem(9).setColumnTags("ASC_OR_DESC");
        return new ResultSet(columnInfoSet, lNAStatement, true);
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n != 1003 || n2 != 1008;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return n == 1005;
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public java.sql.ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        int n = LNAConstants.UDT_COL_DATA.length;
        ColumnInfoSet columnInfoSet = new ColumnInfoSet(n);
        for (int i = 0; i < n; ++i) {
            columnInfoSet.addColumn((short)LNAConstants.UDT_COL_DATA[i][0], LNAConstants.UDT_COL_DATA[i][1], (short)LNAConstants.UDT_COL_DATA[i][2], (short)LNAConstants.UDT_COL_DATA[i][3], LNAConstants.UDT_COL_DATA[i][4], LNAConstants.UDT_COL_DATA[i][5], LNAConstants.UDT_COL_DATA[i][6], LNAConstants.UDT_COL_STR_DATA[i][0], LNAConstants.UDT_COL_STR_DATA[i][1], null, null, null);
        }
        return new ResultSet(this.d_conn.getLNAConnection(), columnInfoSet, new InMemoryResultCache(columnInfoSet, false), 1004, 1007);
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.d_conn;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public java.sql.ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public java.sql.ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public java.sql.ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

