/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.DataTypeUtils;
import com.pervasive.jdbc.lna.ParamDesc;
import com.pervasive.jdbc.lna.ParamDescSet;
import com.pervasive.jdbc.lna.ParamInfo;
import com.pervasive.jdbc.lna.ParamInfoSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class ParameterMetaData
implements java.sql.ParameterMetaData {
    private ParamDescSet paramDescSet;
    private ParamInfoSet paramInfoSet;

    ParameterMetaData(ParamDescSet paramDescSet, ParamInfoSet paramInfoSet) {
        this.paramDescSet = paramDescSet;
        this.paramInfoSet = paramInfoSet;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.paramDescSet.getCount();
    }

    @Override
    public int isNullable(int n) throws SQLException {
        ParamDesc paramDesc = this.paramDescSet.getItem(n - 1);
        return paramDesc.getNullable();
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        ParamDesc paramDesc = this.paramDescSet.getItem(n - 1);
        switch (paramDesc.getBindType()) {
            case -25: 
            case -6: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        ParamDesc paramDesc = this.paramDescSet.getItem(n - 1);
        return paramDesc.getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLException {
        ParamDesc paramDesc = this.paramDescSet.getItem(n - 1);
        return paramDesc.getScale();
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        ParamDesc paramDesc = this.paramDescSet.getItem(n - 1);
        return DataTypeUtils.getSQLTypeForDataType(paramDesc.getDataType());
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        ParamDesc paramDesc = this.paramDescSet.getItem(n - 1);
        return DataTypeUtils.getTypeNameForDataType(paramDesc.getDataType(), paramDesc.getBindType());
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        ParamDesc paramDesc = this.paramDescSet.getItem(n - 1);
        return DataTypeUtils.getClassNameForDataType(paramDesc.getDataType());
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        ParamInfo paramInfo = this.paramInfoSet.getItem(n - 1);
        return paramInfo.getParamType();
    }
}

