/***************************************************************************
 **
 **  Copyright Actian Corporation All Rights Reserved.
 **
 ***************************************************************************/

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class DBSample extends Applet {

    public boolean m_fApplet = true;
    protected Connection m_Connection = null;
    private String m_strServer = null;
    private String m_strPort = null;
    private String m_strDataSource = null;
    private String m_strUser = null;
    private String m_strPassword = null;
    private String m_szDisconnectLabel = new String("Disconnect");
    private String m_szConnectLabel = new String("Connect");

    //**************************
    // So it runs as an application also.
    //**************************
    public static void main(String args[]) {
        new AppletFrame(new DBSample(), 477, 395, args);
    }

    void mBtExecute_Clicked(Event event) {
        m_results.setText("Executing: " + m_txSQL.getText() + "\n\n");

        try {
            //Create the statement
            Statement statement = m_Connection.createStatement();

            //Execute the SQL command
            ResultSet resultSet = statement.executeQuery(m_txSQL.getText());

            // Display the results
            if (null != resultSet)
            {
                displayResults(resultSet);

                //Close the result set and statement
                resultSet.close();
            }
            statement.close();
        } catch(SQLException e) {
            showError(e);
            return;
        }

    }

    void mBtTables_Clicked(Event event) {
        m_results.setText("Getting Tables\n\n");
        try {
            //Create the statement
            DatabaseMetaData databaseMetaData = m_Connection.getMetaData();
            //Get the list of tables
            ResultSet resultSet = databaseMetaData.getTables(null, null,
                                                             null, null);
            if (null != resultSet) {
                // Display the results
                displayResults(resultSet);

                //Close the result set and statement
                resultSet.close();
            }
        } catch(SQLException e) {
            showError(e);
            return;
        }
    }

    void mBtInfo_Clicked(Event event) {
        m_results.setText("Database Information\n\n");
        try {
            //Create the statement
            DatabaseMetaData databaseMetaData = m_Connection.getMetaData();

            m_results.append("Driver name : " + databaseMetaData.getDriverName() + "\n");
            m_results.append("Driver version : " + databaseMetaData.getDriverVersion() + "\n");
            m_results.append("Database name : " + databaseMetaData.getDatabaseProductName() + "\n");
            m_results.append("Database version : " + databaseMetaData.getDatabaseProductVersion() + "\n");
        } catch(SQLException e) {
            showError(e);
            return;
        }
    }

    void mBtDisconnect_Clicked(Event event) {
        try {
            m_Connection.close();
        } catch(Exception e) {}

        m_Connection = null;
        m_btInfo.setEnabled(false);
        m_btExecute.setEnabled(false);
        m_btTables.setEnabled(false);
        m_txSQL.setEnabled(false);
        m_txSQL.setText("");
        m_results.setText("");
        m_btConnect.setLabel(m_szConnectLabel);
    }

    void mBtConnect_Clicked(Event event) {

        String  szURL = new String("jdbc:pervasive://");

        szURL += m_txServer.getText();
        szURL += ":";
        szURL += m_txPort.getText();
        szURL += "/";
        szURL += m_txDatasource.getText();

        m_results.setText("Connecting to " + szURL + "\n\n");

        // Register the PSQL Client for JDBC
        // This is a trick so it works in browsers
        // Normally use Class.forName("pervasive.jdbc.PervasiveDriver")
        pervasive.jdbc.PervasiveDriver sd = new pervasive.jdbc.PervasiveDriver();

        try {
            Properties props = new Properties();
            props.put("user", m_txUserName.getText());
            props.put("password", m_txPassword.getText());
            props.put("ExecDesc", "DBSample");
            props.put("ArrayFetchOn", "1");
            props.put("ArrayBufferSize", "8");

            m_Connection = DriverManager.getConnection(szURL, props);

            // Below is an alternative means of obtaining a connection.
            //
            // m_Connection = DriverManager.getConnection(szURL,
            //                                            m_txUserName.getText(),
            //                                            m_txPassword.getText());

            m_Connection.clearWarnings();
        } catch(SQLException e)  {
            showError(e);
            return;
        }

        m_results.append("Connection successful\n");
        m_btInfo.setEnabled(true);
        m_btExecute.setEnabled(true);
        m_btTables.setEnabled(true);
        m_txSQL.setEnabled(true);
        m_btConnect.setLabel(m_szDisconnectLabel);
    }

    protected void showError(SQLException e)
    {
        m_results.append("\nERROR\n");

        while(e != null) {
            m_results.append("Message:  " +    e.getMessage() + "\n");
            m_results.append("SQLState: " +    e.getSQLState() + "\n");
            m_results.append("Vendor:   " +    e.getErrorCode() + "\n");
            e = e.getNextException();
        }
    }

    protected void displayResults(ResultSet resultSet) throws SQLException
    {
        // Get the ResultSetMetaData.  This will be used for
        // the column headings
        if (null != resultSet) {
            ResultSetMetaData resultMetaData = resultSet.getMetaData();

            // Get the number of columns in the result set
            int numCols = resultMetaData.getColumnCount();

            //Make a temporary string to store the columns to
            String szData = null;

            // Display column headings
            for (int i=1; i<=numCols; i++) {
                if (i > 1) {
                    m_results.append(",");
                }
                m_results.append(resultMetaData.getColumnLabel(i));
            }
            m_results.append("\n");

            // Display all of the data
            while(resultSet.next()) {

                for (int i=1; i<=numCols; i++) {
                    if (i > 1) {
                        m_results.append(",");
                    }
                    szData = resultSet.getString(i);

                    if (szData != null) {
                        m_results.append(szData);
                    } else {
                        m_results.append("<null>");
                    }
                }
                m_results.append("\n");
                // Fetch the next result set row
            }
        }
    }

    //User interface functions
    public void paint(Graphics g)
    {
        draw3DFrame(g, "SQL Commands", 12,156,444,84);
        draw3DFrame(g, "Results", 12,252,444,116);
        draw3DFrame(g, "Connection", 12,12,444,132);
    }

    protected void draw3DFrame(Graphics g, String szLabel, int x, int y, int width, int height)
    {
        g.setColor(Color.gray);
        g.drawLine(x, y, x, y + height);
        g.drawLine(x, y, x + width, y);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        g.setColor(Color.white);
        g.drawLine(x , y + height, x + width, y + height);
        g.drawLine(x + width, y, x + width, y + height);
        g.drawLine(x + 1, y + 1, x + width - 1, y + 1);
        g.drawLine(x +  1, y + 1, x + 1, y + height - 1);

        g.setColor(Color.lightGray);

        FontMetrics fm = g.getFontMetrics();
        g.fillRect(x + 5, y, fm.stringWidth(szLabel) + 10, 2);

        g.setColor(Color.black);
        g.drawString(szLabel, x + 10, y + 5);

    }
    public void init()
    {
        super.init();

        m_strServer = getParameter("Server");
        m_strPort = getParameter("Port");
        m_strDataSource= getParameter("DSN");
        m_strUser = getParameter("User");
        m_strPassword = getParameter("Password");
        if (null == m_strServer || m_strServer == "") {
            if (getCodeBase().getProtocol().equalsIgnoreCase("file")) {
                // File URL's will probably fail in a browser
                m_strServer = null;
            } else {
                m_strServer = getCodeBase().getHost();
            }
        }

        //{{INIT_CONTROLS
        setLayout(null);
        if(m_fApplet) {
            addNotify();
        } else {
            getParentFrame().addNotify();
        }

        resize(477,395);
        setForeground(Color.black);
        setBackground(Color.lightGray);
        label5 = new java.awt.Label("Password:");
        label5.setBounds(240,48,72,24);
        add(label5);
        label4 = new java.awt.Label("User:");
        label4.setBounds(240,24,84,24);
        add(label4);

        m_txServer = new java.awt.TextField();
        m_txServer.setBounds(120,24,120,24);
        Font fn = this.getFont();
        m_txServer.setFont(new Font(fn.getName(), fn.getStyle(), 10));
        add(m_txServer);
        m_txServer.setText(m_strServer);
        m_txPort = new java.awt.TextField();
        m_txPort.setBounds(120,48,120,24);
        m_txPort.setFont(new Font(fn.getName(), fn.getStyle(), 10));
        add(m_txPort);
        m_txPort.setText(m_strPort);
        m_txDatasource = new java.awt.TextField();
        m_txDatasource.setBounds(120,72,120,24);
        //System.out.println("Font: name = ["+ fn.getName()+ "] style[" + fn.getStyle() + "] size = ["+ fn.getSize() +"]");
        m_txDatasource.setFont(new Font(fn.getName(), fn.getStyle(), 10));
        add(m_txDatasource);
        m_txDatasource.setText(m_strDataSource);
        m_txUserName = new java.awt.TextField();
        m_txUserName.setBounds(324,24,120,24);
        m_txUserName.setFont(new Font(fn.getName(), fn.getStyle(), 10));
        add(m_txUserName);
        m_txUserName.setText(m_strUser);
        m_txPassword = new java.awt.TextField();
        m_txPassword.setBounds(324,48,120,24);
        m_txPassword.setFont(new Font(fn.getName(), fn.getStyle(), 10));
        add(m_txPassword);
        try { // Netscape doesn't support this
            m_txPassword.setEchoChar('*');
        } catch (java.lang.NoSuchMethodError e) {
        }
        m_txPassword.setText(m_strPassword);
        label1 = new java.awt.Label("Server Name:");
        label1.setBounds(18,24,94,24);
        add(label1);
        label2 = new java.awt.Label("Server Port:");
        label2.setBounds(18,48,94,24);
        add(label2);
        label3 = new java.awt.Label("Server DSN:");
        label3.setBounds(18,72,94,24);
        add(label3);
        m_btConnect = new java.awt.Button(m_szConnectLabel);
        m_btConnect.setBounds(24,108,120,24);
        add(m_btConnect);
        m_btTables = new java.awt.Button("View Tables");
        m_btTables.setEnabled(false);
        m_btTables.setBounds(324,108,120,24);
        add(m_btTables);
        m_btInfo = new java.awt.Button("Database Info");
        m_btInfo.setEnabled(false);
        m_btInfo.setBounds(168,108,120,24);
        add(m_btInfo);
        m_lbSQL = new java.awt.Label("SQL Command:");
        m_lbSQL.setBounds(18,168,104,24);
        add(m_lbSQL);
        m_txSQL = new java.awt.TextField();
        m_txSQL.setFont(new Font(fn.getName(), fn.getStyle(), 10));
        m_txSQL.setEnabled(false);
        m_txSQL.setBounds(120,168,324,24);
        add(m_txSQL);
        m_btExecute = new java.awt.Button("Execute");
        m_btExecute.setEnabled(false);
        m_btExecute.setBounds(24,204,120,24);
        add(m_btExecute);
        m_results = new java.awt.TextArea();
        m_results.setBounds(24,264,420,96);
        m_results.setFont(new Font(fn.getName(), fn.getStyle(), 10));
        add(m_results);

    }
    public boolean handleEvent(Event event) {
        if (event.target == m_btConnect && event.id == Event.ACTION_EVENT) {
            if(m_btConnect.getLabel() == m_szDisconnectLabel) {
                mBtDisconnect_Clicked(event);
            } else {
                mBtConnect_Clicked(event);
            }
            return true;
        }
        if (event.target == m_btExecute && event.id == Event.ACTION_EVENT) {
            mBtExecute_Clicked(event);
            return true;
        }
        if (event.target == m_btInfo && event.id == Event.ACTION_EVENT) {
            mBtInfo_Clicked(event);
            return true;
        }
        if (event.target == m_btTables && event.id == Event.ACTION_EVENT) {
            mBtTables_Clicked(event);
            return true;
        }
        return super.handleEvent(event);
    }
    // ****************************************
    // returns the Frame upon which the applet
    //  was built.
    // ****************************************
    public final Frame getParentFrame()
    {
        Container frame = getParent();
        while(frame != null && !(frame instanceof Frame)) {
        frame = frame.getParent();
    }
    return (Frame)frame;
 }


    java.awt.Label label5;
    java.awt.Label label4;
    java.awt.TextField m_txPassword;
    java.awt.TextField m_txUserName;
    java.awt.TextField m_txDatasource;
    java.awt.TextField m_txPort;
    java.awt.TextField m_txServer;
    java.awt.Label label1;
    java.awt.Label label2;
    java.awt.Label label3;
    java.awt.Button m_btConnect;
    java.awt.Button m_btTables;
    java.awt.Button m_btInfo;
    java.awt.Label m_lbSQL;
    java.awt.TextField m_txSQL;
    java.awt.Button m_btExecute;
    java.awt.TextArea m_results;

} // end DBSample Class
// ****************************************************
// Class for running this as an application
// ****************************************************

final class AppletFrame extends Frame implements AppletStub, AppletContext {

  // ************************************
  // Constructor
  // ************************************
  // defaulting to the localhost,(127.0.0.1)
  // if there is no argument passed in to override.
  public static String serverURL = new String("http://127.0.0.1");

  public AppletFrame(DBSample applet, int width, int height, String[] arg) {
    setTitle(applet.getClass().getName());
    setSize(width, height);
    add("Center", applet);
    setSize(width, height);
    applet.setStub(this);
    applet.m_fApplet = false;
    applet.init();
    setVisible(true);
    applet.start();
  }

  public final boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) {
      System.exit(0);
    }
    return super.handleEvent(evt);
  }

  // AppletStub methods
  public final boolean isActive() {
    return true;
  }

  public final URL getDocumentBase() {
    URL returnValue = null;
    try {
      returnValue = new URL(serverURL);
    } catch(MalformedURLException e) {
      e.printStackTrace();
    }
    return returnValue;
  }

  public final URL getCodeBase() {
    URL returnValue = null;
    try {
      returnValue = new URL(serverURL);
    } catch(MalformedURLException e) {
      e.printStackTrace();
    }
    return returnValue;
  }

  public final String getParameter(String parameterName) {
    return "";
  }

  public final AppletContext getAppletContext() {
    return this;
  }

  public final void appletResize(int width, int height) {
    this.setSize(width, height);
  }

  // AppletContext methods
  public final AudioClip getAudioClip (URL url) {
    return null;
  }
  public final Image getImage(URL url) {
    return null;
  }
  public final Applet getApplet(String name) {
    return null;
  }
  public final Enumeration getApplets() {
    return null;
  }
  public final void showDocument(URL url) {
  }
  public final void showDocument(URL url, String target) {
  }
  public final void showStatus(String status) {
  }
  public void setStream(String key, InputStream stream)throws IOException {
  }
  public InputStream getStream(String key) {
	  return null;
  }
  public Iterator getStreamKeys() {
	  return null;
  }
}
