/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.common;

import com.pervasive.jdbc.common.Debug;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DebugInputStream
extends FilterInputStream {
    private int d_lineCount;

    public DebugInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            this.print(" <eof>");
            this.newLine();
        } else {
            this.printByte(n);
            this.print(" <eot>");
            this.newLine();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n < 0) {
            this.print(" <eof>");
            this.newLine();
        } else {
            for (int i = 0; i < n; ++i) {
                this.printByte(byArray[i]);
            }
            this.print(" <eot>");
            this.newLine();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 < 0) {
            this.print(" <eof>");
            this.newLine();
        } else {
            for (int i = 0; i < n3; ++i) {
                this.printByte(byArray[i + n]);
            }
            this.print(" <eot>");
            this.newLine();
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        if (l2 < 0L) {
            this.print(" <eof>");
            this.newLine();
        } else {
            this.print(" <skipped " + l2 + ">");
            this.newLine();
        }
        return l2;
    }

    public String toString() {
        return "DebugInputStream@" + Integer.toHexString(this.hashCode());
    }

    private void print(String string) {
        if (this.d_lineCount == 0) {
            Debug.print(this.toString() + ":");
        }
        Debug.print(string);
    }

    private void newLine() {
        Debug.println();
        this.d_lineCount = 0;
    }

    private void printByte(int n) {
        String string = Integer.toHexString(n & 0xFF);
        if (string.length() < 2) {
            string = "0" + string;
        }
        this.print(" " + string);
        if (++this.d_lineCount >= 16) {
            this.newLine();
        }
    }
}

