/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.Debug;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ColumnInfo;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.FetchReader;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.LongDataInputStream;
import com.pervasive.jdbc.lna.ResultCache;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class ForwardReadResultCache
implements ResultCache,
FetchReader {
    protected static final int MAX_FETCH_SIZE = 1000;
    protected static final int DEFAULT_FETCH_SIZE = 10;
    protected static final int BUF_START = 0;
    protected LNAStatement d_lnaStmt;
    protected ColumnInfoSet d_cis;
    protected boolean d_isClosed;
    protected int d_fetchSize;
    protected int d_nextFetchSize;
    protected Object[][] d_fetchBuf;
    protected short[] d_rowStats;
    protected int d_bufPos;
    protected int d_bufCount;
    protected int d_curRow;
    protected boolean d_isLast;
    protected InputStream d_curStream;
    private boolean d_dropOnClose;

    public ForwardReadResultCache(LNAStatement lNAStatement, ColumnInfoSet columnInfoSet) {
        this(lNAStatement, columnInfoSet, false);
    }

    public ForwardReadResultCache(LNAStatement lNAStatement, ColumnInfoSet columnInfoSet, boolean bl) {
        this.d_lnaStmt = lNAStatement;
        this.d_cis = columnInfoSet;
        this.d_isClosed = true;
        this.d_nextFetchSize = this.d_fetchSize = this.d_lnaStmt.getStmtOpts().getRowSetSize();
        this.d_dropOnClose = bl;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void open() throws SQLException {
        if (this.d_isClosed) {
            this.d_isClosed = false;
            this.doFetch();
            this.d_isLast = false;
            this.d_curRow = this.d_bufCount > 0 ? Integer.MIN_VALUE : 0;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.d_isClosed) {
            this.d_isClosed = true;
            this.freeBuffers();
            this.d_curRow = 0;
            if (this.d_dropOnClose) {
                this.d_lnaStmt.close();
            } else {
                this.d_lnaStmt.freeStmt((short)0);
            }
        }
    }

    @Override
    public final boolean isClosed() {
        return this.d_isClosed;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_INCORRECT_CURSOR_TYPE);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.d_nextFetchSize;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        if (n <= 0) {
            n = 10;
        } else if (n > 1000) {
            n = 1000;
        }
        this.d_lnaStmt.getStmtOpts().setRowSetSize(n);
        this.d_nextFetchSize = n;
    }

    protected final void checkRowError() throws SQLException {
        if (this.d_rowStats[this.d_bufPos] == 5) {
            SQLException sQLException = this.d_lnaStmt.getErrors(false);
            throw sQLException;
        }
    }

    protected final boolean checkRowError(boolean bl) throws SQLException {
        if (bl) {
            this.checkRowError();
        }
        return bl;
    }

    @Override
    public int getRow() throws SQLException {
        return this.d_lnaStmt.getStmtOpts().getRowNumber();
    }

    @Override
    public boolean isRow(int n) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_INCORRECT_CURSOR_TYPE);
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_INCORRECT_CURSOR_TYPE);
    }

    @Override
    public synchronized boolean relative(int n, boolean bl) throws SQLException {
        if (n != 1 || !bl) {
            throw new SQLException(LocalStrings.ERR_SQL_INCORRECT_CURSOR_TYPE);
        }
        if (this.d_curRow == Integer.MAX_VALUE) {
            return false;
        }
        if (this.d_curRow == 0) {
            return false;
        }
        if (this.d_bufCount == 0) {
            return false;
        }
        if (this.d_curRow == Integer.MIN_VALUE) {
            this.d_curRow = 1;
            this.d_bufPos = 0;
            this.checkRowError();
            return true;
        }
        if (this.d_bufPos + 1 < this.d_bufCount) {
            ++this.d_bufPos;
            ++this.d_curRow;
            this.checkRowError();
            return true;
        }
        if (this.d_bufPos + 1 == this.d_bufCount) {
            if (this.d_bufCount == this.d_fetchSize) {
                this.doFetch();
                if (this.d_bufCount == 0) {
                    this.d_curRow = Integer.MAX_VALUE;
                    return false;
                }
                ++this.d_curRow;
                this.checkRowError();
                return true;
            }
            this.d_curRow = Integer.MAX_VALUE;
            this.d_bufCount = 0;
            this.d_bufPos = 0;
            return false;
        }
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public short getRowStatus() throws SQLException {
        return this.validRow() ? (short)0 : 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(int n) throws SQLException {
        if (n < 1) throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        if (n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        if (!this.validRow()) return null;
        this.closeStream();
        Object object = this.d_fetchBuf[this.d_bufPos][n - 1];
        if (object != null) return object;
        ColumnInfo columnInfo = this.d_cis.getItem(n - 1);
        if (!columnInfo.hasLongData()) return object;
        this.setPosition(this.d_bufPos + 1);
        this.d_curStream = new LongDataInputStream(this.d_lnaStmt, (short)n, columnInfo.getBindType());
        object = this.d_curStream;
        try {
            if (!((LongDataInputStream)this.d_curStream).isNull()) return object;
            return null;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void readFrom(LNAResponse lNAResponse) throws IOException {
        int n;
        this.d_bufCount = 0;
        this.d_bufPos = 0;
        int n2 = this.d_cis.getCount();
        int n3 = lNAResponse.readInt();
        int n4 = lNAResponse.readInt();
        int n5 = lNAResponse.readInt();
        if (n3 == 0 || n2 == 0) {
            return;
        }
        if (this.d_rowStats == null || this.d_rowStats.length != this.d_nextFetchSize) {
            this.d_rowStats = new short[this.d_nextFetchSize];
        }
        if (this.d_fetchBuf == null || this.d_fetchBuf.length != n3 || this.d_fetchBuf[0].length != n2) {
            this.d_fetchBuf = new Object[n3][this.d_cis.getCount()];
        }
        this.d_fetchBuf = new Object[n3][n2];
        for (n = 0; n < this.d_nextFetchSize; ++n) {
            this.d_rowStats[n] = lNAResponse.readShort();
        }
        if (n3 > 0) {
            for (n = 0; n < n3; ++n) {
                int n6;
                if (this.d_rowStats[n] != 3 && this.d_rowStats[n] != 5) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        this.d_fetchBuf[n][n6] = this.d_cis.getItem(n6).readValueFrom(lNAResponse);
                    }
                    ++this.d_bufCount;
                    continue;
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    this.d_fetchBuf[n][n6] = null;
                }
                if (this.d_rowStats[n] != 5) continue;
                ++this.d_bufCount;
            }
        }
        this.d_fetchSize = this.d_nextFetchSize;
    }

    private void printRowStatus() {
        block8: for (int i = 0; i < this.d_fetchSize; ++i) {
            switch (this.d_rowStats[i]) {
                case 0: {
                    continue block8;
                }
                case 3: {
                    Debug.println("NOROW");
                    continue block8;
                }
                case 1: {
                    Debug.println("DELETED");
                    continue block8;
                }
                case 2: {
                    Debug.println("UPDATED");
                    continue block8;
                }
                case 4: {
                    Debug.println("ADDED");
                    continue block8;
                }
                case 5: {
                    Debug.println("ERROR");
                }
            }
        }
    }

    @Override
    public void readFrom(LNAResponse lNAResponse, ColumnInfoSet columnInfoSet) throws IOException {
        throw new IOException(LocalStrings.ERR_NOT_IMPL);
    }

    private boolean validRow() {
        return this.d_curRow >= 1 && this.d_curRow < Integer.MAX_VALUE || this.d_curRow <= -1 && this.d_curRow > Integer.MIN_VALUE;
    }

    protected void setPosition(int n) throws SQLException {
        this.d_lnaStmt.setPos((short)n, (short)0, (short)0, this.d_cis, null, this.d_rowStats, null, null);
    }

    private void doFetch() throws SQLException {
        this.d_lnaStmt.extendedFetch((short)1, 0, this.d_cis, this);
    }

    private void closeStream() {
        if (this.d_curStream != null) {
            try {
                this.d_curStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.d_curStream = null;
        }
    }

    private void checkBuffers() {
        int n = this.d_fetchSize + 0;
        if (this.d_fetchBuf == null || this.d_fetchBuf.length != n) {
            Object[] objectArray = this.d_fetchBuf != null ? this.d_fetchBuf[0] : null;
            this.d_fetchBuf = new Object[n][this.d_cis.getCount()];
            if (objectArray != null) {
                this.d_fetchBuf[0] = objectArray;
            }
        }
    }

    private void freeBuffers() {
        this.d_fetchBuf = null;
    }

    class RowInfo {
        short status;
        int bookmark;

        RowInfo() {
        }
    }
}

