/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IPXSocket {
    private int m_fd;
    private boolean m_isClosed = true;
    private IPXInputStream m_in;
    private IPXOutputStream m_out;

    public IPXSocket(String string, int n) throws IOException {
        int[] nArray = new int[]{-1};
        int n2 = IPXSocket.connect(string, n, nArray);
        this.m_fd = nArray[0];
        if (n2 != 0) {
            this.m_isClosed = true;
            throw new IOException("could not connect");
        }
        this.m_isClosed = false;
    }

    public void close() {
        if (!this.m_isClosed) {
            this.m_isClosed = true;
            IPXSocket.close(this.m_fd);
        }
    }

    public void finalize() {
        this.close();
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_isClosed) {
            throw new IOException("socket closed");
        }
        if (this.m_in == null) {
            this.m_in = new IPXInputStream();
        }
        return this.m_in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.m_isClosed) {
            throw new IOException("socket closed");
        }
        if (this.m_out == null) {
            this.m_out = new IPXOutputStream();
        }
        return this.m_out;
    }

    private static native int connect(String var0, int var1, int[] var2);

    static native int write(int var0, byte[] var1);

    static native int write(int var0, byte[] var1, int var2, int var3);

    static native int read(int var0, byte[] var1, int var2, int var3);

    static native int close(int var0);

    static {
        try {
            System.loadLibrary("pvjdbc2");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class IPXOutputStream
    extends OutputStream {
        private IPXOutputStream() {
        }

        @Override
        public void close() throws IOException {
            IPXSocket.this.close();
        }

        @Override
        public void write(int n) throws IOException {
            if (IPXSocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            byte[] byArray = new byte[]{(byte)n};
            int n2 = IPXSocket.write(IPXSocket.this.m_fd, byArray);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            if (IPXSocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            int n = IPXSocket.write(IPXSocket.this.m_fd, byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (IPXSocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            int n3 = 0;
            n3 = n == 0 && n2 >= byArray.length ? IPXSocket.write(IPXSocket.this.m_fd, byArray) : IPXSocket.write(IPXSocket.this.m_fd, byArray, n, n2 > byArray.length ? byArray.length : n2);
        }
    }

    private class IPXInputStream
    extends InputStream {
        private IPXInputStream() {
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            IPXSocket.this.close();
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            if (IPXSocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            return n == 0 ? -1 : byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (IPXSocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            int n3 = IPXSocket.read(IPXSocket.this.m_fd, byArray, n, n2);
            return n2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (IPXSocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            int n = IPXSocket.read(IPXSocket.this.m_fd, byArray, 0, byArray.length);
            return byArray.length;
        }
    }
}

