/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.CharacterEncoding;
import com.pervasive.jdbc.common.Encoding;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNASession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public abstract class LNAObject
implements CharacterEncoding {
    protected LNASession d_session;
    protected LNAObject d_parent;
    protected Vector d_children;
    protected boolean d_errorsCleared;
    protected Encoding d_encoding;

    public LNAObject(LNASession lNASession) {
        this.d_session = lNASession;
    }

    public LNAObject(LNAObject lNAObject) {
        this.d_session = lNAObject.d_session;
        this.d_parent = lNAObject;
        this.d_parent.addChild(this);
        this.d_encoding = this.d_parent.getEncodingObject();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public String getEncoding() {
        return this.d_encoding.toString();
    }

    @Override
    public Encoding getEncodingObject() {
        return this.d_encoding;
    }

    @Override
    public void setEncoding(String string) throws UnsupportedEncodingException {
        if (this.d_encoding == null) {
            this.d_encoding = new Encoding(string);
        } else {
            this.d_encoding.setEncoding(string);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.d_parent != null) {
            this.d_parent.removeChild(this);
            this.d_parent = null;
        }
        if (this.d_children != null) {
            while (!this.d_children.isEmpty()) {
                LNAObject lNAObject = (LNAObject)this.d_children.lastElement();
                lNAObject.close();
            }
            this.d_children = null;
        }
    }

    public abstract boolean isClosed();

    private void addChild(LNAObject lNAObject) {
        if (this.d_children == null) {
            this.d_children = new Vector();
        }
        this.d_children.addElement(lNAObject);
    }

    private void removeChild(LNAObject lNAObject) {
        if (this.d_children != null) {
            this.d_children.removeElement(lNAObject);
        }
    }

    public final void clearErrors() {
        this.d_errorsCleared = true;
    }

    public SQLException getErrors(boolean bl) throws SQLException {
        return this.getErrors(0, 0, bl);
    }

    protected final SQLException getErrors(int n, int n2, boolean bl) throws SQLException {
        int n3 = 87;
        int n4 = this.getDBMSMajorVersion();
        if (n4 < 12) {
            n3 = 12;
        }
        if (this.d_errorsCleared) {
            return null;
        }
        try {
            int n5;
            LNARequest lNARequest = new LNARequest(this);
            lNARequest.setFunction(n3);
            lNARequest.writeInt(n);
            lNARequest.writeInt(n2);
            LNAResponse lNAResponse = this.d_session.request(lNARequest);
            SQLException sQLException = null;
            SQLException sQLException2 = null;
            String string = "UTF-8";
            if (n3 == 12) {
                string = this.getEncoding();
            }
            int n6 = lNAResponse.readInt();
            for (n5 = 0; n5 < n6; ++n5) {
                SQLException sQLException3;
                String string2 = lNAResponse.readString(string);
                int n7 = lNAResponse.readInt();
                String string3 = lNAResponse.readString(string);
                if (bl) {
                    sQLException3 = new SQLWarning(string3, string2, n7);
                    if (sQLException == null) {
                        sQLException = sQLException3;
                    } else {
                        ((SQLWarning)sQLException2).setNextWarning((SQLWarning)sQLException3);
                    }
                    sQLException2 = sQLException3;
                    continue;
                }
                sQLException3 = new SQLException(string3, string2, n7);
                if (sQLException == null) {
                    sQLException = sQLException3;
                } else {
                    sQLException2.setNextException(sQLException3);
                }
                sQLException2 = sQLException3;
            }
            lNAResponse.readShort();
            n5 = lNAResponse.getReturnCode();
            if (n5 < 0) {
                sQLException = bl ? new SQLWarning(LocalStrings.ERR_LNA_GET_ERRORS, "S1000", n5) : new SQLException(LocalStrings.ERR_LNA_GET_ERRORS, "S1000", n5);
            }
            return sQLException;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    protected final void checkError(LNAResponse lNAResponse) throws SQLException {
        short s = lNAResponse.getReturnCode();
        if (s < 0) {
            SQLException sQLException = this.getErrors(false);
            if (sQLException == null) {
                sQLException = new SQLException(LocalStrings.ERR_SQL_UNKNOWN_ERROR + " : " + s, "S1000", s);
            }
            throw sQLException;
        }
    }

    protected String getDBMSVersionString() {
        return "";
    }

    protected int getDBMSMajorVersion() {
        String string = this.getDBMSVersionString();
        int n = 0;
        if (string.length() > 0) {
            string = string.substring(0, string.indexOf(46));
            n = Integer.parseInt(string);
        }
        return n;
    }

    protected int getDBMSMinorVersion() {
        String string = this.getDBMSVersionString();
        int n = 0;
        if (string.length() > 0) {
            int n2 = string.indexOf(46);
            string = string.substring(n2 + 1, string.indexOf(46));
            n = Integer.parseInt(string);
        }
        return n;
    }
}

