/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.io.YourByteArrayOutputStream;
import com.pervasive.jdbc.common.Debug;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.FetchReader;
import com.pervasive.jdbc.lna.LNAConnection;
import com.pervasive.jdbc.lna.LNAObject;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.ParamDescSet;
import com.pervasive.jdbc.lna.ParamInfo;
import com.pervasive.jdbc.lna.ParamInfoSet;
import com.pervasive.jdbc.lna.StatementOptions;
import com.pervasive.jdbc.lna.VarData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.SQLException;

public class LNAStatement
extends LNAObject {
    protected static final int CHUNK_SIZE = 24576;
    private int d_handle = 0;
    private String d_cursorName;
    private StatementOptions d_stmtOpts;
    private LNARequest d_req;
    private LNAResponse d_res;

    public LNAStatement(LNAConnection lNAConnection) {
        super(lNAConnection);
        this.d_stmtOpts = new StatementOptions(this, lNAConnection.getStmtOpts());
        this.d_req = new LNARequest(this);
        this.d_res = new LNAResponse();
    }

    public LNAConnection getLNAConnection() {
        return (LNAConnection)this.d_parent;
    }

    public StatementOptions getStmtOpts() {
        return this.d_stmtOpts;
    }

    public boolean scrollCapable() {
        LNAConnection lNAConnection = (LNAConnection)this.d_parent;
        return lNAConnection.scrollCapable();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (!this.isClosed()) {
            this.freeStmt((short)1);
        }
    }

    @Override
    public boolean isClosed() {
        return this.d_handle == 0;
    }

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        this.d_handle = lNAResponse.readInt();
    }

    public void generateCursorName() throws SQLException {
        String string = "JDBC_CUR" + Integer.toHexString(this.d_handle);
        this.setCursorName(string);
    }

    public String getCursorName() {
        return this.d_cursorName;
    }

    public void cancelStmt() throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(4);
            this.d_req.writeInt(this.d_handle);
            this.d_session.request(this.d_req, this.d_res);
            this.checkError(this.d_res);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public void freeStmt(short s) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(18);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeShort(s);
            this.d_session.request(this.d_req, this.d_res);
            this.checkError(this.d_res);
            if (s == 1) {
                this.d_handle = 0;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public int getStmtOpt(short s) throws SQLException {
        this.d_errorsCleared = false;
        int n = -1;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(22);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeShort(s);
            this.d_session.request(this.d_req, this.d_res);
            int n2 = 0;
            while ((n2 = this.d_res.read()) != -1) {
                Debug.println(n2);
            }
            this.checkError(this.d_res);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        return n;
    }

    public void setStmtOpt(short s, int n) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(35);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeShort(s);
            VarData.writeIntTo(this.d_req, n);
            this.d_session.request(this.d_req, this.d_res);
            this.checkError(this.d_res);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public void setCursorName(String string) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(34);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeString(string);
            this.d_session.request(this.d_req, this.d_res);
            this.checkError(this.d_res);
            this.d_cursorName = string;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public void prepare(String string, ColumnInfoSet columnInfoSet, ParamDescSet paramDescSet) throws SQLException {
        this.d_errorsCleared = false;
        try {
            int n;
            String string2;
            this.d_req.reinit();
            if (this.shouldUseUTF8()) {
                string2 = "UTF-8";
                n = 85;
            } else {
                string2 = this.getEncoding();
                n = 25;
            }
            this.d_req.setFunction(n);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeString(string, string2);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            columnInfoSet.readFrom(this.d_res);
            paramDescSet.readFrom(this.d_res);
            this.checkError(this.d_res);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    public int execute(ParamInfoSet paramInfoSet) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(14);
            this.d_req.writeInt(this.d_handle);
            paramInfoSet.writeTo(this.d_req);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            short s = this.d_res.getReturnCode();
            paramInfoSet.readFrom(this.d_res);
            int n = this.d_res.readInt();
            if (s == -15) {
                n = this.sendParams(paramInfoSet);
            } else {
                this.checkError(this.d_res);
            }
            return n;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public int execDirect(String string, ParamInfoSet paramInfoSet, ColumnInfoSet columnInfoSet, ParamDescSet paramDescSet) throws SQLException {
        this.d_errorsCleared = false;
        try {
            int n;
            String string2;
            this.d_req.reinit();
            if (this.shouldUseUTF8()) {
                string2 = "UTF-8";
                n = 84;
            } else {
                string2 = this.getEncoding();
                n = 13;
            }
            this.d_req.setFunction(n);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeString(string, string2);
            paramInfoSet.writeTo(this.d_req);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            short s = this.d_res.getReturnCode();
            columnInfoSet.readFrom(this.d_res);
            paramDescSet.readFrom(this.d_res);
            paramInfoSet.readFrom(this.d_res);
            int n2 = this.d_res.readInt();
            if (s == -15) {
                n2 = this.sendParams(paramInfoSet);
            } else {
                this.checkError(this.d_res);
            }
            return n2;
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.toString());
            sQLException.initCause(iOException);
            throw sQLException;
        }
    }

    public int execDirFetch(String string, ParamInfoSet paramInfoSet, ColumnInfoSet columnInfoSet, ParamDescSet paramDescSet, FetchReader fetchReader) throws SQLException {
        this.d_errorsCleared = false;
        try {
            int n;
            String string2;
            this.d_req.reinit();
            if (this.shouldUseUTF8()) {
                string2 = "UTF-8";
                n = 86;
            } else {
                string2 = this.getEncoding();
                n = 49;
            }
            this.d_req.setFunction(n);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeString(string, string2);
            paramInfoSet.writeTo(this.d_req);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            short s = this.d_res.getReturnCode();
            columnInfoSet.readFrom(this.d_res);
            paramDescSet.readFrom(this.d_res);
            paramInfoSet.readFrom(this.d_res);
            int n2 = this.d_res.readInt();
            fetchReader.readFrom(this.d_res, columnInfoSet);
            if (s != -16) {
                this.checkError(this.d_res);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public boolean moreResults() throws SQLException {
        this.d_errorsCleared = false;
        try {
            boolean bl;
            this.d_req.reinit();
            this.d_req.setFunction(23);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            boolean bl2 = bl = this.d_res.getReturnCode() == -16;
            if (!bl) {
                this.checkError(this.d_res);
            }
            return !bl;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public short fetch(ColumnInfoSet columnInfoSet, FetchReader fetchReader) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(15);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeBoolean(false);
            columnInfoSet.writeBindingTo(this.d_req);
            this.d_session.request(this.d_req, this.d_res);
            short s = this.d_res.getReturnCode();
            fetchReader.readFrom(this.d_res);
            if (s != -16) {
                this.checkError(this.d_res);
            }
            return s;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public short arrayFetch(ColumnInfoSet columnInfoSet, FetchReader fetchReader) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(2);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeBoolean(false);
            columnInfoSet.writeBindingTo(this.d_req);
            this.d_session.request(this.d_req, this.d_res);
            short s = this.d_res.getReturnCode();
            fetchReader.readFrom(this.d_res);
            if (s != -16) {
                this.checkError(this.d_res);
            }
            return s;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public short extendedFetch(short s, int n, ColumnInfoSet columnInfoSet, FetchReader fetchReader) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(66);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeShort(s);
            this.d_req.writeInt(n);
            this.d_req.writeBoolean(false);
            this.d_req.writeBoolean(false);
            columnInfoSet.writeBindingTo(this.d_req);
            this.d_req.writeInt(1);
            if (this.d_stmtOpts.getUseBookmarks() == 1) {
                this.d_req.writeShort(-18);
                this.d_req.writeInt(4);
                this.d_req.writeShort(0);
            } else {
                this.d_req.writeShort(0);
                this.d_req.writeInt(0);
                this.d_req.writeShort(0);
            }
            this.d_session.request(this.d_req, this.d_res);
            short s2 = this.d_res.getReturnCode();
            fetchReader.readFrom(this.d_res);
            if (s2 != -16) {
                this.checkError(this.d_res);
            }
            return s2;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public short setPos(short s, short s2, short s3, ColumnInfoSet columnInfoSet, ParamInfoSet paramInfoSet, short[] sArray, Object[] objectArray, boolean[] blArray) throws SQLException {
        short s4;
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(67);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeShort(s);
            this.d_req.writeShort(s2);
            this.d_req.writeShort(s3);
            this.d_req.writeBoolean(false);
            if (paramInfoSet == null) {
                this.d_req.writeShort(0);
                this.d_req.writeInt(-1);
            } else {
                paramInfoSet.writeDataAtExecParams(this.d_req);
            }
            columnInfoSet.writeBindingTo(this.d_req);
            this.d_req.writeInt(1);
            this.d_req.writeShort(-18);
            this.d_req.writeInt(4);
            this.d_req.writeShort(0);
            switch (s2) {
                case 0: {
                    this.d_req.writeInt(2);
                    this.d_req.writeInt(2);
                    this.d_req.writeShort(sArray[s - 1]);
                    break;
                }
                case 1: {
                    this.d_req.writeInt(2);
                    this.d_req.writeInt(2);
                    this.d_req.writeShort(sArray[s - 1]);
                    break;
                }
                case 2: {
                    columnInfoSet.writeFixedColumns(this.d_req, objectArray, sArray[s - 1], blArray);
                    break;
                }
                case 3: {
                    this.d_req.writeInt(2);
                    this.d_req.writeInt(2);
                    this.d_req.writeShort(sArray[s - 1]);
                    break;
                }
                case 4: {
                    columnInfoSet.writeFixedColumns(this.d_req, objectArray, sArray[s - 1], blArray);
                    break;
                }
                default: {
                    this.d_req.writeInt(0);
                    this.d_req.writeInt(-1);
                }
            }
            this.d_session.request(this.d_req, this.d_res);
            int n = this.d_res.readInt();
            this.d_res.readInt();
            s4 = n != 0 ? this.d_res.readShort() : (short)0;
            short s5 = this.d_res.getReturnCode();
            int n2 = 0;
            if (s5 == -15) {
                n2 = this.sendLongCols(paramInfoSet);
            } else {
                this.checkError(this.d_res);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        return s4;
    }

    public int getLongData(short s, short s2, int n, byte[] byArray) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(21);
            this.d_req.writeInt(this.d_handle);
            this.d_req.writeShort(s);
            this.d_req.writeShort(s2);
            this.d_req.writeInt(n);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            short s3 = this.d_res.getReturnCode();
            int n2 = VarData.readBytesFrom(this.d_res, byArray);
            if (s3 != -16) {
                this.checkError(this.d_res);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    private int sendParams(ParamInfoSet paramInfoSet) throws SQLException {
        int n;
        int n2 = 0;
        int n3 = paramInfoSet.getCount();
        while ((n = this.startParamData()) == -2) {
            ParamInfo paramInfo = null;
            while (n2 < n3 && !(paramInfo = paramInfoSet.getItem(n2)).hasLongData()) {
                ++n2;
            }
            if (n2 < n3) {
                this.putLongData(paramInfo.getBindType(), paramInfo.getValue());
                ++n2;
                continue;
            }
            this.putLongData((short)1, null);
        }
        return n;
    }

    private int sendLongCols(ParamInfoSet paramInfoSet) throws SQLException {
        int n;
        int n2 = 0;
        int n3 = paramInfoSet.getCount();
        ParamInfo paramInfo = null;
        while ((n = this.startParamData()) == -2) {
            paramInfo = paramInfoSet.getItem(n2);
            this.putLongData(paramInfo.getBindType(), paramInfo.getValue());
            ++n2;
        }
        return n;
    }

    private int startParamData() throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(24);
            this.d_req.writeInt(this.d_handle);
            this.d_session.request(this.d_req, this.d_res);
            boolean bl = this.d_res.getReturnCode() == -15;
            int n = this.d_res.readInt();
            if (!bl) {
                this.checkError(this.d_res);
            }
            if (bl) {
                n = -2;
            }
            return n;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    private void putLongData(short s, Object object) throws SQLException {
        try {
            if (object instanceof Reader) {
                int n;
                Reader reader = (Reader)object;
                YourByteArrayOutputStream yourByteArrayOutputStream = new YourByteArrayOutputStream(24576);
                int n2 = 8192;
                char[] cArray = new char[n2];
                byte[] byArray = new byte[24576];
                int n3 = 0;
                int n4 = 0;
                OutputStreamWriter outputStreamWriter = s == -8 ? new OutputStreamWriter((OutputStream)yourByteArrayOutputStream, "UTF-16LE") : new OutputStreamWriter((OutputStream)yourByteArrayOutputStream, this.getEncoding());
                while ((n = reader.read(cArray)) > 0) {
                    outputStreamWriter.write(cArray, 0, n);
                    outputStreamWriter.flush();
                    n3 = yourByteArrayOutputStream.getBytes(byArray);
                    this.putLongDataChunk(s, byArray, n3);
                    ++n4;
                    yourByteArrayOutputStream.reset();
                }
                if (n4 == 0) {
                    String string = "";
                    this.putLongDataChunk(s, string.getBytes(), 0);
                }
            } else if (object instanceof InputStream) {
                int n;
                InputStream inputStream = (InputStream)object;
                byte[] byArray = new byte[24576];
                int n5 = 0;
                while ((n = inputStream.read(byArray)) > 0) {
                    this.putLongDataChunk(s, byArray, n);
                    ++n5;
                }
                if (n5 == 0) {
                    byArray = new byte[]{};
                    this.putLongDataChunk(s, byArray, 0);
                }
            } else {
                this.putLongDataChunk(object);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    private void putLongDataChunk(short s, byte[] byArray, int n) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(32);
            this.d_req.writeInt(this.d_handle);
            VarData.writeBytesTo(this.d_req, s, byArray, n);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            this.checkError(this.d_res);
        }
        catch (SQLException sQLException) {
            this.cancelStmt();
            throw sQLException;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    private void putLongDataChunk(Object object) throws SQLException {
        this.d_errorsCleared = false;
        try {
            this.d_req.reinit();
            this.d_req.setFunction(32);
            this.d_req.writeInt(this.d_handle);
            VarData.writeTo(this.d_req, object);
            this.d_req.writeBoolean(false);
            this.d_session.request(this.d_req, this.d_res);
            this.checkError(this.d_res);
        }
        catch (SQLException sQLException) {
            this.cancelStmt();
            throw sQLException;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    @Override
    public SQLException getErrors(boolean bl) throws SQLException {
        return this.getErrors(0, this.d_handle, bl);
    }

    private boolean shouldUseUTF8() {
        return this.serverSupportsUTF8() && this.shouldUseAutoTranslate();
    }

    private boolean serverSupportsUTF8() {
        String string = this.getLNAConnection().getConnInfo().d_dbmsVersion;
        int n = Integer.parseInt(string = string.substring(0, string.indexOf(46)));
        return n >= 12;
    }

    private boolean shouldUseAutoTranslate() {
        boolean bl = this.getLNAConnection().getAutoTranslate();
        boolean bl2 = this.getLNAConnection().getServerEncoding().equalsIgnoreCase(this.getEncoding());
        return bl || bl2;
    }

    @Override
    public String getDBMSVersionString() {
        String string = "";
        if (null != this.getLNAConnection()) {
            string = this.getLNAConnection().getConnInfo().d_dbmsVersion;
        }
        return string;
    }
}

