/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.JDBCURL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SharedMemorySocket {
    private int m_fd;
    private boolean m_isClosed = true;
    private SharedMemoryInputStream m_in;
    private SharedMemoryOutputStream m_out;

    public SharedMemorySocket(int n) throws IOException {
        int[] nArray = new int[]{-1};
        int n2 = SharedMemorySocket.connect(n, nArray);
        this.m_fd = nArray[0];
        if (n2 != 0) {
            this.m_isClosed = true;
            throw new IOException("could not connect");
        }
        this.m_isClosed = false;
    }

    public void close() {
        if (!this.m_isClosed) {
            this.m_isClosed = true;
            SharedMemorySocket.close(this.m_fd);
        }
    }

    public void finalize() {
        this.close();
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_isClosed) {
            throw new IOException("socket closed");
        }
        if (this.m_in == null) {
            this.m_in = new SharedMemoryInputStream();
        }
        return this.m_in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.m_isClosed) {
            throw new IOException("socket closed");
        }
        if (this.m_out == null) {
            this.m_out = new SharedMemoryOutputStream();
        }
        return this.m_out;
    }

    private static native int connect(int var0, int[] var1);

    static native int write(int var0, byte[] var1);

    static native int write(int var0, byte[] var1, int var2, int var3);

    static native int read(int var0, byte[] var1, int var2, int var3);

    static native int close(int var0);

    static {
        try {
            JDBCURL.loadJNI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class SharedMemoryOutputStream
    extends OutputStream {
        private SharedMemoryOutputStream() {
        }

        @Override
        public void close() throws IOException {
            SharedMemorySocket.this.close();
        }

        @Override
        public void write(int n) throws IOException {
            if (SharedMemorySocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            byte[] byArray = new byte[]{(byte)n};
            int n2 = SharedMemorySocket.write(SharedMemorySocket.this.m_fd, byArray);
            if (n2 != 0) {
                throw new IOException("socket write error");
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            if (SharedMemorySocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            int n = SharedMemorySocket.write(SharedMemorySocket.this.m_fd, byArray);
            if (n != 0) {
                throw new IOException("socket write error");
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (SharedMemorySocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            int n3 = 0;
            n3 = n == 0 && n2 >= byArray.length ? SharedMemorySocket.write(SharedMemorySocket.this.m_fd, byArray) : SharedMemorySocket.write(SharedMemorySocket.this.m_fd, byArray, n, n2 > byArray.length ? byArray.length : n2);
            if (n3 != 0) {
                throw new IOException("socket write error");
            }
        }
    }

    private class SharedMemoryInputStream
    extends InputStream {
        private SharedMemoryInputStream() {
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            SharedMemorySocket.this.close();
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            if (SharedMemorySocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            return n == 0 ? -1 : byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (SharedMemorySocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            if ((n3 = SharedMemorySocket.read(SharedMemorySocket.this.m_fd, byArray, n, n2)) != 0) {
                throw new IOException("socket read error");
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (SharedMemorySocket.this.m_isClosed) {
                throw new IOException("socket closed");
            }
            int n = SharedMemorySocket.read(SharedMemorySocket.this.m_fd, byArray, 0, byArray.length);
            if (n != 0) {
                throw new IOException("socket read error");
            }
            return byArray.length;
        }
    }
}

