/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.DataTypeUtils;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ColumnInfo;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.LNAConnection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    private LNAConnection d_conn;
    private ColumnInfoSet d_cis;

    ResultSetMetaData(LNAConnection lNAConnection, ColumnInfoSet columnInfoSet) {
        this.d_conn = lNAConnection;
        this.d_cis = columnInfoSet;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.d_cis.getCount();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 0x100) != 0 && (columnInfo.getAttributes() & 0x200) == 0;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 4) != 0;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 8) != 0;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 0x80) != 0;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getNullable();
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 0x40) != 0;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getDisplaySize();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getColumnLabel();
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getColumnName();
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getScale();
    }

    @Override
    public String getTableName(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getTableName();
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return columnInfo.getQualifierName();
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return DataTypeUtils.getSQLTypeForDataType(columnInfo.getDataType());
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return this.getColumnInfo(n).getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 0x1000) != 0 && (columnInfo.getAttributes() & 0x400) == 0;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 0x400) != 0;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return (columnInfo.getAttributes() & 0x1000) != 0 && (columnInfo.getAttributes() & 0x400) != 0;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        return DataTypeUtils.getClassNameForDataType(columnInfo.getDataType());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    private ColumnInfo getColumnInfo(int n) throws SQLException {
        if (n <= 0 || n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        return this.d_cis.getItem(n - 1);
    }
}

