/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.util.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class LogWriter {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    private static final String ERROR_TEXT = "error";
    private static final String INFO_TEXT = "info";
    private static final String DEBUG_TEXT = "debug";
    private PrintWriter pw;
    private String owner;
    private int logLevel;

    public LogWriter(String string, int n, PrintWriter printWriter) {
        this.pw = printWriter;
        this.owner = string;
        this.logLevel = n;
    }

    public LogWriter(String string, int n) {
        this(string, n, null);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    public void log(String string, int n) {
        if (this.pw != null && n <= this.logLevel) {
            this.pw.println("[" + new Date() + "]  " + this.getSeverityString(n) + ": " + this.owner + ": " + string);
        }
    }

    public void log(Throwable throwable, String string, int n) {
        this.log(string + " : " + this.toTrace(throwable), n);
    }

    private String getSeverityString(int n) {
        switch (n) {
            case 1: {
                return ERROR_TEXT;
            }
            case 2: {
                return INFO_TEXT;
            }
            case 3: {
                return DEBUG_TEXT;
            }
        }
        return "Unknown";
    }

    private String toTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }
}

