/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.io.NullWriter;
import com.pervasive.io.ParentWriter;
import com.pervasive.jdbc.common.CharacterEncoding;
import com.pervasive.jdbc.common.Encoding;
import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.common.LocalStrings;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class PervasiveDataSource
implements Serializable,
Referenceable,
CharacterEncoding {
    protected String d_databaseName;
    protected String d_dataSourceName;
    protected String d_description;
    protected String d_networkProtocol = "tcp";
    protected String d_password;
    protected String d_portNumber = "1583";
    protected String d_serverName;
    protected String d_user;
    protected Encoding d_encoding = new Encoding();
    protected int m_seconds;
    protected NullWriter m_nullWriter = new NullWriter();
    protected ParentWriter m_writer = new ParentWriter((Writer)this.m_nullWriter);

    public String getDatabaseName() {
        return this.d_databaseName;
    }

    public void setDatabaseName(String string) {
        this.d_databaseName = string;
    }

    public String getDataSourceName() {
        return this.d_dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.d_dataSourceName = string;
    }

    public String getDescription() {
        return this.d_description;
    }

    public void setDescription(String string) {
        this.d_description = string;
    }

    public String getNetworkProtocol() {
        return this.d_networkProtocol;
    }

    public void setNetworkProtocol(String string) {
        this.d_networkProtocol = string;
    }

    public String getServerName() {
        return this.d_serverName;
    }

    public void setServerName(String string) {
        this.d_serverName = string;
    }

    public void setPassword(String string) {
        this.d_password = string;
    }

    protected String getPassword() {
        return this.d_password;
    }

    public String getUser() {
        return this.d_user;
    }

    public void setUser(String string) {
        this.d_user = string;
    }

    public void setPortNumber(String string) {
        this.d_portNumber = string;
    }

    public String getPortNumber() {
        return this.d_portNumber;
    }

    protected Properties getProperties(String string, String string2) {
        Properties properties = new Properties();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        properties.put("user", string);
        properties.put("password", string2);
        properties.put("encoding", this.getEncoding());
        return properties;
    }

    protected JDBCURL getURL() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:pervasive://");
        stringBuffer.append(this.d_serverName);
        stringBuffer.append(":");
        stringBuffer.append(this.d_portNumber);
        stringBuffer.append("/");
        stringBuffer.append(this.d_databaseName);
        String string = this.getEncoding();
        if (string.length() > 0) {
            stringBuffer.append(";encoding=");
            stringBuffer.append(string);
        }
        String string2 = stringBuffer.toString();
        try {
            JDBCURL jDBCURL = new JDBCURL(string2);
            return jDBCURL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.toString());
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.pervasive.jdbc.JDBC_VERSION.DataSourceFactory", null);
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("portNumber", this.getPortNumber()));
        reference.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("encoding", this.getEncoding()));
        return reference;
    }

    public void setLoginTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_LOGIN_TIMEOUT);
        }
        this.m_seconds = n;
        this.m_writer.write("login timeout set to: " + this.m_seconds);
    }

    public int getLoginTimeout() throws SQLException {
        if (this.m_seconds < 0) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_LOGIN_TIMEOUT);
        }
        return this.m_seconds;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        if (printWriter == null) {
            this.m_writer.setInternalWriter((Writer)this.m_nullWriter);
        } else {
            this.m_writer.setInternalWriter((Writer)printWriter);
            this.m_writer.println("Internal writer set.");
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_writer;
    }

    public String getEncoding() {
        return this.d_encoding.toString();
    }

    public Encoding getEncodingObject() {
        return this.d_encoding;
    }

    public void setEncoding(String string) {
        this.d_encoding.setEncoding(string);
    }
}

