/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.model;

import java.util.Enumeration;
import java.util.Vector;
import pervasive.database.ColumnDef;
import pervasive.database.Database;
import pervasive.database.PsqlEOFException;
import pervasive.database.PsqlException;
import pervasive.database.Row;
import pervasive.database.RowSet;
import pervasive.database.RowSetMetaData;
import pervasive.database.Table;
import pvideoj.model.DBListModelEvent;
import pvideoj.model.DBListModelListener;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.DBObject;
import pvideoj.model.DBObjectListErrorEvent;
import pvideoj.model.DBObjectListErrorListener;
import pvideoj.model.Restriction;

public abstract class DBObjectList {
    private Database _db;
    protected RowSet _rowset;
    protected RowSetMetaData _rowsetMD;
    private Table _table;
    private Restriction _restriction;
    private DBObject _selectedObject;
    private Row _selectedRow;
    private int _selectedIndex = -1;
    private int _currentIndex = -1;
    private Row _currentRow = null;
    private int _rowCount = -1;
    private Vector _selectionListeners = new Vector();
    private Vector _listModelListeners = new Vector();
    private static DBObjectListErrorListener _errorListener;

    protected abstract DBObject createObjectFromRow(Row var1);

    public DBObjectList(Database database, String string) throws PsqlException {
        this._db = database;
        this._table = database.getTable(string);
        this._rowset = this._table.createRowSet();
        this._rowsetMD = this._rowset.getRowSetMetaData();
        this._rowCount = this.getRowCount();
    }

    public RowSet getRowSet() {
        return this._rowset;
    }

    public Table getTable() {
        return this._table;
    }

    public RowSetMetaData getRowSetMetaData() {
        return this._rowsetMD;
    }

    public String[] getColumnNames() {
        return this._table.getTableMetaData().getColumnNames();
    }

    public ColumnDef getColumnDef(String string) {
        return this._table.getTableMetaData().getColumnDef(string);
    }

    public int getColumnWidth(String string) {
        return this.getColumnDef(string).getDefLength();
    }

    public int getRowCount() {
        int n = -1;
        try {
            n = this._rowsetMD.getRowCount();
        }
        catch (Exception exception) {
            DBObjectList.fireDBObjectListError(this, exception);
        }
        return n;
    }

    public Row createRow() {
        return this._rowset.createRow();
    }

    public void setRestriction(Restriction restriction) {
        this._rowsetMD.setDirection(1);
        this.reset();
        this._rowCount = -1;
        this._restriction = restriction;
        this._rowsetMD.addFirstTerm(this._rowsetMD.getColumnDef(restriction.columnNumber), restriction.operator, restriction.value);
        this.fireDBListModelChanged(new DBListModelEvent(this));
    }

    public Restriction getRestriction() {
        return this._restriction;
    }

    public static synchronized void setDBObjectListErrorListener(DBObjectListErrorListener dBObjectListErrorListener) {
        if (_errorListener == null) {
            _errorListener = dBObjectListErrorListener;
        }
    }

    public static synchronized void fireDBObjectListError(DBObjectList dBObjectList, Exception exception) {
        if (_errorListener != null) {
            _errorListener.internalErrorOccurred(new DBObjectListErrorEvent(dBObjectList, exception));
        }
    }

    public void addDBListSelectionListener(DBListSelectionListener dBListSelectionListener) {
        this._selectionListeners.addElement(dBListSelectionListener);
    }

    public void removeDBListSelectionListener(DBListSelectionListener dBListSelectionListener) {
        this._selectionListeners.removeElement(dBListSelectionListener);
    }

    public void fireDBListSelectionChanged() {
        DBListSelectionEvent dBListSelectionEvent = new DBListSelectionEvent(this, this._selectedObject, this._selectedRow, this._selectedIndex);
        Enumeration enumeration = this._selectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((DBListSelectionListener)enumeration.nextElement()).valueChanged(dBListSelectionEvent);
        }
    }

    public DBObject getSelectedObject() {
        return this._selectedObject;
    }

    public Row getSelectedRow() {
        return this._selectedRow;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectionIndex(int n) {
        this._selectedIndex = n;
        this.setSelection(this._selectedIndex >= 0 ? this.getRowFromIndex(this._selectedIndex) : null);
    }

    private void setSelection(Row row) {
        this._selectedRow = row;
        this.setSelection(this._selectedRow != null ? this.createObjectFromRow(this._selectedRow) : null);
    }

    private void setSelection(DBObject dBObject) {
        this._selectedObject = dBObject;
        this.fireDBListSelectionChanged();
    }

    public void clearSelection() {
        int n = this._selectedIndex;
        this.setSelectionIndex(-1);
        if (n == -1) {
            this.fireDBListSelectionChanged();
        }
    }

    public boolean isSelectedLast() {
        boolean bl = false;
        if (this._selectedIndex == this._rowCount - 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isSelectedFirst() {
        boolean bl = false;
        if (this._selectedIndex == 0) {
            bl = true;
        }
        return bl;
    }

    public int getCurrentIndex() {
        return this._currentIndex;
    }

    private DBObject getCurrentObject() {
        if (this._currentRow == null) {
            return null;
        }
        return this.createObjectFromRow(this._currentRow);
    }

    private Row getCurrentRow() {
        return this._currentRow;
    }

    protected DBObject findElement(DBObject dBObject) throws PsqlException {
        DBObject dBObject2 = this.getCurrentObject();
        if (dBObject2 == null && (dBObject2 = this.getFirst()) == null) {
            return null;
        }
        int n = dBObject2.compareTo(dBObject);
        if (n == 0) {
            return dBObject2;
        }
        boolean bl = true;
        if (n > 0) {
            bl = false;
        }
        while ((dBObject2 = bl ? this.getNext() : this.getPrevious()) != null && (n = dBObject2.compareTo(dBObject)) != 0) {
            if ((!bl || n <= 0) && (bl || n >= 0)) continue;
            dBObject2 = null;
            break;
        }
        return dBObject2;
    }

    public DBObject getFirst() throws PsqlException {
        this._rowsetMD.setDirection(1);
        this.reset();
        DBObject dBObject = null;
        Row row = this._getNext();
        if (row != null) {
            dBObject = this.createObjectFromRow(row);
        }
        return dBObject;
    }

    public DBObject getLast() throws PsqlException {
        this._rowsetMD.setDirection(-1);
        this.reset();
        DBObject dBObject = null;
        Row row = this._getNext();
        if (row != null) {
            dBObject = this.createObjectFromRow(row);
        }
        return dBObject;
    }

    public DBObject getNext() throws PsqlException {
        this._rowsetMD.setDirection(1);
        DBObject dBObject = null;
        Row row = this._getNext();
        if (row != null) {
            dBObject = this.createObjectFromRow(row);
        }
        return dBObject;
    }

    public DBObject getPrevious() throws PsqlException {
        this._rowsetMD.setDirection(-1);
        DBObject dBObject = null;
        Row row = this._getNext();
        if (row != null) {
            dBObject = this.createObjectFromRow(row);
        }
        return dBObject;
    }

    Row getRowFromIndex(int n) {
        if (this._currentIndex == n) {
            return this._currentRow;
        }
        int n2 = n - this._currentIndex;
        if (n2 >= 0) {
            this._rowsetMD.setDirection(1);
        } else {
            this._rowsetMD.setDirection(-1);
        }
        int n3 = Math.abs(n2);
        Row row = null;
        try {
            for (int i = 0; i < n3; ++i) {
                row = this._getNext();
            }
        }
        catch (PsqlException psqlException) {
            DBObjectList.fireDBObjectListError(this, (Exception)((Object)psqlException));
            row = null;
            System.err.println("getRow: " + (Object)((Object)psqlException));
        }
        return row;
    }

    public void addDBListModelListener(DBListModelListener dBListModelListener) {
        this._listModelListeners.addElement(dBListModelListener);
    }

    public void removeDBListModelListener(DBListModelListener dBListModelListener) {
        this._listModelListeners.removeElement(dBListModelListener);
    }

    public void fireDBListModelChanged(DBListModelEvent dBListModelEvent) {
        Enumeration enumeration = this._listModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((DBListModelListener)enumeration.nextElement()).listChanged(dBListModelEvent);
        }
    }

    public void save(DBObject dBObject) throws PsqlException {
        if (dBObject.isNew()) {
            DBObject dBObject2 = this.getCurrentObject();
            this._rowset.insertRow(dBObject.objAsRow(), true);
            if (dBObject2 != null && dBObject.compareTo(dBObject2) < 0) {
                ++this._currentIndex;
            }
            if (this._selectedObject != null && dBObject.compareTo(this._selectedObject) < 0) {
                ++this._selectedIndex;
            }
            dBObject.setNew(false);
            ++this._rowCount;
            this.fireDBListModelChanged(new DBListModelEvent(this, this._rowCount - 1, 0));
        } else {
            DBObject dBObject3 = null;
            if (this._selectedRow != null) {
                dBObject3 = this.createObjectFromRow(this._selectedRow);
            }
            Row row = dBObject.objAsRow();
            if (dBObject.compareTo(dBObject3) == 0) {
                if (this._selectedIndex != -1) {
                    this._selectedObject = dBObject;
                    this._selectedRow = row;
                    this._rowset.updateRow(row, false);
                    this._currentRow = row;
                    this._currentIndex = this._selectedIndex;
                } else {
                    this._rowset.updateRow(row, true);
                }
                this.fireDBListModelChanged(new DBListModelEvent(this, this._selectedIndex, 2));
            } else {
                this._rowset.updateRow(row, false);
                this.reset();
                this.clearSelection();
                this.fireDBListModelChanged(new DBListModelEvent(this));
            }
        }
    }

    public void delete(DBObject dBObject) throws PsqlException {
        if (dBObject.isNew()) {
            return;
        }
        this._rowset.deleteRow(dBObject.objAsRow());
        --this._rowCount;
        if (this._rowCount == 0) {
            this._currentIndex = -1;
            this._currentRow = null;
        } else if (this._selectedIndex < this._rowCount) {
            this._currentIndex = this._selectedIndex - 1;
            this.getNext();
        } else {
            this.getPrevious();
        }
        this.fireDBListModelChanged(new DBListModelEvent(this, this._selectedIndex, 1));
        this.clearSelection();
    }

    public void deleteAll() throws PsqlException {
        this._rowset.reset();
        Row row = null;
        while ((row = this._getNext()) != null) {
            this._rowset.deleteRow(row);
        }
        this._rowCount = 0;
        this.clearSelection();
        this.fireDBListModelChanged(new DBListModelEvent(this));
    }

    private Row _getNext() throws PsqlException {
        Row row = null;
        try {
            row = this._rowset.getNext();
            this._currentIndex = this._rowsetMD.getDirection() == 1 ? ++this._currentIndex : --this._currentIndex;
            this._currentRow = row;
        }
        catch (PsqlEOFException psqlEOFException) {
            // empty catch block
        }
        return row;
    }

    protected void reset() {
        this._rowset.reset();
        this._currentIndex = this._rowsetMD.getDirection() == 1 ? -1 : this._rowCount;
        this._currentRow = null;
    }
}

