/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.io.EndianDataInputStream;
import com.pervasive.jdbc.common.LocalStrings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class LNAPacket {
    private EndianDataInputStream d_dataIn;
    private int d_function;
    private short d_requestNumber;
    private short d_returnCode;
    private int d_payloadSize;
    private long d_readTime;

    public void readFrom(InputStream inputStream) throws IOException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        do {
            try {
                object = new byte[30];
                new DataInputStream(inputStream).readFully((byte[])object);
                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            }
            catch (InterruptedIOException interruptedIOException) {
                // empty catch block
            }
        } while (byteArrayInputStream == null);
        object = new EndianDataInputStream(byteArrayInputStream);
        int n = ((EndianDataInputStream)object).readInt();
        int n2 = ((EndianDataInputStream)object).readInt();
        short s = ((EndianDataInputStream)object).readShort();
        ((EndianDataInputStream)object).readShort();
        int n3 = ((EndianDataInputStream)object).readInt();
        int n4 = ((EndianDataInputStream)object).readInt();
        this.d_function = ((EndianDataInputStream)object).readInt();
        this.d_requestNumber = ((EndianDataInputStream)object).readShort();
        this.d_returnCode = ((EndianDataInputStream)object).readShort();
        ((EndianDataInputStream)object).readShort();
        if (n != 666000666 || n2 != 16 + n3 || n4 != n3 || n4 < 14) {
            throw new IOException(LocalStrings.ERR_LNA_BAD_RESPONSE);
        }
        this.d_payloadSize = n4 -= 14;
        this.d_readTime = System.currentTimeMillis();
    }

    public InputStream getInputStream() {
        return this.d_dataIn;
    }

    public int getFunction() {
        return this.d_function;
    }

    public short getRequestNumber() {
        return this.d_requestNumber;
    }

    public short getReturnCode() {
        return this.d_returnCode;
    }

    public long getReadTime() {
        return this.d_readTime;
    }

    public int getPayloadSize() {
        return this.d_payloadSize;
    }
}

