/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.ColumnInfo;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.FetchReader;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.LNAStatement;
import com.pervasive.jdbc.lna.LongDataInputStream;
import com.pervasive.jdbc.lna.ResultCache;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class SingleFetchResultCache
implements ResultCache,
FetchReader {
    private LNAStatement d_lnaStmt;
    private ColumnInfoSet d_cis;
    private boolean d_isClosed;
    private Object[] d_fetchBuf;
    private int d_curRow;
    private boolean d_eof;
    private InputStream d_curStream;

    public SingleFetchResultCache(LNAStatement lNAStatement, ColumnInfoSet columnInfoSet) {
        this.d_lnaStmt = lNAStatement;
        this.d_cis = columnInfoSet;
        this.d_isClosed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void open() throws SQLException {
        if (this.d_isClosed) {
            this.d_isClosed = false;
            this.d_curRow = Integer.MIN_VALUE;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.d_isClosed) {
            this.d_isClosed = true;
            this.closeStream();
            this.freeBuffers();
            this.d_curRow = 0;
            this.d_lnaStmt.freeStmt((short)0);
        }
    }

    @Override
    public final boolean isClosed() {
        return this.d_isClosed;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
    }

    @Override
    public int getRow() throws SQLException {
        return this.d_curRow;
    }

    @Override
    public boolean isRow(int n) throws SQLException {
        return n == -1 ? false : n == this.d_curRow;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_INCORRECT_CURSOR_TYPE);
    }

    @Override
    public synchronized boolean relative(int n, boolean bl) throws SQLException {
        if (n != 1 && bl) {
            throw new IllegalArgumentException();
        }
        if (!this.d_eof) {
            this.doFetch();
            this.d_curRow = !this.d_eof ? (this.d_curRow == Integer.MIN_VALUE ? 1 : ++this.d_curRow) : Integer.MAX_VALUE;
        }
        return !this.d_eof;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public short getRowStatus() throws SQLException {
        return this.validRow() ? (short)0 : 3;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object;
        if (n < 1 || n > this.d_cis.getCount()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_COL_NUM, "S1002", 0);
        }
        if (this.validRow()) {
            ColumnInfo columnInfo;
            this.closeStream();
            object = this.d_fetchBuf[n - 1];
            if (object == null && (columnInfo = this.d_cis.getItem(n - 1)).hasLongData()) {
                this.d_curStream = new LongDataInputStream(this.d_lnaStmt, (short)n, columnInfo.getBindType());
                object = this.d_curStream;
            }
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException(LocalStrings.ERR_SQL_RESULTSET_NOT_UPDATABLE);
    }

    @Override
    public void readFrom(LNAResponse lNAResponse) throws IOException {
        int n = lNAResponse.readInt();
        lNAResponse.readInt();
        if (n > 0) {
            for (int i = 0; i < this.d_cis.getCount(); ++i) {
                this.d_fetchBuf[i] = this.d_cis.getItem(i).readValueFrom(lNAResponse);
            }
        }
    }

    @Override
    public void readFrom(LNAResponse lNAResponse, ColumnInfoSet columnInfoSet) throws IOException {
        throw new IOException(LocalStrings.ERR_NOT_IMPL);
    }

    private boolean validRow() {
        return this.d_curRow >= 1 && this.d_curRow < Integer.MAX_VALUE;
    }

    private void doFetch() throws SQLException {
        this.closeStream();
        this.checkBuffers();
        this.d_eof = this.d_lnaStmt.fetch(this.d_cis, this) == -16;
    }

    private void closeStream() {
        if (this.d_curStream != null) {
            try {
                this.d_curStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.d_curStream = null;
        }
    }

    private void checkBuffers() {
        if (this.d_fetchBuf == null) {
            this.d_fetchBuf = new Object[this.d_cis.getCount()];
        }
    }

    private void freeBuffers() {
        this.d_fetchBuf = null;
    }
}

