/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import pervasive.database.PsqlException;
import pvideoj.utils.InfoActionArea;
import pvideoj.utils.LayoutUtils;
import pvideoj.views.ContractsDialog;
import pvideoj.views.CustomersDialog;
import pvideoj.views.EmployeesDialog;
import pvideoj.views.PVideoDialog;
import pvideoj.views.TitlesDialog;

class MainMenu
extends JPanel {
    static final String[] _menuButtonLabels = new String[]{"Rental Contracts", "Video Titles", "Customer Information", "Employee Information", "Exit the Program"};
    static final String[] _menuButtonActions = new String[]{"contracts", "titles", "customer", "employee", "exit"};
    static final char[] _mnemonic = new char[]{'R', 'T', 'C', 'E', 'x'};
    static final String _heading1 = "Pervasive Video Rental Management (JCL)";
    static final String _heading2 = "Main Menu";
    private PVideoDialog _contractsDialog;
    private PVideoDialog _employeesDialog;
    private PVideoDialog _customersDialog;
    private PVideoDialog _titlesDialog;
    private Frame _parent;

    MainMenu(Frame frame) {
        JComponent jComponent;
        int n;
        this._parent = frame;
        this.setBorder(new EmptyBorder(15, 30, 0, 30));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Font font = new Font("Serif", 0, 20);
        JLabel jLabel = new JLabel(_heading1);
        jLabel.setFont(font);
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 0, 0);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel(_heading2);
        jLabel2.setFont(font);
        LayoutUtils.constrain(gridBagConstraints, this, jLabel2, 0, 1, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 20, 0);
        this.add(jLabel2);
        MainMenuListener mainMenuListener = new MainMenuListener();
        for (n = 0; n < _menuButtonLabels.length; ++n) {
            jComponent = new JButton(_menuButtonLabels[n]);
            ((AbstractButton)jComponent).setActionCommand(_menuButtonActions[n]);
            ((AbstractButton)jComponent).setMnemonic(_mnemonic[n]);
            ((AbstractButton)jComponent).addActionListener(mainMenuListener);
            LayoutUtils.constrain(gridBagConstraints, this, jComponent, 0, n + 2, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 5, 0);
            this.add(jComponent);
        }
        jComponent = new InfoActionArea(new String[0]);
        LayoutUtils.constrain(gridBagConstraints, this, jComponent, 0, n + 2, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(jComponent);
    }

    void buildDialogs() throws PsqlException {
        this._contractsDialog = new ContractsDialog(this._parent);
        this._titlesDialog = new TitlesDialog(this._parent);
        this._customersDialog = new CustomersDialog(this._parent);
        this._employeesDialog = new EmployeesDialog(this._parent);
    }

    class MainMenuListener
    implements ActionListener {
        MainMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = actionEvent.getActionCommand();
            for (n = 0; n < _menuButtonActions.length && !string.equals(_menuButtonActions[n]); ++n) {
            }
            switch (n) {
                case 0: {
                    MainMenu.this._contractsDialog.setVisible(true);
                    break;
                }
                case 1: {
                    MainMenu.this._titlesDialog.setVisible(true);
                    break;
                }
                case 2: {
                    MainMenu.this._customersDialog.setVisible(true);
                    break;
                }
                case 3: {
                    MainMenu.this._employeesDialog.setVisible(true);
                    break;
                }
                case 4: {
                    PVideo.exit(0, null);
                }
            }
        }
    }
}

