/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pvideoj.model.Customer;
import pvideoj.model.CustomerList;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.Filler;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.NumericOnlyDocument;

public class CardPanel
extends JPanel
implements ActionListener {
    private JTextField _cardTF;
    private JButton _findBtn;
    private CustomerList _customers;

    public CardPanel(String string, CustomerList customerList) {
        this._customers = customerList;
        this.setBorder(new TitledBorder(new EtchedBorder(), string));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Card No.");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 10);
        this.add(jLabel);
        this._cardTF = new JTextField(new NumericOnlyDocument(4), "", 3);
        LayoutUtils.constrain(gridBagConstraints, this, this._cardTF, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 10);
        this.add(this._cardTF);
        this._findBtn = new JButton("Find");
        LayoutUtils.constrain(gridBagConstraints, this, this._findBtn, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 5, 10);
        this.add(this._findBtn);
        this._findBtn.addActionListener(this);
        Filler filler = new Filler();
        LayoutUtils.constrain(gridBagConstraints, this, filler, 2, 0, 1, 2, 2, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.add(filler);
    }

    public boolean isValidInput() {
        if (this._cardTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._cardTF, "Missing card number.");
            return false;
        }
        return true;
    }

    public void setEditable(boolean bl) {
        this._cardTF.setEditable(bl);
        this._findBtn.setEnabled(bl);
    }

    public void setCardNumber(int n) {
        this._cardTF.setText(String.valueOf(n));
    }

    public int getCardNumber() {
        return Integer.parseInt(this._cardTF.getText());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._customers == null) {
            return;
        }
        if (!this.isValidInput()) {
            return;
        }
        int n = this.getCardNumber();
        try {
            Customer customer = this._customers.findCustomer(n);
            if (customer == null) {
                ErrorMessage.showMessage((AWTEvent)actionEvent, "Customer ID \"" + n + "\" not found.");
                return;
            }
            this._customers.setSelectionIndex(this._customers.getCurrentIndex());
        }
        catch (Exception exception) {
            ErrorMessage.showMessage((AWTEvent)actionEvent, exception);
        }
    }
}

