/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.common;

import java.io.FileOutputStream;
import java.io.PrintStream;

public class Debug {
    public static final int DEFAULT = 1;
    public static final int LNA_REQUEST = 2;
    public static final int LNA_RESPONSE = 4;
    public static final int LNA_SESSION = 8;
    public static final int DM_READ = 16;
    public static final int DM_WRITE = 32;
    public static final int SQL_CONNECTION = 64;
    public static final int SQL_EXEC = 128;
    public static final int SQL_FETCH = 256;
    public static final int ANY = -1;
    public static int DEBUG = 0;
    public static PrintStream out = null;
    public static FileOutputStream m_fos = null;
    private static int s_indent = 0;
    private static boolean s_newLine = true;

    public static final void setDebugStream(String string) {
        if (out != null) {
            return;
        }
        DEBUG = 6;
        if (string.equalsIgnoreCase("std")) {
            out = System.out;
        } else {
            try {
                m_fos = new FileOutputStream(string);
                out = new PrintStream(m_fos);
            }
            catch (Exception exception) {
                out = System.out;
                m_fos = null;
            }
        }
    }

    public static final boolean checkDebug(int n) {
        return (DEBUG & n) != 0;
    }

    public static final void enter() {
        ++s_indent;
    }

    public static final void exit() {
        --s_indent;
    }

    public static final void print(String string) {
        if (DEBUG == 0) {
            return;
        }
        if (s_newLine) {
            Debug.printIndent();
        }
        out.print(string);
    }

    public static final void println(String string) {
        if (DEBUG == 0) {
            return;
        }
        if (s_newLine) {
            Debug.printIndent();
        }
        out.println(string);
        s_newLine = true;
    }

    public static final void println() {
        if (DEBUG == 0) {
            return;
        }
        if (s_newLine) {
            Debug.printIndent();
        }
        out.println();
        s_newLine = true;
    }

    public static final void print(int n, String string) {
        if ((DEBUG & n) == 0) {
            return;
        }
        if (s_newLine) {
            Debug.printIndent();
        }
        out.print(string);
    }

    public static final void println(int n, String string) {
        if ((DEBUG & n) == 0) {
            return;
        }
        if (s_newLine) {
            Debug.printIndent();
        }
        out.println(string);
        s_newLine = true;
    }

    public static final void println(int n) {
        if ((DEBUG & n) == 0) {
            return;
        }
        if (s_newLine) {
            Debug.printIndent();
        }
        out.println();
        s_newLine = true;
    }

    private static final void printIndent() {
        for (int i = 0; i < s_indent; ++i) {
            out.print("  ");
        }
        s_newLine = false;
    }
}

