/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.lna.ColumnInfo;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public final class ColumnInfoSet {
    private Vector d_items;

    public ColumnInfoSet() {
    }

    public ColumnInfoSet(int n) {
        this.d_items = new Vector(n);
    }

    public int getCount() {
        return this.d_items != null ? this.d_items.size() : 0;
    }

    public ColumnInfo getItem(int n) {
        return (ColumnInfo)this.d_items.elementAt(n);
    }

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        int n = lNAResponse.readInt();
        if (n < 0) {
            n = 0;
        }
        this.d_items = new Vector(n);
        for (int i = 0; i < n; ++i) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.readFrom(lNAResponse);
            this.d_items.insertElementAt(columnInfo, this.d_items.size());
        }
        lNAResponse.readShort();
    }

    public void writeBindingTo(LNARequest lNARequest) throws IOException {
        int n = this.getCount();
        lNARequest.writeShort((short)n);
        lNARequest.writeInt(n);
        Enumeration enumeration = this.d_items.elements();
        while (enumeration.hasMoreElements()) {
            ((ColumnInfo)enumeration.nextElement()).writeBindingTo(lNARequest);
        }
    }

    public void addColumn(short s, int n, short s2, short s3, int n2, int n3, int n4, String string, String string2, String string3, String string4, String string5) {
        ColumnInfo columnInfo = new ColumnInfo(s, n, s2, s3, n2, n3, n4, string, string2, string3, string4, string5);
        this.d_items.insertElementAt(columnInfo, this.d_items.size());
    }

    public void addColumn(ColumnInfo columnInfo) {
        this.d_items.insertElementAt(columnInfo, this.d_items.size());
    }

    public void writeFixedColumns(LNARequest lNARequest, Object[] objectArray, short s, boolean[] blArray) throws IOException {
        int n;
        int n2 = this.getCount();
        if (n2 == 0) {
            lNARequest.writeInt(0);
            lNARequest.writeInt(-1);
        }
        ColumnInfo columnInfo = null;
        int n3 = lNARequest.getPosition();
        lNARequest.writeInt(0);
        lNARequest.writeInt(0);
        int n4 = lNARequest.getPosition();
        lNARequest.writeShort(s);
        for (n = 0; n < n2; ++n) {
            if (blArray != null && !blArray[n]) {
                lNARequest.writeInt(-6);
                continue;
            }
            columnInfo = this.getItem(n);
            columnInfo.writeValueTo(lNARequest, objectArray[n]);
        }
        n = lNARequest.getPosition();
        int n5 = n - n4;
        lNARequest.seek(n3);
        lNARequest.writeInt(n5);
        lNARequest.writeInt(n5);
        lNARequest.seekToEnd();
    }
}

