##############################################################################
##
## Zen_PowerShell_Script_strings.psd1
##
## by Actian Corporation (http://www.actian.com/zen)
##
## Localized strings for Actian Zen PowerShell scripts.
##
##############################################################################
@{
    ## Information message strings.    
    infoRunning="Running {0} {1}..."
    infoLooking="...looking for installed {0} product."
    infoZenInfo="...found version {0} installed."
    infoVisualStudioInfo="...found Visual Studio version '{0}' at '{1}'."
    infoInstallingVsixPkg="...please wait, importing VS Extension package for PSQL ADO.NET Provider Data Tools."
    infoInstalledVsixPkgLatestWithLog="   ...import complete, see the log file %temp%\{0} for details."
    infoInstalledVsixPkgLatestNoLog="   ...import complete."
    infoRemovingVsixPkg="...please wait, removing VS Extension package for PSQL ADO.NET Provider Data Tools."
    infoRemovedVsixPkgLatestWithLog="   ...removal complete, see {0} in %temp% folder for details."
    infoRemovedVsixPkgLatestNoLog="   ...removal complete."
    infoAddedModelFirstIncludeTemplates="...successfully imported the Entity Framework Model First include templates."
    infoAddedModelFirstT4Templates="...successfully imported the Entity Framework Model First T4 templates."
    infoRemovedModelFirstIncludeTemplates="...successfully removed the Entity Framework Model First include templates."
    infoRemovedModelFirstT4Templates="...successfully removed the Entity Framework Model First T4 templates."
    infoEnd="Finished running {0} {1}!"
    
    ## Warning message strings.
    warnNoTemplates="WARNING: The script was unable to copy the Model First templates to the Entity Framework Tools folder ({0})."
    
    ## Error message strings.
    errMustBeAdmin="ERROR: The current Windows PowerShell session is not running as Administrator. Start Windows PowerShell by  using the Run as Administrator option, and then try running the script again."
    errNoZenFound="ERROR: Unable to locate Zen installed on the target system. Please install Zen and then restart the PSQL ADO.NET Provider Data Tools installation."
    errWrongZenVer="ERROR: The PSQL ADO.NET Provider Data Tools installation requires Zen v{0}.x or later.  Please install Zen v{0}.x or later and then restart the PSQL ADO.NET Provider Data Tools installation."
    errNoVSFound="ERROR: Unable to locate the install folder for Visual Studio.  Please verify Visual Studio {0} or later is installed and restart this script."
    errNoVSIXInstaller="ERROR: Unable to locate the Visual Studio VSIXInstaller utility. The PSQL ADO.NET Provider Data Tools VSIX package cannot be imported into Visual Studio."
    errVsixInstallWithLog="ERROR: Unable to import the PSQL ADO.NET Provider Data Tools VSIX package into Visual Studio. Check the contents of log file located in the TEMP folder{0}."
    errVsixInstallNoLog="ERROR: Unable to import the PSQL ADO.NET Provider Data Tools VSIX package into Visual Studio."
    errVsixUninstallWithLog="ERROR: Unable to remove the PSQL ADO.NET Provider Data Tools VSIX package from Visual Studio. Check the contents of log file located in the TEMP folder{0}."
    errVsixUninstallNoLog="ERROR: Unable to remove the PSQL ADO.NET Provider Data Tools VSIX package from Visual Studio."
    errUnknown="ERROR: The script encountered an unknown error and will now exit."
}
# SIG # Begin signature block
# MIIcMwYJKoZIhvcNAQcCoIIcJDCCHCACAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU4s5wxrvL4hLCWqA53uj/BFvF
# JkSgghcYMIID7jCCA1egAwIBAgIQfpPr+3zGTlnqS5p31Ab8OzANBgkqhkiG9w0B
# AQUFADCBizELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTEUMBIG
# A1UEBxMLRHVyYmFudmlsbGUxDzANBgNVBAoTBlRoYXd0ZTEdMBsGA1UECxMUVGhh
# d3RlIENlcnRpZmljYXRpb24xHzAdBgNVBAMTFlRoYXd0ZSBUaW1lc3RhbXBpbmcg
# Q0EwHhcNMTIxMjIxMDAwMDAwWhcNMjAxMjMwMjM1OTU5WjBeMQswCQYDVQQGEwJV
# UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFu
# dGVjIFRpbWUgU3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMjCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBALGss0lUS5ccEgrYJXmRIlcqb9y4JsRDc2vCvy5Q
# WvsUwnaOQwElQ7Sh4kX06Ld7w3TMIte0lAAC903tv7S3RCRrzV9FO9FEzkMScxeC
# i2m0K8uZHqxyGyZNcR+xMd37UWECU6aq9UksBXhFpS+JzueZ5/6M4lc/PcaS3Er4
# ezPkeQr78HWIQZz/xQNRmarXbJ+TaYdlKYOFwmAUxMjJOxTawIHwHw103pIiq8r3
# +3R8J+b3Sht/p8OeLa6K6qbmqicWfWH3mHERvOJQoUvlXfrlDqcsn6plINPYlujI
# fKVOSET/GeJEB5IL12iEgF1qeGRFzWBGflTBE3zFefHJwXECAwEAAaOB+jCB9zAd
# BgNVHQ4EFgQUX5r1blzMzHSa1N197z/b7EyALt0wMgYIKwYBBQUHAQEEJjAkMCIG
# CCsGAQUFBzABhhZodHRwOi8vb2NzcC50aGF3dGUuY29tMBIGA1UdEwEB/wQIMAYB
# Af8CAQAwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC50aGF3dGUuY29tL1Ro
# YXd0ZVRpbWVzdGFtcGluZ0NBLmNybDATBgNVHSUEDDAKBggrBgEFBQcDCDAOBgNV
# HQ8BAf8EBAMCAQYwKAYDVR0RBCEwH6QdMBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0y
# MDQ4LTEwDQYJKoZIhvcNAQEFBQADgYEAAwmbj3nvf1kwqu9otfrjCR27T4IGXTdf
# plKfFo3qHJIJRG71betYfDDo+WmNI3MLEm9Hqa45EfgqsZuwGsOO61mWAK3ODE2y
# 0DGmCFwqevzieh1XTKhlGOl5QGIllm7HxzdqgyEIjkHq3dlXPx13SYcqFgZepjhq
# IhKjURmDfrYwggR9MIIDZaADAgECAgMb5xUwDQYJKoZIhvcNAQELBQAwYzELMAkG
# A1UEBhMCVVMxITAfBgNVBAoTGFRoZSBHbyBEYWRkeSBHcm91cCwgSW5jLjExMC8G
# A1UECxMoR28gRGFkZHkgQ2xhc3MgMiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAe
# Fw0xNDAxMDEwNzAwMDBaFw0zMTA1MzAwNzAwMDBaMIGDMQswCQYDVQQGEwJVUzEQ
# MA4GA1UECBMHQXJpem9uYTETMBEGA1UEBxMKU2NvdHRzZGFsZTEaMBgGA1UEChMR
# R29EYWRkeS5jb20sIEluYy4xMTAvBgNVBAMTKEdvIERhZGR5IFJvb3QgQ2VydGlm
# aWNhdGUgQXV0aG9yaXR5IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
# AoIBAQC/cWII8fpZNPcbyRij94BJWOkigxOmxSBDATuE8eaFSZ8n6vaEG06gtNtw
# mMcyAbEFPgdO7vT6Ty9ZMCLnqxlWa+KAB/zzFnWAOVF75fk1tnROqY2CE+S2P6kD
# g/qivooVan/eC8O2GRQFyurDqASUO0Z8Mg3zAGYiyI1pbTaMERi307IcYLQ4+gKM
# ztPdRgfeCj7rXXzIfPuwK1OkkmJpUSUFYRpEgYwsqUOWI9+sOoGaDinFHKnpXR62
# np4wCjnO8YiA+0tdzDLshWJDJTQCVicBkbQ7cCo/brHonIgBfZ/U+dtTbWCdvyzn
# WKu4X0b8zsQbAzwJ60kxXGlGs+BHAgMBAAGjggEXMIIBEzAPBgNVHRMBAf8EBTAD
# AQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUOpqFBxBnKLbv9r0FQW4gwZTa
# D94wHwYDVR0jBBgwFoAU0sSw0pHUTBFxs2HLPaH+3ahq1OMwNAYIKwYBBQUHAQEE
# KDAmMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5nb2RhZGR5LmNvbS8wMgYDVR0f
# BCswKTAnoCWgI4YhaHR0cDovL2NybC5nb2RhZGR5LmNvbS9nZHJvb3QuY3JsMEYG
# A1UdIAQ/MD0wOwYEVR0gADAzMDEGCCsGAQUFBwIBFiVodHRwczovL2NlcnRzLmdv
# ZGFkZHkuY29tL3JlcG9zaXRvcnkvMA0GCSqGSIb3DQEBCwUAA4IBAQBZC1O9koYR
# pyR77Vsxzx0fbHDFuG6+Trv2vpdQ4TB/uihcYpTC434z9/tCdoXblRyMIlh1CQyI
# ZWc5ChYJxaA4l6TFI5M/tBimAQZEkeOnaSe0WiV/Orcyzd2E/yo4KTOk3Weyhf6h
# iCAcUInI3Cr2QgM3TOaI39WvJPKxw9/MtezgmV63SVQgPJQYDMccUhhJpG3hs1gL
# ydjs2a4cMo4ocA3i/qYXnoQPvVdws1rpH6CGU7vvfP9pC+BIw7eTC8gKVMSsXRRn
# N2zKpS8xCDeqbm+MvJviV10kga+Xl5yErWysN0xm82GRESDkvjCfeqQpCbDhNF9k
# dxhAUd+MMKavMIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsaUDANBgkqhkiG
# 9w0BAQUFADBeMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
# YXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2VydmljZXMg
# Q0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0yMDEyMjkyMzU5NTlaMGIxCzAJBgNV
# BAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UEAxMr
# U3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNlcyBTaWduZXIgLSBHNDCCASIw
# DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
# sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyGduXgQ0sile7CK0PBn9ho
# tI5AT+6FOLkRxSPyZFjwFTJvTlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X
# 7pbbYTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZvSWA4ejSIqXQugJ6
# oXeTW2XD7hd0vEGGKtwITIySjJEtnndEH2jWqHR32w5bMotWizO92WPISZ06xcXq
# MwvS8aMb9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjhEChyqs0CAwEA
# AaOCAVcwggFTMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgw
# DgYDVR0PAQH/BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcwAYYeaHR0
# cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29tMDcGCCsGAQUFBzAChitodHRwOi8v
# dHMtYWlhLndzLnN5bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1MDMw
# MaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50ZWMuY29tL3Rzcy1jYS1nMi5j
# cmwwKAYDVR0RBCEwH6QdMBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
# VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1UdIwQYMBaAFF+a9W5czMx0
# mtTdfe8/2+xMgC7dMA0GCSqGSIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4Qn
# B28Yst4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/QsJmMz5ElkbQ3mw2cO
# 9wWkNWx8iRbG6bLfsundIMZxD82VdNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A
# 0RH83Vx2bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwWK/F/Wwk9m1vi
# FsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwvSRvbIrvD/niUUcOGsYKIXfA9tFGheTMr
# Lnu53CAJE3Hrahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lgw7wc2AR1
# MIIE0DCCA7igAwIBAgIBBzANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCVVMx
# EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoT
# EUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRp
# ZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTExMDUwMzA3MDAwMFoXDTMxMDUwMzA3
# MDAwMFowgbQxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQH
# EwpTY290dHNkYWxlMRowGAYDVQQKExFHb0RhZGR5LmNvbSwgSW5jLjEtMCsGA1UE
# CxMkaHR0cDovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkvMTMwMQYDVQQD
# EypHbyBEYWRkeSBTZWN1cmUgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IC0gRzIwggEi
# MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC54MsQ1K92vdSTYuswZLiBCGzD
# BNliF44v/z5lz4/OYuY8UhzaFkVLVat4a2ODYpDOD2lsmcgaFItMzEUz6ojcnqOv
# K/6AYZ15V8TPLvQ/MDxdR/yaFrzDN5ZBUY4RS1T4KL7QjL7wMDge87Am+GZHY23e
# cSZHjzhHU9FGHbTj3ADqRay9vHHZqm8A29vNMDp5T19MR/gd71vCxJ1gO7GyQ5HY
# pDNO6rPWJ0+tJYqlxvTV0KaudAVkV4i1RFXULSo6Pvi4vekyCgKUZMQWOlDxSq7n
# eTOvDCAHf+jfBDnCaQJsY1L6d8EbyHSHyLmTGFBUNUtpTrw700kuH9zB0lL7AgMB
# AAGjggEaMIIBFjAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNV
# HQ4EFgQUQMK9J47MNIMwojPX+2yz8LQsgM4wHwYDVR0jBBgwFoAUOpqFBxBnKLbv
# 9r0FQW4gwZTaD94wNAYIKwYBBQUHAQEEKDAmMCQGCCsGAQUFBzABhhhodHRwOi8v
# b2NzcC5nb2RhZGR5LmNvbS8wNQYDVR0fBC4wLDAqoCigJoYkaHR0cDovL2NybC5n
# b2RhZGR5LmNvbS9nZHJvb3QtZzIuY3JsMEYGA1UdIAQ/MD0wOwYEVR0gADAzMDEG
# CCsGAQUFBwIBFiVodHRwczovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkv
# MA0GCSqGSIb3DQEBCwUAA4IBAQAIfmyTEMg4uJapkEv/oV9PBO9sPpyIBslQj6Zz
# 91cxG7685C/b+LrTW+C05+Z5Yg4MotdqY3MxtfWoSKQ7CC2iXZDXtHwlTxFWMMS2
# RJ17LJ3lXubvDGGqv+QqG+6EnriDfcFDzkSnE3ANkR/0yBOtg2DZ2HKocyQetawi
# DsoXiWJYRBuriSUBAA/NxBti21G00w9RKpv0vHP8ds42pM3Z2Czqrpv1KrKQ0U11
# GIo/ikGQI31bS/6kA1ibRrLDYGCD+H1QQc7CoZDDu+8CL9IVVO5EFdkKrqeKM+2x
# LXY2JtwE65/3YR8V3Idv7kaWKK2hJn0KCacuBKONvPi8BDABMIIFJjCCBA6gAwIB
# AgIICsxCB6AJxjswDQYJKoZIhvcNAQELBQAwgbQxCzAJBgNVBAYTAlVTMRAwDgYD
# VQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMRowGAYDVQQKExFHb0Rh
# ZGR5LmNvbSwgSW5jLjEtMCsGA1UECxMkaHR0cDovL2NlcnRzLmdvZGFkZHkuY29t
# L3JlcG9zaXRvcnkvMTMwMQYDVQQDEypHbyBEYWRkeSBTZWN1cmUgQ2VydGlmaWNh
# dGUgQXV0aG9yaXR5IC0gRzIwHhcNMTcwNDA1MjAwMjAwWhcNMjAwNDEwMTk1MTM5
# WjBoMQswCQYDVQQGEwJVUzEOMAwGA1UECBMFVGV4YXMxDzANBgNVBAcTBkF1c3Rp
# bjEbMBkGA1UEChMSQWN0aWFuIENvcnBvcmF0aW9uMRswGQYDVQQDExJBY3RpYW4g
# Q29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDDl5bZ
# gsKcnWzrY8rYrsSmI4l9tC5Ipk1Dp/LHYZQ/1uwgzbiUQavCOKhJ6q+XMGHIOF6P
# N/PkfIfrf1XygR3bJy+f0u4HICioNg0GmfBgEUHVpZTkeRxCT+Dd1FeDDljp9J41
# AVkXh8SnzKvSGKjaUbp3DkH2Y5P24pHR9zhpx2hnqSF0PHOT0fGFcF4SAeYBTIT0
# nSmVPxjs2+NV1M81xtCLLLCF9ceV784DyY7MhoHI9Q7fHpxUJZi0nuHRzyUurofC
# QmJhOLd5vm7re/WUAHfhG3P7dIkm1mI9SHAWid2A/4vGWHb/bR5mwJTDxvPmgfzz
# EVmR8PHPNTsRXZYpAgMBAAGjggGFMIIBgTAMBgNVHRMBAf8EAjAAMBMGA1UdJQQM
# MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIHgDA1BgNVHR8ELjAsMCqgKKAmhiRo
# dHRwOi8vY3JsLmdvZGFkZHkuY29tL2dkaWcyczUtMi5jcmwwXQYDVR0gBFYwVDBI
# BgtghkgBhv1tAQcXAjA5MDcGCCsGAQUFBwIBFitodHRwOi8vY2VydGlmaWNhdGVz
# LmdvZGFkZHkuY29tL3JlcG9zaXRvcnkvMAgGBmeBDAEEATB2BggrBgEFBQcBAQRq
# MGgwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmdvZGFkZHkuY29tLzBABggrBgEF
# BQcwAoY0aHR0cDovL2NlcnRpZmljYXRlcy5nb2RhZGR5LmNvbS9yZXBvc2l0b3J5
# L2dkaWcyLmNydDAfBgNVHSMEGDAWgBRAwr0njsw0gzCiM9f7bLPwtCyAzjAdBgNV
# HQ4EFgQUd28uU+LsLPArCXvwS49GX5IaKcUwDQYJKoZIhvcNAQELBQADggEBAKMz
# CNStFW8r/jaaSDXwbWnpmRjeGx3FZbmwH+r2gv2UQ5Se0ckdRm86CfF8AjGnFd/d
# pOSsLWUSWx5+gdqorB9+xY6KrB0br08CfRYvvw+ZYiRrnvLEJyD3hc13tHYpmDOS
# lamg3seFzk/rKe5g/ZXwDQXOiAMEkH5xBHS3BBILQarbiJ14CLM9eLDSeN8L/Gdy
# SvMX4nWy9UusiXP3ZXvuVPUlAOBvDUZaM1BPir0ZWY/m2FOW8bHxXzTG8VtdgY0y
# JIkaii7O3A1kkB9ofB47LQN/CuwcOOKQx0hNL3Nlq7zsFizWk6MO3ZmPNjjimkI6
# mT0NuoY6yd9VefcO95MxggSFMIIEgQIBATCBwTCBtDELMAkGA1UEBhMCVVMxEDAO
# BgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoTEUdv
# RGFkZHkuY29tLCBJbmMuMS0wKwYDVQQLEyRodHRwOi8vY2VydHMuZ29kYWRkeS5j
# b20vcmVwb3NpdG9yeS8xMzAxBgNVBAMTKkdvIERhZGR5IFNlY3VyZSBDZXJ0aWZp
# Y2F0ZSBBdXRob3JpdHkgLSBHMgIICsxCB6AJxjswCQYFKw4DAhoFAKCBijAZBgkq
# hkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYKKwYBBAGC
# NwIBFTAjBgkqhkiG9w0BCQQxFgQUGcKHEd7p75Wq0zP7mJ11ZnD7sScwKgYKKwYB
# BAGCNwIBDDEcMBqhGIAWaHR0cDpcXHd3dy5hY3RpYW4uY29tIDANBgkqhkiG9w0B
# AQEFAASCAQACzJQqMCtt6FADj7WWNAsTEWz81SDYNFdcovTGkuxrwC/8uUUP3IyE
# FGdDdSBcRn3U6gAIjR0BzUIZK+TpYOuYRfYHaj4uUclE95JvrwV0UIXYg6LqgWHo
# Mlq2hM0A41kXlJmtMzQY80dpLa/bptRUr9ePIg/eJU5gSJkcjRE+BWi6rKjNk8W9
# 4k2/YqrjaxyRV2o0teTkTmO8TiWy7xlQwqYgMbUO9I39b8voic/PU17RG7hXPE4C
# 4LZw0Dxcp1ybl4nJV1E17FxkLmim7cVJNtQJ94v0i/IDb0iR2mT6l9GTTNt33eJy
# 5SN44V2Dyk5odkVSz6skjysF5v3g/94AoYICCzCCAgcGCSqGSIb3DQEJBjGCAfgw
# ggH0AgEBMHIwXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
# cmF0aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2Vz
# IENBIC0gRzICEA7P9DjI/r81bgTYapgbGlAwCQYFKw4DAhoFAKBdMBgGCSqGSIb3
# DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIwMDQwMTE2MjUyN1ow
# IwYJKoZIhvcNAQkEMRYEFCWyIif7DgIm4eLiWXIL6LQfYDkrMA0GCSqGSIb3DQEB
# AQUABIIBAAxW94X1aOgU3eMhQ454/XuTMzQwuj30HVpnEEN7hUtIXV4EWh2j6yiH
# Ihd1aXgkfErhoJFxOP0ulCJ7C8fPMnqlunnx7IWcHQd8IOqJaFNtXy8stJPjRtqc
# QrtsynhUDYOrNbzrt8rNmv8EDa9wT09tZXDTCfC00aEuKh99//GBvOayCewiD6uK
# uQLudeYU5W2kAMGVl3d3i8FTDl6BycabZCl5qkPkuYEl5eBiLq026gXLiVEYFRn+
# TCYjFJ8mowVP7BTLm0XEZxFVwu8WyNlAmi2i5nvLbdrUTe6MOP4JrjSF3KaDGpAw
# a+9QSpHPG30hEhCncAI9q7xeKxh3sq8=
# SIG # End signature block
