﻿using Pervasive.Data.SqlClient.Entity;
using System.Data.Entity;

namespace ConnectionResiliency.Context
{
    /// <summary>
    /// Adding a Custom Command Interceptor
    /// and Using PsqlExecutionStrategy to test Connection Resiliency
    /// </summary>
    public class PSQLDbConfiguration : DbConfiguration
    {
        public PSQLDbConfiguration()
        {
            AddInterceptor(new PSQLTransientFailureCausingCommandInterceptor());
            // This is code based registration for setting Execution strategy
            // This can also be done through config based registration in app.config
            SetExecutionStrategy("Pervasive.Data.SqlClient", () => new PsqlExecutionStrategy());
        }
    }
}
