using System;
using System.Drawing;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Pervasive.Data.SqlClient;

namespace DataGridUpdate
{
	/// <summary>
	/// Summary description for DataGridUpdate.
	/// </summary>
	public class DataGridUpdate : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button executeButton;
		private System.Windows.Forms.DataGrid dataGrid;
		private System.Windows.Forms.Button updateButton;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button DoneButton;

		// Define objects for use in this sample
		private PsqlConnection m_connection;
		private PsqlCommandBuilder cb;
		private PsqlDataAdapter adapter;
		private DataSet dataSet;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DataGridUpdate()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.executeButton = new System.Windows.Forms.Button();
			this.dataGrid = new System.Windows.Forms.DataGrid();
			this.updateButton = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.DoneButton = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.dataGrid)).BeginInit();
			this.SuspendLayout();
			// 
			// executeButton
			// 
			this.executeButton.Location = new System.Drawing.Point(96, 56);
			this.executeButton.Name = "executeButton";
			this.executeButton.Size = new System.Drawing.Size(95, 23);
			this.executeButton.TabIndex = 2;
			this.executeButton.Text = "Execute";
			this.executeButton.Click += new System.EventHandler(this.executeButton_Click);
			// 
			// dataGrid
			// 
			this.dataGrid.DataMember = "";
			this.dataGrid.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGrid.Location = new System.Drawing.Point(7, 112);
			this.dataGrid.Name = "dataGrid";
			this.dataGrid.Size = new System.Drawing.Size(629, 232);
			this.dataGrid.TabIndex = 8;
			this.dataGrid.Navigate += new System.Windows.Forms.NavigateEventHandler(this.dataGrid_Navigate);
			// 
			// updateButton
			// 
			this.updateButton.Enabled = false;
			this.updateButton.Location = new System.Drawing.Point(424, 56);
			this.updateButton.Name = "updateButton";
			this.updateButton.TabIndex = 23;
			this.updateButton.Text = "Update";
			this.updateButton.Click += new System.EventHandler(this.updateButton_Click);
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(85, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(480, 16);
			this.label1.TabIndex = 24;
			this.label1.Text = "Command Used for this Sample: SELECT * FROM MYEMP";
			this.label1.Click += new System.EventHandler(this.label1_Click);
			// 
			// DoneButton
			// 
			this.DoneButton.Location = new System.Drawing.Point(280, 368);
			this.DoneButton.Name = "DoneButton";
			this.DoneButton.TabIndex = 25;
			this.DoneButton.Text = "Done";
			this.DoneButton.Click += new System.EventHandler(this.DoneButton_Click);
			// 
			// DataGridUpdate
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(642, 406);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.DoneButton,
																		  this.label1,
																		  this.updateButton,
																		  this.dataGrid,
																		  this.executeButton});
			this.Name = "DataGridUpdate";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "DataGridUpdate";
			this.Load += new System.EventHandler(this.DataGridUpdate_Load);
			((System.ComponentModel.ISupportInitialize)(this.dataGrid)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new DataGridUpdate());
		}

		private void executeButton_Click(object sender, System.EventArgs e) 
		{
			try 
			{
				// Create and open a new connection
                m_connection = new PsqlConnection("Host=localhost;Port=1583;Database=demodata;");
				m_connection.Open ();
				// New DataAdapter with the select command
				adapter = new PsqlDataAdapter ("select * from myEmp", m_connection);
				// New CommandBuilder to generate Update, Insert and Delete commands
				cb = new PsqlCommandBuilder(adapter);
				// Set DataAdapter's Insert, Update and Delete commands by using the command builder
				// To set the Update and Delete commands, the table MUST have a primary key column and
				// that column HAS TO be a part of the select statement
				adapter.InsertCommand = cb.GetInsertCommand();
				adapter.UpdateCommand = cb.GetUpdateCommand();
				adapter.DeleteCommand = cb.GetDeleteCommand();
				// New DataSet, name it as "MYDS"
				dataSet = new DataSet ("MYDS");
				// Populate the data set with the result set
				adapter.Fill (dataSet, "MYTABLE");
				// Bind the DataGrid with the DataSet as it's DataSource
				dataGrid.SetDataBinding (dataSet, "MYTABLE");
				// Enable to the Updtae button, now that the DataGrid is filled
				updateButton.Enabled = true;
			}
			// Catch any exception thrown
			catch (PsqlException sqlException) 
			{
				foreach (PsqlError error in sqlException.Errors) 
				{
					// Display any error messages in a Message Box
					MessageBox.Show (error.Message, "Psql Exception");
				}
			}
			catch (Exception exception) 
			{
				// Display any exception message in a Message Box, other than Psql Exception
				MessageBox.Show (exception.Message, "Exception");
			}
		}

		private void DoneButton_Click(object sender, System.EventArgs e)
		{
			// Check the state of the connection. Close it if it's open.
			ConnectionState state = m_connection.State;
			if ( state.Equals(ConnectionState.Open))
			{
				m_connection.Close();
			}
			// Close the GUI
			this.Close();
		}

		private void label1_Click(object sender, System.EventArgs e)
		{
		
		}

		private void updateButton_Click(object sender, System.EventArgs e)
		{
			try 
			{
				// Update the adapter/dataset/database table after the changes have been made to the DataGrid
				adapter.Update(dataSet, "MYTABLE");
				// Refresh the DataGrid.
				dataGrid.Refresh();
			}
				// Catch any exception thrown
			catch (PsqlException sqlException) 
			{
				foreach (PsqlError error in sqlException.Errors) 
				{
					// Display any error messages in a Message Box
					MessageBox.Show (error.Message, "Psql Exception");
				}
			}
			catch (Exception exception) 
			{
				// Display any exception message in a Message Box, other than Psql Exception
				MessageBox.Show (exception.Message, "Exception");
			}
		}

		private void dataGrid_Navigate(object sender, System.Windows.Forms.NavigateEventArgs ne)
		{
		
		}

		private void DataGridUpdate_Load(object sender, System.EventArgs e)
		{
		
		}
	}
}
