using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Pervasive.Data.SqlClient;

namespace DataReader
{
	/// <summary>
	/// Summary description for DataReader.
	/// </summary>
	public class DataReader : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.RichTextBox ResultSet;
		private System.Windows.Forms.RichTextBox SelectStatement;
		private System.Windows.Forms.Button Execute;
		private System.Windows.Forms.Button Done;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DataReader()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.SelectStatement = new System.Windows.Forms.RichTextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.ResultSet = new System.Windows.Forms.RichTextBox();
			this.Execute = new System.Windows.Forms.Button();
			this.Done = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, (System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline), System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(152, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(160, 24);
			this.label1.TabIndex = 0;
			this.label1.Text = "DataReader Demo";
			this.label1.Click += new System.EventHandler(this.label1_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(152, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Select Statement: (Editable)";
			this.label2.Click += new System.EventHandler(this.label2_Click);
			// 
			// SelectStatement
			// 
			this.SelectStatement.Location = new System.Drawing.Point(16, 72);
			this.SelectStatement.Name = "SelectStatement";
			this.SelectStatement.Size = new System.Drawing.Size(456, 24);
			this.SelectStatement.TabIndex = 2;
			this.SelectStatement.Text = "SELECT ename FROM myEmp WHERE sal>50000";
			this.SelectStatement.TextChanged += new System.EventHandler(this.SelectStatement_TextChanged);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 144);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(64, 16);
			this.label3.TabIndex = 3;
			this.label3.Text = "Result Set:";
			this.label3.Click += new System.EventHandler(this.label3_Click);
			// 
			// ResultSet
			// 
			this.ResultSet.Location = new System.Drawing.Point(16, 160);
			this.ResultSet.Name = "ResultSet";
			this.ResultSet.ReadOnly = true;
			this.ResultSet.Size = new System.Drawing.Size(456, 96);
			this.ResultSet.TabIndex = 4;
			this.ResultSet.Text = "";
			this.ResultSet.TextChanged += new System.EventHandler(this.ResultSet_TextChanged);
			// 
			// Execute
			// 
			this.Execute.Location = new System.Drawing.Point(152, 112);
			this.Execute.Name = "Execute";
			this.Execute.Size = new System.Drawing.Size(144, 23);
			this.Execute.TabIndex = 5;
			this.Execute.Text = "Execute Query";
			this.Execute.Click += new System.EventHandler(this.Execute_Click);
			// 
			// Done
			// 
			this.Done.Location = new System.Drawing.Point(184, 264);
			this.Done.Name = "Done";
			this.Done.TabIndex = 6;
			this.Done.Text = "Done";
			this.Done.Click += new System.EventHandler(this.Done_Click);
			// 
			// DataReader
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(480, 294);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.Done,
																		  this.Execute,
																		  this.ResultSet,
																		  this.label3,
																		  this.SelectStatement,
																		  this.label2,
																		  this.label1});
			this.Name = "DataReader";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "DataReader";
			this.Load += new System.EventHandler(this.DataReader_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new DataReader());
		}

		private void label1_Click(object sender, System.EventArgs e)
		{
		
		}

		private void label2_Click(object sender, System.EventArgs e)
		{
		
		}

		private void SelectStatement_TextChanged(object sender, System.EventArgs e)
		{
			
		}

		private void label3_Click(object sender, System.EventArgs e)
		{
		
		}

		private void ResultSet_TextChanged(object sender, System.EventArgs e)
		{
		
		}

		private void Execute_Click(object sender, System.EventArgs e)
		{
			// Select Statement variable
			string SelectSQL = SelectStatement.Text;
			// StringWriter to append all the output
			StringWriter writer = new StringWriter();
			// Modify the connection string to match your servers
            PsqlConnection Conn = new PsqlConnection("Host=localhost;Port=1583;Database=demodata;");
			try
			{
				Conn.Open();
			}
			catch (Exception ex)
			{
				// Connection failed
				writer.WriteLine(ex.Message);
				// Dump the output on the Result window
				flush(writer);
				return;
			}
			// PsqlCommand
			PsqlCommand DBCmd = new PsqlCommand(SelectSQL, Conn);
			// Call PsqlDataReader
			try
			{
				PsqlDataReader dataReader = DBCmd.ExecuteReader();
				// Print out the result set onto the ResultSet window
				printReader(dataReader, writer);
				// Close the DataReader
				dataReader.Close();
			}
			catch (Exception ex)
			{
				// Exception thrown at execution
				writer.WriteLine(ex.Message);
			}
			// Dump the output on the Result window
			flush(writer);
			// Close the connection
			Conn.Close();
		}

		private void Done_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		// This method call dumps the StringWriter contents on to the ResultSet window
		private void flush (StringWriter writer)
		{
			ResultSet.Clear();
			ResultSet.AppendText (writer.ToString ());
			ResultSet.Refresh();
			writer.GetStringBuilder ().Length = 0;
		}

		// This method call will print out the result set on to the ResultSet window
		public void printReader( IDataReader reader, StringWriter writer)
		{
			bool fMoreRows;
			int i;
			int length = 0;
			bool fFirst = true;
			for (i = 0; i < reader.FieldCount; ++i) 
			{
				if (!fFirst) 
				{
					writer.Write(", ");
				}
				fFirst = false;
				writer.Write(reader.GetName(i));
				length = length + (reader.GetName(i).Length);
			}
			writer.WriteLine ("");
			for ( int z = 0; z < length+((reader.FieldCount)*2); z++ )
			{
				writer.Write("-");
			}
			writer.WriteLine ("");
			do 
			{
				fMoreRows = reader.Read();
				if (fMoreRows) 
				{
					fFirst = true;
					for (i = 0; i < reader.FieldCount; ++i) 
					{
						if (!fFirst) 
						{
							writer.Write(", ");
						}
						fFirst = false;

						if (reader.IsDBNull (i)) 
						{
							writer.Write("<null>");
						}
						else 
						{
							string str;
							object obj = reader.GetValue(i);
							if (obj is DateTime) 
							{
								str = ((DateTime)obj).ToString("yyyy-MM-dd HH:mm:ss.fff");
							}
							else 
							{
								str = obj.ToString();
							}

							writer.Write(str);
						}
					}
					writer.WriteLine ("");
				}
			} while (fMoreRows);
		}

		private void DataReader_Load(object sender, System.EventArgs e)
		{
		
		}
	}
}
