using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Pervasive.Data.SqlClient;

namespace LocalTransactions
{
	/// <summary>
	/// Summary description for LocalTransaction.
	/// </summary>
	public class LocalTransaction : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button Start;
		private System.Windows.Forms.RichTextBox OutputWindow;
		private System.Windows.Forms.Button DoneButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public LocalTransaction()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Start = new System.Windows.Forms.Button();
			this.OutputWindow = new System.Windows.Forms.RichTextBox();
			this.DoneButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// Start
			// 
			this.Start.Location = new System.Drawing.Point(56, 32);
			this.Start.Name = "Start";
			this.Start.Size = new System.Drawing.Size(184, 23);
			this.Start.TabIndex = 0;
			this.Start.Text = "Start Local Transaction";
			this.Start.Click += new System.EventHandler(this.Start_Click);
			// 
			// OutputWindow
			// 
			this.OutputWindow.Location = new System.Drawing.Point(56, 72);
			this.OutputWindow.Name = "OutputWindow";
			this.OutputWindow.ReadOnly = true;
			this.OutputWindow.Size = new System.Drawing.Size(184, 96);
			this.OutputWindow.TabIndex = 1;
			this.OutputWindow.Text = "";
			this.OutputWindow.TextChanged += new System.EventHandler(this.OutputWindow_TextChanged);
			// 
			// DoneButton
			// 
			this.DoneButton.Location = new System.Drawing.Point(104, 184);
			this.DoneButton.Name = "DoneButton";
			this.DoneButton.TabIndex = 2;
			this.DoneButton.Text = "Done";
			this.DoneButton.Click += new System.EventHandler(this.DoneButton_Click);
			// 
			// LocalTransaction
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.DoneButton,
																		  this.OutputWindow,
																		  this.Start});
			this.Name = "LocalTransaction";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "LocalTransaction";
			this.Load += new System.EventHandler(this.LocalTransaction_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new LocalTransaction());
		}

		/// <summary>
		/// Writes out all the information during 
		/// the test run onto the OutputWindow text box.
		/// </summary>
		/// <param name="writer"></param>
		private void flush (StringWriter writer)
		{
			OutputWindow.AppendText (writer.ToString ());
			OutputWindow.Refresh();
			writer.GetStringBuilder ().Length = 0;
		}

		private void Start_Click(object sender, System.EventArgs e)
		{
			// String writer to write the output info
			StringWriter writer = new StringWriter();
			// Change the connection string to match your servers
            PsqlConnection Conn = new PsqlConnection("Host=localhost;Port=1583;Database=demodata;");
			try 
			{
				// Open the connection
				Conn.Open();
			}
			catch (Exception ex)
			{
				// Connection failed
				writer.WriteLine(ex.Message);
				flush(writer);
				return;
			}
			// PsqlCommand
			PsqlCommand     DBCmd = new PsqlCommand();
			// PsqlTransaction
			PsqlTransaction DBTxn = null;

			try 
			{
				// Start the transaction
                DBTxn = Conn.BeginTransaction();

				// Set the Connection property of the Command object
				DBCmd.Connection = Conn;
				// Set the text of the Command to the INSERT statement
                DBCmd.CommandText = "insert into myEmp VALUES (15,'HAYES','ADMIN',6,{d'2002-04-17'},18000,NULL,4)";
				// Set the transaction property of the Command object
				DBCmd.Transaction = DBTxn;
                writer.WriteLine("Insert Successful!");

				// Execute the statement with ExecuteNonQuery, because we are not returning results
				DBCmd.ExecuteNonQuery();
				// Now commit the transaction
				DBTxn.Commit();
				// Display any exceptions 
				writer.WriteLine ("Transaction Committed!");
				flush(writer);
				// Delete the record just added to the table, for sanity purpose
				DBCmd.CommandText = "delete from myEmp WHERE empno=15";
				DBCmd.ExecuteNonQuery();
                writer.WriteLine("Data Delete Successful!");
                flush(writer);
			}
			catch (Exception ex) 
			{
				// Display any exceptions
				writer.WriteLine (ex.Message);
				flush(writer);
				// If anything failed after the connection was opened, roll back the transaction
				if (DBTxn != null) 
				{
					DBTxn.Rollback();
				}
			}
			// Close the connection
			Conn.Close();
		}

		private void OutputWindow_TextChanged(object sender, System.EventArgs e)
		{
		
		}

		private void DoneButton_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void LocalTransaction_Load(object sender, System.EventArgs e)
		{
		
		}
	}
}
