/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.model;

import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import pervasive.database.PsqlException;
import pvideoj.model.Contract;
import pvideoj.model.ContractList;
import pvideoj.model.ContractTitle;
import pvideoj.model.ContractTitleList;
import pvideoj.model.DBListModelEvent;
import pvideoj.model.DBListModelListener;
import pvideoj.model.DBObject;
import pvideoj.model.Title;
import pvideoj.model.TitleList;

public class TitlesRentedTableModel
extends AbstractTableModel
implements DBListModelListener {
    private static final long MILLISECS_IN_DAY = 86400000L;
    private static Class[] _columnClasses = new Class[]{String.class, String.class, Double.class, String.class};
    private String[] _columnHeadings;
    private ContractList _contracts;
    private ContractTitleList _contractTitles;
    private TitleList _titles;
    private Vector _rows = new Vector();
    private Vector _deleted = new Vector();

    public TitlesRentedTableModel(ContractList contractList, ContractTitleList contractTitleList, TitleList titleList, String[] stringArray) {
        this._contracts = contractList;
        this._contractTitles = contractTitleList;
        this._titles = titleList;
        this._columnHeadings = stringArray;
        this._contractTitles.addDBListModelListener(this);
    }

    public void deleteRow(int n) {
        DBObject dBObject = (DBObject)this._rows.elementAt(n);
        if (!dBObject.isNew()) {
            this._deleted.addElement(dBObject);
        }
        this._rows.removeElementAt(n);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addRow(int n, int n2) {
        ContractTitle contractTitle = this._contractTitles.createContractTitle();
        Contract contract = (Contract)this._contracts.getSelectedObject();
        if (contract != null) {
            contractTitle.setContractID(contract.getID());
        }
        contractTitle.setTitleID(n);
        contractTitle.setCopyID(n2);
        this._rows.addElement(contractTitle);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void saveRows() throws PsqlException {
        DBObject dBObject;
        Enumeration enumeration = this._rows.elements();
        while (enumeration.hasMoreElements()) {
            dBObject = (DBObject)enumeration.nextElement();
            if (!dBObject.isNew()) continue;
            this._contractTitles.save(dBObject);
        }
        enumeration = this._deleted.elements();
        while (enumeration.hasMoreElements()) {
            dBObject = (DBObject)enumeration.nextElement();
            this._contractTitles.delete(dBObject);
        }
        this._rows.removeAllElements();
        this._deleted.removeAllElements();
    }

    public void setContractID(int n) {
        Enumeration enumeration = this._rows.elements();
        while (enumeration.hasMoreElements()) {
            ContractTitle contractTitle = (ContractTitle)enumeration.nextElement();
            if (!contractTitle.isNew()) continue;
            contractTitle.setContractID(n);
        }
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    public Class getColumnClass(int n) {
        return _columnClasses[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        ContractTitle contractTitle = (ContractTitle)this._rows.elementAt(n);
        Title title = null;
        try {
            title = this._titles.findTitleByIndex(contractTitle.getTitleID());
        }
        catch (PsqlException psqlException) {
            System.err.println((Object)psqlException);
        }
        if (title == null) {
            return "";
        }
        switch (n2) {
            case 0: {
                object = title.getID() + "-" + contractTitle.getCopyID();
                break;
            }
            case 1: {
                object = title.getTitle();
                break;
            }
            case 2: {
                object = new Double(title.getPrice());
                break;
            }
            case 3: {
                Contract contract = this._contractTitles.getContract();
                Date date = contract != null ? contract.getDate() : new Date();
                Date date2 = new Date(date.getTime() + (long)title.getTerm() * 86400000L);
                object = DateFormat.getDateInstance(3).format(date2);
            }
        }
        return object;
    }

    @Override
    public int getColumnCount() {
        return this._columnHeadings.length;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnHeadings[n];
    }

    @Override
    public void listChanged(DBListModelEvent dBListModelEvent) {
        int n = dBListModelEvent.getType();
        if (n != -1) {
            this.fireTableChanged(new TableModelEvent(this, dBListModelEvent.getRow()));
            return;
        }
        this._rows.removeAllElements();
        this._deleted.removeAllElements();
        if (this._contractTitles.getRowCount() != 0) {
            try {
                ContractTitle contractTitle = (ContractTitle)this._contractTitles.getFirst();
                while (contractTitle != null) {
                    this._rows.addElement(contractTitle);
                    contractTitle = (ContractTitle)this._contractTitles.getNext();
                }
            }
            catch (PsqlException psqlException) {
                System.err.println((Object)psqlException);
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
    }
}

