/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import pervasive.database.PsqlException;
import pvideoj.model.ContractTitle;
import pvideoj.model.ContractTitleList;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.PVideoDB;
import pvideoj.model.Title;
import pvideoj.model.TitleCopyList;
import pvideoj.model.TitleList;
import pvideoj.model.TitlesTableModel;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.LayoutUtils;
import pvideoj.views.TitlesTableView;

class TitlesPanel
extends JPanel {
    private static String[] _titleColumnHeadings = new String[]{"Title ID", "Title", "Category", "Price", "Term", "Quantity"};
    private static String[] _titleColumnNames = new String[]{"TitleID", "Title", "Category", "Price", "Term", null};
    private TitleList _titles;
    private TitlesTableView _titleTableView;
    private TitleCopyList _copies;
    private ContractTitleList _contract_titles;

    TitlesPanel() throws PsqlException {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Titles"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        PVideoDB pVideoDB = PVideoDB.instance();
        this._titles = (TitleList)pVideoDB.getSharedDBObjectList(7);
        this._copies = (TitleCopyList)pVideoDB.getSharedDBObjectList(6);
        this._copies.addDBListModelListener(this._titles);
        this._contract_titles = (ContractTitleList)pVideoDB.createDBObjectList(2);
        TitlesTableModel titlesTableModel = new TitlesTableModel(this._titles, _titleColumnHeadings, _titleColumnNames);
        this._titleTableView = new TitlesTableView(this._titles, (TableModel)titlesTableModel, _titleColumnHeadings, _titleColumnNames, new Dimension(400, 100), "Title List");
        LayoutUtils.constrain(gridBagConstraints, this, this._titleTableView, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(this._titleTableView);
        TitleActions titleActions = new TitleActions();
        LayoutUtils.constrain(gridBagConstraints, this, titleActions, 0, 1, 1, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.add(titleActions);
    }

    class TitleActions
    extends JPanel {
        JButton _newBtn = new JButton("New");
        JButton _deleteBtn;

        TitleActions() {
            this.add(this._newBtn);
            this._newBtn.setToolTipText("Add a new title");
            this._newBtn.addActionListener(new NewTitleListener());
            this._deleteBtn = new JButton("Delete");
            this._deleteBtn.setEnabled(false);
            this.add(this._deleteBtn);
            this._deleteBtn.setToolTipText("Delete the selected title");
            this._deleteBtn.addActionListener(new DeleteTitleListener());
            TitlesPanel.this._titles.addDBListSelectionListener(new DBListSelectionListener(){

                @Override
                public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
                    TitleActions.this._deleteBtn.setEnabled(dBListSelectionEvent.getSelectedRowIndex() != -1);
                }
            });
        }

        class DeleteTitleListener
        implements ActionListener {
            DeleteTitleListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = TitlesPanel.this._titles.getSelectedIndex();
                    boolean bl = TitlesPanel.this._titles.isSelectedLast();
                    Title title = (Title)TitlesPanel.this._titles.getSelectedObject();
                    ContractTitle contractTitle = TitlesPanel.this._contract_titles.findContractTitle(title.getID());
                    if (contractTitle != null) {
                        String string = "Cannot delete this title.\n";
                        string = string + "It is referenced in contract \"" + contractTitle.getContractID() + "\".";
                        ErrorMessage.showMessage((AWTEvent)actionEvent, string);
                        return;
                    }
                    try {
                        PVideoDB.instance().getSession().startTransaction(0);
                        TitlesPanel.this._titles.delete(title);
                        TitlesPanel.this._copies.deleteAll();
                        PVideoDB.instance().getSession().commitTransaction();
                    }
                    catch (PsqlException psqlException) {
                        PVideoDB.instance().getSession().abortTransaction();
                        return;
                    }
                    if (!bl) {
                        TitlesPanel.this._titles.setSelectionIndex(n);
                    } else {
                        TitlesPanel.this._titles.setSelectionIndex(n - 1);
                    }
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
            }
        }

        class NewTitleListener
        implements ActionListener {
            NewTitleListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TitlesPanel.this._titles.save(TitlesPanel.this._titles.createTitle());
                    TitlesPanel.this._titles.getLast();
                    TitlesPanel.this._titles.setSelectionIndex(TitlesPanel.this._titles.getCurrentIndex());
                }
                catch (PsqlException psqlException) {
                    ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
                }
            }
        }
    }
}

