/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import pervasive.database.Driver;
import pervasive.database.PsqlException;
import pervasive.database.PsqlIOException;
import pervasive.database.PsqlSecurityException;
import pvideoj.model.DBObjectList;
import pvideoj.model.DBObjectListErrorEvent;
import pvideoj.model.DBObjectListErrorListener;
import pvideoj.model.PVideoDB;
import pvideoj.utils.ErrorMessage;
import pvideoj.views.PasswordDialog;

public class PVideo
implements DBObjectListErrorListener {
    private static String _windowsLFName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

    public static void main(String[] stringArray) {
        new PVideo();
    }

    public PVideo() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            PVideo.exit(1, exception);
        }
        this.setDefaultColors();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("PVideoRes");
        String string = "btrv://pvideo";
        try {
            string = resourceBundle.getString("DatabaseURI");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String string2 = "";
        try {
            string2 = resourceBundle.getString("DictionaryLocation");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Pervasive Software Inc.");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PVideo.exit(0, null);
            }
        });
        MainMenu mainMenu = new MainMenu(jFrame);
        jFrame.getContentPane().add("Center", mainMenu);
        jFrame.pack();
        this.initPVideoDB(jFrame, string, string2);
        try {
            mainMenu.buildDialogs();
        }
        catch (PsqlException psqlException) {
            ErrorMessage.showMessage((Component)jFrame, (Exception)((Object)psqlException));
            PVideo.exit(3, (Exception)((Object)psqlException));
        }
        DBObjectList.setDBObjectListErrorListener(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(new Point((dimension.width - jFrame.getSize().width) / 2, (dimension.height - jFrame.getSize().height) / 2));
        jFrame.setVisible(true);
    }

    @Override
    public void internalErrorOccurred(DBObjectListErrorEvent dBObjectListErrorEvent) {
        Exception exception = dBObjectListErrorEvent.getError();
        if (exception instanceof PsqlIOException) {
            System.err.println("Fatal Error!");
            PVideo.exit(4, exception);
        }
    }

    private void setDefaultColors() {
        if (!UIManager.getSystemLookAndFeelClassName().equals(_windowsLFName)) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put("TextField.selectionBackground", SystemColor.textHighlight);
        uIDefaults.put("TextField.selectionForeground", Color.white);
        uIDefaults.put("Table.selectionBackground", SystemColor.textHighlight);
        uIDefaults.put("Table.selectionForeground", Color.white);
        uIDefaults.put("ComboBox.selectedForeground", Color.white);
        uIDefaults.put("ComboBox.selectedBackground", SystemColor.textHighlight);
        uIDefaults.put("ComboBox.listBackground", SystemColor.textHighlight);
        uIDefaults.put("ComboBox.listForeground", Color.white);
        uIDefaults.put("List.selectionBackground", SystemColor.textHighlight);
        uIDefaults.put("Table.focusCellHighlightBorder", new LineBorder(SystemColor.textHighlight, 1));
    }

    private void initPVideoDB(Frame frame, String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        while (n < 4) {
            ++n;
            try {
                PVideoDB.init(string, string2, string3, string4);
                break;
            }
            catch (PsqlSecurityException psqlSecurityException) {
                Object object;
                if (n == 4) {
                    PVideo.exit(3, (Exception)((Object)psqlSecurityException));
                }
                if (n != 1) {
                    ErrorMessage.showMessage((Component)frame, "Invalid user name or password.\nTry again.");
                }
                if (string5 == null) {
                    object = new StringTokenizer(string, ":/");
                    ((StringTokenizer)object).nextToken();
                    string5 = ((StringTokenizer)object).nextToken();
                }
                object = new PasswordDialog(frame, string5);
                ((Dialog)object).setVisible(true);
                if (((PasswordDialog)object).getResponse() == 1) {
                    PVideo.exit(3, (Exception)((Object)psqlSecurityException));
                }
                string3 = ((PasswordDialog)object).getUsername();
                string4 = ((PasswordDialog)object).getPassword();
                string = "btrv://" + string3 + "@" + string5 + "/pvideodb?pwd=" + string4;
            }
            catch (PsqlException psqlException) {
                PVideo.exit(2, (Exception)((Object)psqlException));
            }
        }
    }

    static void exit(int n, Exception exception) {
        if (exception != null) {
            System.err.println(exception.getMessage());
        }
        Driver.killAllSessions();
        System.exit(n);
    }
}

