/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.model;

import pervasive.database.Database;
import pervasive.database.Index;
import pervasive.database.PsqlException;
import pervasive.database.PsqlOperationException;
import pervasive.database.Row;
import pvideoj.model.Contract;
import pvideoj.model.ContractList;
import pvideoj.model.ContractTitle;
import pvideoj.model.DBListModelEvent;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.DBObject;
import pvideoj.model.DBObjectList;
import pvideoj.model.Restriction;

public class ContractTitleList
extends DBObjectList
implements DBListSelectionListener {
    private boolean _contractSelected = false;
    private Contract _contract;
    private ContractList _contracts;

    ContractTitleList(Database database) throws PsqlException {
        super(database, "ContDetail");
    }

    public ContractTitle createContractTitle(Row row) {
        return new ContractTitle(this, row);
    }

    public ContractTitle createContractTitle() {
        return new ContractTitle(this);
    }

    public void setRestrictOnSelectedContract(ContractList contractList) {
        this._contracts = contractList;
        this._contracts.addDBListSelectionListener(this);
    }

    public ContractTitle findContractTitle(int n) throws PsqlException {
        this.setRestriction(new Restriction(1, 1, String.valueOf(n)));
        return (ContractTitle)this.getNext();
    }

    public ContractTitle findContractTitleByIndex(int n, int n2) throws PsqlException {
        Row row;
        block2: {
            this._rowsetMD.setAccessPath(1);
            Index index = this._rowset.createIndex(1);
            index.setInt(0, n);
            index.setInt(1, n2);
            row = null;
            try {
                row = this._rowset.getByIndex(1, index);
            }
            catch (PsqlOperationException psqlOperationException) {
                if (psqlOperationException.getErrorCode() == 4) break block2;
                throw psqlOperationException;
            }
        }
        return row == null ? null : this.createContractTitle(row);
    }

    @Override
    public int getRowCount() {
        if (this._contracts == null) {
            return super.getRowCount();
        }
        if (this._contractSelected) {
            return super.getRowCount();
        }
        return 0;
    }

    @Override
    public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
        if (dBListSelectionEvent.getSource() != this._contracts) {
            return;
        }
        DBObject dBObject = dBListSelectionEvent.getSelectedObject();
        if (dBObject == null) {
            this._contractSelected = false;
            this.fireDBListModelChanged(new DBListModelEvent(this));
            return;
        }
        this._contractSelected = true;
        this._contract = (Contract)dBObject;
        this.setRestriction(new Restriction(0, 1, String.valueOf(this._contract.getID())));
    }

    public Contract getContract() {
        return this._contract;
    }

    @Override
    protected DBObject createObjectFromRow(Row row) {
        return this.createContractTitle(row);
    }
}

