/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.model;

import java.util.Date;
import pervasive.database.PsqlException;
import pervasive.database.PsqlNullValueException;
import pervasive.database.Row;
import pvideoj.model.CustomerList;
import pvideoj.model.DBObject;

public class Customer
extends DBObject {
    private int _ID;
    private String _lastName;
    private String _firstName;
    private String _address1;
    private String _address2;
    private String _city = "Austin";
    private String _state = "TX";
    private String _zip;
    private String _homePhone;
    private String _workPhone;
    private int _status;
    private boolean _member = true;
    private Date _expiration;

    Customer(CustomerList customerList) {
        super(customerList);
    }

    public String getNullableString(Row row, int n) {
        String string = null;
        try {
            string = row.getString(n);
        }
        catch (PsqlNullValueException psqlNullValueException) {
            string = null;
        }
        return string;
    }

    Customer(CustomerList customerList, Row row) {
        super(customerList, row);
        this._ID = row.getInt(0);
        this._lastName = row.getString(1);
        this._firstName = row.getString(2);
        this._address1 = row.getString(3);
        this._address2 = this.getNullableString(row, 4);
        this._city = row.getString(5);
        this._state = row.getString(6);
        this._zip = row.getString(7);
        this._homePhone = row.getString(8);
        this._workPhone = this.getNullableString(row, 9);
        this._status = row.getInt(10);
        this._member = row.getBytes(11)[0] > 0;
        this._expiration = row.getDate(12);
    }

    Customer(CustomerList customerList, int n) {
        super(customerList);
        this._ID = n;
    }

    @Override
    public Row objAsRow() throws PsqlException {
        if (this._row == null) {
            this._row = this._parent.createRow();
        }
        this._row.setInt(0, this._ID);
        this._row.setString(1, this._lastName);
        this._row.setString(2, this._firstName);
        this._row.setString(3, this._address1);
        this._row.setString(4, this._address2);
        this._row.setString(5, this._city);
        this._row.setString(6, this._state);
        this._row.setString(7, this._zip);
        this._row.setString(8, this._homePhone);
        this._row.setString(9, this._workPhone);
        this._row.setInt(10, this._status);
        byte[] byArray = new byte[]{this._member ? (byte)1 : 0};
        this._row.setBytes(11, byArray);
        this._row.setDate(12, this._expiration);
        return this._row;
    }

    @Override
    public int compareTo(Object object) {
        if (this._ID == 0) {
            return 1;
        }
        int n = ((Customer)object).getID();
        if (this._ID == n) {
            return 0;
        }
        if (this._ID < n) {
            return -1;
        }
        return 1;
    }

    public int getID() {
        return this._ID;
    }

    public void setID(int n) {
        this._ID = n;
    }

    public String getLastName() {
        return this._lastName;
    }

    public void setLastName(String string) {
        this._lastName = string;
    }

    public String getFirstName() {
        return this._firstName;
    }

    public void setFirstName(String string) {
        this._firstName = string;
    }

    public String getAddress1() {
        return this._address1;
    }

    public void setAddress1(String string) {
        this._address1 = string;
    }

    public String getAddress2() {
        return this._address2;
    }

    public void setAddress2(String string) {
        this._address2 = string;
    }

    public String getCity() {
        return this._city;
    }

    public void setCity(String string) {
        this._city = string;
    }

    public String getState() {
        return this._state;
    }

    public void setState(String string) {
        this._state = string;
    }

    public String getZip() {
        return this._zip;
    }

    public void setZip(String string) {
        this._zip = string;
    }

    public String getHomePhone() {
        return this._homePhone;
    }

    public void setHomePhone(String string) {
        this._homePhone = string;
    }

    public String getWorkPhone() {
        return this._workPhone;
    }

    public void setWorkPhone(String string) {
        this._workPhone = string;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public boolean isMember() {
        return this._member;
    }

    public void setMember(boolean bl) {
        this._member = bl;
    }

    public Date getExpiration() {
        return this._expiration;
    }

    public void setExpiration(Date date) {
        this._expiration = date;
    }

    public String toString() {
        return "\nID:         " + this._ID + "\n" + "Last Name:  " + this._lastName + "\n" + "First Name: " + this._firstName + "\n" + "Address1:   " + this._address1 + "\n" + "Address2:   " + this._address2 + "\n" + "City:       " + this._city + "\n" + "State:      " + this._state + "\n" + "Zip:        " + this._zip + "\n" + "Home Phone: " + this._homePhone + "\n" + "Work Phone: " + this._workPhone + "\n" + "Status:     " + this._status + "\n" + "Member:     " + this._member + "\n" + "Expiration: " + this._expiration + "\n";
    }
}

