/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.model;

import pervasive.database.Database;
import pervasive.database.Driver;
import pervasive.database.PsqlException;
import pervasive.database.Session;
import pvideoj.model.CategoryList;
import pvideoj.model.ContractList;
import pvideoj.model.ContractTitleList;
import pvideoj.model.CustomerList;
import pvideoj.model.DBObjectList;
import pvideoj.model.EmployeeList;
import pvideoj.model.StateList;
import pvideoj.model.TitleCopyList;
import pvideoj.model.TitleList;

public class PVideoDB {
    public static final int CATEGORY_LIST = 0;
    public static final int CONTRACT_LIST = 1;
    public static final int CONTRACT_TITLE_LIST = 2;
    public static final int CUSTOMER_LIST = 3;
    public static final int EMPLOYEE_LIST = 4;
    public static final int STATE_LIST = 5;
    public static final int TITLE_COPY_LIST = 6;
    public static final int TITLE_LIST = 7;
    private static final int LIST_END = 8;
    private static PVideoDB _instance;
    private Session _session;
    private Database _db;
    private DBObjectList[] _sharedList = new DBObjectList[8];

    public static PVideoDB instance() {
        return _instance;
    }

    protected PVideoDB(String string, String string2, String string3, String string4) throws PsqlException {
        this._session = Driver.establishSession();
        this._db = this._session.connectToDatabase(string);
    }

    public static synchronized void init(String string, String string2, String string3, String string4) throws PsqlException {
        if (_instance == null) {
            _instance = new PVideoDB(string, string2, string3, string4);
        }
    }

    public Session getSession() {
        return this._session;
    }

    public synchronized DBObjectList getSharedDBObjectList(int n) throws PsqlException {
        if (n < 0 || n >= 8) {
            return null;
        }
        if (this._sharedList[n] == null) {
            this._sharedList[n] = this.createDBObjectList(n);
        }
        return this._sharedList[n];
    }

    public DBObjectList createDBObjectList(int n) throws PsqlException {
        DBObjectList dBObjectList = null;
        switch (n) {
            case 0: {
                dBObjectList = new CategoryList(this._db);
                break;
            }
            case 1: {
                dBObjectList = new ContractList(this._db);
                break;
            }
            case 2: {
                dBObjectList = new ContractTitleList(this._db);
                break;
            }
            case 3: {
                dBObjectList = new CustomerList(this._db);
                break;
            }
            case 4: {
                dBObjectList = new EmployeeList(this._db);
                break;
            }
            case 5: {
                dBObjectList = new StateList(this._db);
                break;
            }
            case 6: {
                dBObjectList = new TitleCopyList(this._db);
                break;
            }
            case 7: {
                dBObjectList = new TitleList(this._db);
                break;
            }
        }
        return dBObjectList;
    }
}

