/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.utils;

import java.awt.AWTEvent;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import pervasive.database.PsqlException;
import pvideoj.model.DBListSelectionEvent;
import pvideoj.model.DBListSelectionListener;
import pvideoj.model.DBObjectList;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.JarResourceLocator;
import pvideoj.utils.LayoutUtils;

public class NavigationBar
extends JPanel
implements DBListSelectionListener,
ActionListener {
    private static final int BEGIN = 0;
    private static final int PREVIOUS = 1;
    private static final int NEXT = 2;
    private static final int END = 3;
    private DBObjectList _objectList;
    private static String[] _buttonActions = new String[]{"Begin", "Previous", "Next", "End"};
    private static String[] _buttonImages = new String[]{"/pvideoj/utils/images/begin.gif", "/pvideoj/utils/images/previous.gif", "/pvideoj/utils/images/next.gif", "/pvideoj/utils/images/end.gif"};
    private JButton[] _buttons = new JButton[_buttonActions.length];

    public NavigationBar(DBObjectList dBObjectList) {
        this._objectList = dBObjectList;
        this._objectList.addDBListSelectionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        for (int i = 0; i < _buttonActions.length; ++i) {
            this._buttons[i] = new JButton(JarResourceLocator.getImageIcon(_buttonImages[i]));
            this._buttons[i].setActionCommand(_buttonActions[i]);
            this._buttons[i].setEnabled(false);
            LayoutUtils.constrain(gridBagConstraints, this, this._buttons[i], i, 0, 1, 1, 3, 10, 0.0, 1.0, 0, 0, 0, 0);
            this.add(this._buttons[i]);
            this._buttons[i].addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        for (n = 0; n < _buttonActions.length && !string.equals(_buttonActions[n]); ++n) {
        }
        try {
            int n2 = this._objectList.getSelectedIndex();
            switch (n) {
                case 0: {
                    this._objectList.getFirst();
                    this._objectList.setSelectionIndex(this._objectList.getCurrentIndex());
                    break;
                }
                case 3: {
                    this._objectList.getLast();
                    this._objectList.setSelectionIndex(this._objectList.getCurrentIndex());
                    break;
                }
                case 2: {
                    this._objectList.setSelectionIndex(n2 + 1);
                    break;
                }
                case 1: {
                    this._objectList.setSelectionIndex(n2 - 1);
                }
            }
        }
        catch (PsqlException psqlException) {
            ErrorMessage.showMessage((AWTEvent)actionEvent, (Exception)((Object)psqlException));
        }
    }

    @Override
    public void valueChanged(DBListSelectionEvent dBListSelectionEvent) {
        if (dBListSelectionEvent.getSelectedRowIndex() == -1) {
            this._buttons[0].setEnabled(false);
            this._buttons[1].setEnabled(false);
            this._buttons[3].setEnabled(false);
            this._buttons[2].setEnabled(false);
            return;
        }
        boolean bl = this._objectList.isSelectedFirst();
        this._buttons[0].setEnabled(!bl);
        this._buttons[1].setEnabled(!bl);
        boolean bl2 = this._objectList.isSelectedLast();
        this._buttons[3].setEnabled(!bl2);
        this._buttons[2].setEnabled(!bl2);
    }
}

