/*
 * Decompiled with CFR 0.152.
 */
package pvideoj.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import pvideoj.utils.ErrorMessage;
import pvideoj.utils.Filler;
import pvideoj.utils.LayoutUtils;
import pvideoj.utils.LetterOnlyDocument;
import pvideoj.utils.MaxLengthDocument;

public class AddressPanel
extends JPanel {
    private JTextField _street1TF;
    private JTextField _street2TF;
    private JTextField _cityTF;
    private JTextField _stateTF;
    private JTextField _zipTF;

    public AddressPanel(String string) {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Address"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Street");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 2, 5);
        this.add(jLabel);
        jLabel = new JLabel("City");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 2, 5);
        this.add(jLabel);
        this._street1TF = new JTextField(new MaxLengthDocument(36), "", 20);
        LayoutUtils.constrain(gridBagConstraints, this, this._street1TF, 0, 1, 1, 1, 0, 10, 0.0, 0.0, 0, 5, 3, 5);
        this.add(this._street1TF);
        this._cityTF = new JTextField(new LetterOnlyDocument(24), "", 10);
        LayoutUtils.constrain(gridBagConstraints, this, this._cityTF, 1, 1, 2, 1, 0, 10, 0.0, 0.0, 0, 0, 3, 5);
        this.add(this._cityTF);
        jLabel = new JLabel("Street (2)");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 0, 2, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 2, 5);
        this.add(jLabel);
        jLabel = new JLabel("State");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 1, 2, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 2, 5);
        this.add(jLabel);
        jLabel = new JLabel("ZIP Code");
        LayoutUtils.constrain(gridBagConstraints, this, jLabel, 2, 2, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 2, 5);
        this.add(jLabel);
        this._street2TF = new JTextField(new MaxLengthDocument(36), "", 20);
        LayoutUtils.constrain(gridBagConstraints, this, this._street2TF, 0, 3, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 3, 5);
        this.add(this._street2TF);
        this._stateTF = new JTextField(new LetterOnlyDocument(2), "", 2);
        LayoutUtils.constrain(gridBagConstraints, this, this._stateTF, 1, 3, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 3, 5);
        this.add(this._stateTF);
        this._zipTF = new JTextField(new MaxLengthDocument(10), "", 5);
        LayoutUtils.constrain(gridBagConstraints, this, this._zipTF, 2, 3, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 3, 5);
        this.add(this._zipTF);
        Filler filler = new Filler();
        LayoutUtils.constrain(gridBagConstraints, this, filler, 3, 0, 1, 4, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.add(filler);
    }

    public boolean isValidInput() {
        if (this._street1TF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._street1TF, "Missing street data.");
            return false;
        }
        if (this._cityTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._cityTF, "Missing city data.");
            return false;
        }
        if (this._stateTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._stateTF, "Missing state data.");
            return false;
        }
        if (this._zipTF.getText().length() == 0) {
            ErrorMessage.showMessage((Component)this._zipTF, "Missing ZIP code data.");
            return false;
        }
        return true;
    }

    public void setStreet1(String string) {
        this._street1TF.setText(string);
    }

    public String getStreet1() {
        return this._street1TF.getText();
    }

    public void setStreet2(String string) {
        this._street2TF.setText(string);
    }

    public String getStreet2() {
        return this._street2TF.getText();
    }

    public void setCity(String string) {
        this._cityTF.setText(string);
    }

    public String getCity() {
        return this._cityTF.getText();
    }

    public void setState(String string) {
        this._stateTF.setText(string);
    }

    public String getState() {
        return this._stateTF.getText();
    }

    public void setZip(String string) {
        this._zipTF.setText(string);
    }

    public String getZip() {
        return this._zipTF.getText();
    }
}

